/*------------------------------------------------------------------------------*
 * File Name: OutputGUIManager.h												*
 * Creation: Iris 3/27/08														*
 * Purpose: Output GUI Events used in X-functions and and operations			*		
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES*
 * Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES					*
 * Iris 4/07/2008 QA80-10934-P2 ADD_DescStats_OUTPUT_CLASS						*
 * Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO		*
 * Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET			*
 * Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE				*
 * Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES										*
 * Jasmine 04/11/08 DUMP_NOTESWIN_DEFAULT_SET_NONE	                            *
 * Sophy 4/15/08 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION               *
 * Sophy 4/15/08 DISABLE_OUTPUT_FITTED_SHEET_WHEN_MULTIPLE_FITTED_RESULT_SHEET_IS_SEPARATE
 * Iris 4/15/2008 FIX_FIT_VALUE_BOOK_COMBO_ORDER_IS_CHANGED						*
 * Iris 4/15/2008 FIX_EMPTY_VAL_WHEN_THEME_INCLUDE_EXISTING_WITH_PAGE_NAME		*
 * Iris 4/16/2008 SHOULD_DISABLE_OTHERS_IF_REPORT_BOOK_IS_NODE					*
 * Sophy 4/16/2008 OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT 			*
 * Sophy 4/17/2008 MAKE_SURE_FINDXY_BRANCE_EXIST                                *
 * Sophy 4/17/2008 XYZGRIDDING_HAVE_NO_OUTPUT_NODE                              *
 * Sophy 4/17/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY                      *
 * Sophy 4/18/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY                      * 
 * Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE                             *
 * Sophy 4/21/2008 GET_SUB_TREENODE_BY_BACKUP_ID_RECURSIVE                      *
 * Sophy 10/9/2008 QA80-10536-P2 SET_CURVE_SHEET_ENABLE_STATE_FOLLOW_NEW_DESIGN *
 * Sophy 11/13/2008 v8.970 QA80-10731-P1 FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
 *	Hong 11/14/08 v8.0971b BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
 * Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
 * Sophy 12/1/2008 v8.0981 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
 * Sophy 12/19/2008 v8.0988c QA80-12798 SKIP_THEME_APPLIED_TO_OUTPUT_DISABLED_NODE_WHEN_CHANGE_PARAMS
 * Sophy 1/13/2009 v8.0995d QA80-10536-P15 SHEET_LEVEL_IN_OUTPUT_RESIDUAL_FOR_MATRIX_FIT_SHOULD_ONLY_HAVE_NEW
 * Sophy 2/2/2009 v8.0969 BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
 * Sophy 4/27/2009 QA80-13480 OUTPUT_SHEET_LEVEL_ONLY_ALLOW_NEW_FOR_MATRIX_FIT	*
 * Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
 * Sophy 7/9/2009 QA80-13910-P1 FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
 * Sophy 7/9/2009 QA80-13910-P2 NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
 * Sophy 7/17/2009 v8.0998-55 MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW	*
 * Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT					*
 *------------------------------------------------------------------------------*/
#ifndef _OUTPUT_GUI_MANAGER_H
#define _OUTPUT_GUI_MANAGER_H

#include <origin.h>
#include <event_utils.h>

#define STR_ATTRIB_OLD_COMBO_VAL 					"old_combo_val"
#define	STR_NAME_FOR_NEW_TYPE_ATTRIB				"NameForNew"
enum
{
	UPDATE_BOOK,
	UPDATE_SHEET,
	UPDATE_BOTH
};

enum
{
	RESULT_SHEET_COMBINED = 0,
	RESULT_SHEET_SEPARATE = 1
};

///Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
static string _make_special_type_str(string& strFirst, string& strSecond )
{
	string strRet;
	
	strRet = strFirst + STR_SPACE + strSecond;
	/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	//return strRet;
	return strSecond.IsEmpty()?strFirst:strRet;
	/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
}
///end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION

///Sophy 12/1/2008 v8.0981 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
static int _get_output_index_from_dataid(const int nDataID)
{
	switch(nDataID)
	{
	case IDST_REPORT_SHEET_OPTIONS:
		return OUTPUT_REPORT_SHEET_RNG_INDEX;
	case IDST_REPORT_CURVE_OPTIONS:
		return OUTPUT_RESULT_CURVE_FIT_CURVES_SHEET;
	case IDST_RESIDUAL_CURVE_OPTIONS:
		return OUTPUT_RESULT_CURVE_RESIDUAL_SHEET;
	case IDST_FIND_XY_OPTIONS:
		return OUTPUT_RESULT_CURVE_CALIBRATION_FIND_X_SHEET;
	case IDST_PARTIAL_CURVE_OPTIONS:
		return OUTPUT_PARTIAL_REGRESSION_CURVES_SHEET;
	case IDE_PFM_OUTPUT_SUBTRACTED_DATA_TO:
		return OUTPUT_RESULT_SUBTRACTED_DATA_SHEET;
	case IDE_PFM_OUTPUT_BASELINE_DATA_TO:
		return OUTPUT_RESULT_BASELINE_DATA_SHEET;
		
	default:
		break;
	}
	
	return -1; //unknown book sheet node
}

static int _get_output_index_of_one_node(const TreeNode& trNode)
{
	if( !trNode )
	{
		ASSERT(FALSE);
		return -1;
	}
	TreeNode trBookSheetBranch = trNode.Parent();
	int nOutputIndex = _get_output_index_from_dataid(trBookSheetBranch.DataID);
	if( nOutputIndex < 0 )//if can not resolve from DataID, try to resolve form BackupID
	{
		int nBackupID;
		if( trBookSheetBranch.GetAttribute(STR_BACKUP_ID_ATTRIB, nBackupID) )
			nOutputIndex = _get_output_index_from_dataid(nBackupID);
	}
	
	return nOutputIndex;
}
///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS

class OutputGUIManagerBase
{
public:
	OutputGUIManagerBase()
	{
	}
	
	OutputGUIManagerBase(bool bIsNLFitOutputEvent)
	{
	}
	
	~OutputGUIManagerBase()
	{
	}
	
	///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//bool 	ConstructOptions(TreeNode& trGUI, bool bAllowReportToSource, LPCSTR lpcszSourceBook);
	virtual bool 	ConstructOptions(TreeNode& trGUI);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	// events for Report.Book and Report.Sheet
	virtual bool 	OnReportBookChanged(TreeNode& tr);
	virtual bool	OnReportBookNameChanged( TreeNode& tr );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	virtual	bool	OnReportSheetChanged(TreeNode& tr);
	
	// events for Data.Book and Data.Sheet
	virtual bool 	OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow);
	virtual	bool	OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	virtual bool    OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow);
	virtual	bool	OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	
	bool	OnSheetChanged(TreeNode& trGUI, TreeNode& trReport, int nWksType);

	virtual bool 	OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook);

	bool 	OutputCurveBookEvent(TreeNode& trGUI, LPCSTR lpcszBook = NULL);
	
	bool	OnFittedResultSheetArrangementChanged(TreeNode& trGUI); ///Sophy 4/16/2008 OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT
	
	bool 	OnBookSheetNameChanged(TreeNode& trCurrentNode);
	
	virtual string 		GetOutputDestinationDefaultSetting(int nBookSheetType = IDE_REOPRT_BOOK);

	void	UpdateOutputReportAndCurveSetting(TreeNode& trGUI, LPCSTR lpcszSrcPageName);

	virtual 	void 	CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL, TreeNode& trOutput = NULL) { ASSERT(0) }
	
	virtual void	UpdateOutputOnDataChange(TreeNode& trGUI); ///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	
	///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
	// PA need call this two methods in pa_fit_before_execute in pa_fit xfunciton since PA always need FitPeak OP after finish and only _before_execute knowns which time is change parameter.
	virtual void		DisableOutputDestination( TreeNode& trOutput );
	void 				SetIsChangeParam(bool bChangeParam = true);
	///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS

	
protected:
	virtual TreeNode	GetGUITree(const TreeNode& tr);
	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	//void 				CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0);
	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	//void 				CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trBookSheetBranch, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0);
	bool 				CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trBookSheetBranch, const string& str2ndPart, const string& strReportBook, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL, int nBookSheetType = 0);
	///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	//virtual	bool 		UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL, int nOutputType = OPERATION_OUTPUT_GENERAL, int nBookSheetType = IDE_REOPRT_BOOK, int nOPType = OP_GENERAL_TOOL);
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	//virtual	bool 		UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL, int nBookSheetType = IDE_REOPRT_BOOK);
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//virtual	bool 		UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL);
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//virtual	bool 		UpdateOutputBookSheetDestination(TreeNode& trGUI, TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL);
	virtual	bool 		UpdateOutputBookSheetDestination(TreeNode& trGUI, TreeNode& trOutput, LPCSTR lpcszBookList = NULL, LPCSTR lpcszBookDefault = NULL, LPCSTR lpcszSheetList = NULL, LPCSTR lpcszSheetDefault = NULL, bool bCheckSourceCustom = false);
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///end CLEAN_UPDATE_COMBO_CODES
	///end CLEANUP_FIT_TYPE_CODES
	virtual	TreeNode 	GetNodeByTagname(TreeNode& trGUI, LPCSTR lpcszName);

	virtual bool		SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput);
	bool 				SetOutputBookName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch);	
	bool 				SetOutputSheetName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch);	
	virtual	void 		CheckWksOrMatrixBookSheet(int nID, bool& bWks); /// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 

	virtual	bool		IsAllowReportToSourceBook(TreeNode& trGUI);     /// Sophy 4/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	virtual bool		IsAllowToSourceSheet(TreeNode& trGUI, TreeNode& trSheet);			/// Sophy 5/04/2008 FIX_NLFIT_SHEET_SETTING_CANNOT_BE_SAVED_IN_THEME
	virtual	bool		IsAllowReportToSourceSheet(TreeNode& trGUI);
	///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	//virtual	bool		IsAllowCurveReportToSourceSheet(TreeNode& trOutput); /// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET	
	virtual	bool		IsAllowCurveReportToSourceSheet(TreeNode& trOutput, TreeNode& trSheet);
	///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	virtual	bool		IsAllowCurveReportToReportBook(TreeNode& trOutput); /// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO	
	///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	virtual bool		IsAllowToSourceBook( TreeNode& trGUI, TreeNode& trBook );
	virtual bool		IsAllowCurveReportToSourceBook( TreeNode& trGUI );
	///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	//use IsAllowCurveReportToSourceSheet alternatively
	//virtual bool		IsAllowCurveToSourceSheet( TreeNode& trGUI, TreeNode& trSheet);
	///end ///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	bool				IsAllowReportToReportBook(TreeNode& trOutput, int nOption = IDST_REPORT_CURVE_OPTIONS); /// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
	
	virtual string 		GetSourceBookName(TreeNode& trGUI,string* pstrSourceSheet=NULL);   ///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	virtual string		GetReportBookCombo(TreeNode& trGUI);
	/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
	//virtual string		MakeSpecialType(string& strFirst, string& strSecond);               ///Sophy 04/10/2008 MAKE_SPECIAL_TYPE
	/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
	bool				SetOneBookSheetName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch, int nToUpdate = UPDATE_BOTH);

	bool				CheckSourceEntryToUpdateCombo(TreeNode& trGUI, TreeNode& trNode, bool bIsBook); ///Sophy/Iris 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE	

	/// check other options to remove/add <Report> when Report.Book selected None
	bool				CheckUpdateOnNoReport(TreeNode& trGUI, TreeNode& trBookSheetBranch); /// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
	///Sophy 4/18/2008  GET_SUB_TREENODE_BY_ID_RECURSIVE
	virtual TreeNode	GetInputDataNode(const TreeNode& trGUI );
	virtual TreeNode	GetOutputNode(const TreeNode& trGUI );
	void				CheckUpdateSourceCustomEntry(TreeNode& trGUI, TreeNode& trNode, bool bIsBook); ///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	//bool				SetEnableAttribute( TreeNode& trGUI, TreeNode& trNode, bool bEnable = true ); //if enable status is changed ,return true, else return false;
	bool				SetEnableAttribute( TreeNode& trNode, bool bEnable = true ); //if enable status is changed ,return true, else return false;
	///end FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	/*
		This function is called to Update output sub branch such as Fitted Curve, Residual, FindXY, PartialCurves, etc.
		Say When Fitted Curve/Plot Data's Book is <report>, change book of Report Table calls for update on Fitted Curve Book&Sheet combo as well as name.
		         Residual Book is <fittedvalue>, change book of Fitted Curve calls for update on Residual Book&Sheet combo & name.
		If need to check Book combo, just set bCheckUpdateBook as true, meaning that this branch is updated because what it depends on changes.
	*/
	void	UpdateBranchOnBookChange( TreeNode& trGUI, TreeNode& trBookSheetBranch , bool bCheckUpdateBook = true );
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	void		DisableOutputBookSheetBranch( TreeNode& trBookSheetBranch ); ///Sophy 11/27/2008 moved from private
	bool		IsChangeParam(); ///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER

private:
	bool 		constructCurveBookSheetOptions(TreeNode& trGUI, bool bAllowReportToSource, LPCSTR lpcszSourceBook);
	/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	//bool 		buildReportBookOption(TreeNode& trBook, bool bAllowToSource = true, LPCSTR lpcszBook = NULL);
	bool 		buildReportBookOption(TreeNode& trGUI, TreeNode& trBook, bool bAllowToSource = true, LPCSTR lpcszBook = NULL);
	/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS, replace bAllowReportToSourceSheet with IsAllowReportToSourceSheet
	//void 		buildOutputBookSheetOption(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet = false, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL);
	void 		buildOutputBookSheetOption(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSrcBook = true, LPCSTR lpcszBook = NULL);
	///end ADD_DescStats_OUTPUT_CLASS
	/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
	//	bool 		updateOutputCurveBookSetting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook = NULL);
	//bool 		updateOutputCurveBookOption(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook = NULL);	
	bool 		updateOutputCurveBookSheetSetting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, LPCSTR lpcszBook = NULL);
	bool 		updateOutputCurveBookSheetOption(TreeNode& trGUI, int nCurveBookType, LPCSTR lpcszBook = NULL);	
	///end CLEANUP_FIT_TYPE_CODES
	
	/// Iris 04/10/2008 NO_REAL_SHEET_NAME_IN_REPORT_SHEET
	void 		updateCurveOnReportBookChange(TreeNode& trGUI, TreeNode& trOutput);
	void 		updateReportSheetOnBookChange(TreeNode& trGUI, TreeNode& trOutput);
	///end NO_REAL_SHEET_NAME_IN_REPORT_SHEET
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
	//void		disableOutputDestination( TreeNode& trOutput );
	///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
	//void		disableOutputBookSheetBranch( TreeNode& trBookSheetBranch ); to protected
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	
	/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS set as public
	//void 		setIsChangeParam(bool bChangeParam = true);
	///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
	//bool		isChangeParam();///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER move to preotected
	///end FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT

	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	//void 		showReportColumnOption(TreeNode& trGUI);
	///end ADD_DescStats_OUTPUT_CLASS

	BOOL 		checkNodeStrvalWithComboItems(TreeNode& tn, LPCSTR lpcszDefault);
	void 		getLayerNameFromPage(vector<string> &vsLayerList, string &strPageName);
	void 		checkCorrectOutputOption(TreeNode& trOutput, LPCSTR lpcszCorrect = NULL);
	string    	getSelectedStringFromCombolist(TreeNode &trList);
	
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	//void 		checkWksOrMatrixBookSheet(int nOutputType, int nID, bool& bWks);
	//void		getSelectedBookSheetName(const TreeNode& trBook, const TreeNode& trSheet = NULL, int nOutputType = OPERATION_OUTPUT_GENERAL, int nBookSheetType = IDE_REOPRT_BOOK, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	//void		getSelectedBookSheetName(const TreeNode& trBook, const TreeNode& trSheet = NULL, int nBookSheetType = IDE_REOPRT_BOOK, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
	//bool 		updateOutputDestination(TreeNode& trN, LPCSTR lpcszList, LPCSTR lpcszDefault, bool bIsBook, int nBookSheetType);
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//bool 		updateOutputDestination(TreeNode& trNode, bool bIsBook, LPCSTR lpcszList = NULL, LPCSTR lpcszDefault = NULL);
	bool 		updateOutputDestination(TreeNode& trGUI, TreeNode& trNode, bool bIsBook, LPCSTR lpcszList = NULL, LPCSTR lpcszDefault = NULL, bool bCheckSourceCustom = false);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//bool		checkGetSpecialBookSheetName(const TreeNode& trBook, const TreeNode& trSheet = NULL, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
	///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	//bool		checkGetSpecialBookSheetName(const TreeNode& trBookName, const TreeNode& trSheetName = NULL, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL);
	bool		checkGetSpecialBookSheetName(const TreeNode& trBookSheetBranch, const TreeNode& trSheetName = NULL, string& strSelectedBookName = NULL, string& strSelectedSheetName = NULL, bool bIsBook = false);
	///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	///end CLEANUP_FIT_TYPE_CODES
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//void		checkUpdateSourceCustomEntry(TreeNode& trNode, bool bIsBook);
	//void		checkCustomEntryToUpdateCombo(TreeNode& trNode, bool bIsBook); /// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	//void		checkSourceEntryToUpdateCombo(TreeNode& trNode, bool bIsBook); ///Sophy/Iris 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE	
	//void		checkUpdateSourceCustomEntry(TreeNode& trGUI, TreeNode& trNode, bool bIsBook); ///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE //change as protected
	void		checkCustomEntryToUpdateCombo(TreeNode& trGUI, TreeNode& trNode, bool bIsBook); /// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	void		checkUpdateSheetComboOnBookChanged( TreeNode& trGUI, TreeNode& trBookSheetBranch); ///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	/// Iris 4/01/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	string 		getNameForNewType(TreeNode& trName);
	string 		getBookNameByType(const TreeNode& trGUI, const TreeNode& trOutput, const TreeNode& trBookSheetBranch, int nBookType, LPCSTR lpcsz2ndPart, bool* pbBookNameEnable);	
	string		getSheetNameByType(TreeNode& trGUI, TreeNode& trBookSheetBranch, int nSheetType, LPCSTR lpcsz2ndPart, bool* pbSheetNameEnable);	
	bool		setReportBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH);
	bool		setCurveBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH);	
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	
	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	//bool 		openCustomInputBox(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL);
	//string 	getFitCurvePageName(TreeNode& trGUI);  //get result curve page name
	//above two functions replaced by getOutputBookName;
	//string 	getReportPageName(TreeNode& trGUI);	
	bool		openCustomInputBox(TreeNode& trBookSheetBranch, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL );
	string		getOutputBookName(TreeNode& trBookSheetBranch );
	bool		isBookExist( LPCSTR lpcszBookName );
	///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	
	int 		checkGetXFDataBranch(TreeNode &trGUI, TreeNode& trNode, TreeNode &trData, int nRow);
	TreeNode	getXFunctionTreeNodeFromDataNode(TreeNode& trData);
	void		xvarsBuildDataBranch(TreeNode &trData, string &strSourcePage, string &strSourceLayer);
	string 		buildContextList(vector<string> vsList, LPCSTR lpcszSource = NULL, int nBookType = PDS_NEW, bool bIsPageList = true);
	string 		buildPageContextList( LPCSTR lpcszSource, uint nPageType  = EXIST_WKS, int nBookType = PDS_NEW);
	string 		buildLayerContextList( LPCSTR lpcszSource,LPCSTR lpcszPageName , int nBookType = PDS_NEW);

	
	BOOL 		isStrToken(LPCSTR lpcszFind, LPCSTR lpcszTokens, char chDelimiter = 0);
	/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
	//bool 		isStatsOnRows(TreeNode& trGUI);
	///end ADD_DescStats_OUTPUT_CLASS
	///Sophy 11/28/2008 KEEP_PA_OUTPUT_BRANCH_ENABLE_WHEN_HASNOT_BEEN_REPORTED
	bool		hasOutputReported(const TreeNode& trNode, const int nOutputRangeIndex);
	///end KEEP_PA_OUTPUT_BRANCH_ENABLE_WHEN_HASNOT_BEEN_REPORTED
	
private:
	bool		m_bChangeParam; /// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
};

/// Iris 5/27/2008 v8.0871 NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA
class ANOVAOutputGUIManager : public OutputGUIManagerBase
{
public:
	ANOVAOutputGUIManager()
	{
	}
	~ANOVAOutputGUIManager()
	{
	}
	
protected:	
	//virtual 
	bool		IsAllowReportToSourceBook(TreeNode& trGUI); 
	
	//virtual
	string 		GetSourceBookName(TreeNode& trGUI, string* pstrSourceSheet=NULL);  
};
///end NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA


/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
class DescStatsOutputGUIManager : public OutputGUIManagerBase
{
public:
	DescStatsOutputGUIManager()
	{
	}
	~DescStatsOutputGUIManager()
	{
	}
	
	//virtual	
	bool	OnReportSheetChanged(TreeNode& tr);
	
	//virtual 
	bool 	OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook);
	
	//virtual
	string 		GetOutputDestinationDefaultSetting(int nBookSheetType);	 /// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
	
protected:
	//virtual 
	bool 	IsAllowReportToSourceSheet(TreeNode& trGUI);
	/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	//virtual
	string  GetReportBookCombo(TreeNode& trGUI);
	/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
private:
	bool	isStatsOnRows(TreeNode& trGUI);
	void 	showReportColumnOption(TreeNode& trGUI);
	
};
///end ADD_DescStats_OUTPUT_CLASS
	

class FitOutputGUIManager : public OutputGUIManagerBase
{
public:
	FitOutputGUIManager()
	{
	}
	
	~FitOutputGUIManager()
	{
	}
	
	//virtual
	bool 	OnReportBookChanged(TreeNode& tr);
	///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	//virtual
	bool	OnReportBookNameChanged( TreeNode& tr );
	///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	//virtual
	bool 	OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow);
	//virtual 
	bool	OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	
	//virtual
	bool 	OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow);
	//virtual
	bool	OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	
	bool 	OnResidualBookChanged(TreeNode& tr);
	bool	OnResidualSheetChanged(TreeNode& tr); 
	bool	OnFindXYBranchChanged(TreeNode& tr, int nRow);
	bool 	OnFindXYBookChanged(TreeNode& tr);	
	bool	OnFindXYSheetChanged(TreeNode& tr); 
	
	//virtual 	
	void 	CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL, TreeNode& trOutput = NULL);
	
	//virtual
	string 		GetOutputDestinationDefaultSetting(int nBookSheetType);
	
	//virtual
	void	UpdateOutputOnDataChange(TreeNode& trGUI);  /// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
	
	///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
	//virtual
	void		DisableOutputDestination( TreeNode& trOutput );
	///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS

	
protected:	
	virtual string 	GetResidualCurveBookDefaultSetting();
	virtual string 	GetResidualCurveSheetDefaultSetting();
	virtual string 	GetFindXYBookDefaultSetting();
	virtual string 	GetFindXYSheetDefaultSetting();
	
	//virtual 
	//string		GetReportBookCombo(TreeNode& trGUI); /// Iris 5/27/2008 v8.0871 NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA	
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	virtual void 	GetResidualCombo(string& strBook, string& strSheet);
	virtual void 	GetFindXYCombo(string& strBook, string& strSheet); 
	void 		GetResidualCombo(bool bPlotFitCurve, string& strResidualBookCombo, string& strResidualSheetCombo);
	void 		GetFindXYCombo(bool bPlotFitCurve, string& strFindXYBookCombo, string& strFindXYSheetCombo);
	///end CLEANUP_FIT_TYPE_CODES
	
	//virtual
	bool		SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput);
	
	//virtual		int GetFitType() { return NLFIT_GENERAL_XY_FITTING; }///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE

	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//virtual		int GetOutputType() { return OPERATION_OUTPUT_GENERAL; }
	virtual		int GetOutputType() { return EXIST_WKS; }
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	
	bool 		IsPlotFitCurve(const TreeNode& trGUI);

private:	
	
	bool		setResidualBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH);	
	bool		setFindXYBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH);
	
};

class NLFitOutputGUIManager : public FitOutputGUIManager
{
public:
	NLFitOutputGUIManager()
	{
	}
	
	~NLFitOutputGUIManager()
	{
	}
protected:
	///Sophy 4/17/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY no need to rewrite this virtual function
	////virtual	
	//TreeNode 	GetNodeByTagname(TreeNode& trGUI, LPCSTR lpcszName);
	///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
	//virtual
	TreeNode	GetGUITree(const TreeNode& tr);

	///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	/*
	/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	//virtual 
	TreeNode	GetInputDataNode(const TreeNode& trGUI );

	//virtual
	TreeNode 	GetOutputNode(const TreeNode& trGUI); 
	///end FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	*/
	///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
};

class SurfaceFitOutputGUIManager : public NLFitOutputGUIManager
{
public:
	SurfaceFitOutputGUIManager()
	{
	}
	
	~SurfaceFitOutputGUIManager()
	{
	}	
	
	//virtual 	
	void 		CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL, TreeNode& trOutput = NULL);  /// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	void		LoadFactroyDefaultSetting( TreeNode& trGUI );///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
protected:
	//virtual 
	string 		GetResidualCurveSheetDefaultSetting();
	
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	//virtual
	void 		GetResidualCombo(string& strBook, string& strSheet);
	//virtual
	void 		GetFindXYCombo(string& strBook, string& strSheet); 	
	//virtual
	//int 		GetFitType() { return NLFIT_XYZ_FITTING; }	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//virtual		
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//int 		GetOutputType() { return OPERATION_OUTPUT_XYZ_FITTING; }
	int 		GetOutputType() { return EXIST_WKS; }
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	///end CLEANUP_FIT_TYPE_CODES	
	
	//virtual 
	string		GetReportBookCombo(TreeNode& trGUI); /// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES

private:
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	//void 		updateXYZFittingResidualOrFindZSetting(TreeNode& tr, int nOutputType, int nBookSheetType);
	///end CLEANUP_FIT_TYPE_CODES

};

///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
class MROutputGUIManager: public FitOutputGUIManager
{
public:
	
	///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	//virtual
	bool		OnReportBookChanged(TreeNode& tr);
	//virtual
	bool		OnReportBookNameChanged( TreeNode& tr );
	///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

	//virtual
	bool 		OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow);
	//virtual
	bool		OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	bool		OnPartialCurvesBookChanged( TreeNode& tr );
	//virtual
	bool		OnCurveSheetChanged( TreeNode& tr, TreeNode& trSheet, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	//virtual
	bool		OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow );///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE	
	
	bool		OnPartialCurvesSheetChanged( TreeNode& tr );
	//virtual
	void		UpdateOutputOnDataChange( TreeNode& trGUI );
	
protected:
	
private:
	bool		setPartialCurvesBookSheetName( TreeNode& trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH );
};
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE

class MatrixFitOutputGUIManager : public NLFitOutputGUIManager
{
public:
	MatrixFitOutputGUIManager()
	{
	}
	
	~MatrixFitOutputGUIManager()
	{
	}
	
	//virtual 	
	void 		CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL, TreeNode& trOutput = NULL);  /// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
protected:
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	//virtual
	void 		GetResidualCombo(string& strBook, string& strSheet);
	//virtual
	void 		GetFindXYCombo(string& strBook, string& strSheet); 	
	//virtual
	//int 		GetFitType() { return NLFIT_MATRIX_FITTING; }	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//virtual		
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//int 		GetOutputType() { return OPERATION_OUTPUT_MAT_FITTING; }	
	int 		GetOutputType() { return EXIST_MATRIX; }	
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	//virtual	
	void 		CheckWksOrMatrixBookSheet(int nID, bool& bWks); 
	///end CLEANUP_FIT_TYPE_CODES
	
	//virtual	
	bool		IsAllowReportToSourceBook(TreeNode& trGUI);     /// Sophy 4/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	////virtual
	//bool		IsAllowCurveReportToSourceSheet(TreeNode& trOutput);  /// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET	
	//virtual
	bool		IsAllowCurveReportToSourceSheet(TreeNode& trOutput, TreeNode& trSheet);	
	///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
	//virtual
	bool		IsAllowCurveReportToReportBook(TreeNode& trOutput);  /// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
};

class PeakFitOutputGUIManager : public NLFitOutputGUIManager
{
public:
	PeakFitOutputGUIManager()
	{
	}
	
	~PeakFitOutputGUIManager()
	{
	}
	
	//virtual
	bool	ConstructOptions(TreeNode& trGUI);
	
	//virtual 
	string 		GetOutputDestinationDefaultSetting(int nBookSheetType = IDE_REOPRT_BOOK);
	
	//virtual 
	void	UpdateOutputOnDataChange(TreeNode& trGUI);  /// Iris 4/14/2008 ADD_OR_REMOVE_SOURCE_ENTRY_FOR_OUTPUT_COMBO_ON_DATA
	
	//virtual 
	bool 	OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook); /// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
	
	bool	OnPeakCharacterBookChanged(TreeNode& tr);
	
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	bool	OnSubtractedBookChanged(TreeNode& tr);
	bool	OnSubtractedSheetChanged(TreeNode& tr);
	bool	OnBaselineBookChanged(TreeNode& tr);
	bool	OnBaselineSheetChanged(TreeNode& tr);
	//virtual
	bool 	OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow);
	//virtual	
	bool	OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow );
	//virtual 
	bool    OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow);
	//virtual	
	bool	OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow );
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	
	///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
	//virtual
	void		DisableOutputDestination( TreeNode& trOutput );
	///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS

protected:	
	//virtual 
	bool	SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput);
	///Sophy 4/21/2008 GET_SUB_TREENODE_BY_BACKUP_ID_RECURSIVE
	//virtual
	//TreeNode GetOutputNode(const TreeNode& trGUI );///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	///end GET_SUB_TREENODE_BY_BACKUP_ID_RECURSIVE

private:
	void	buildUpdatePeakCharacterOptions(TreeNode& trGUI);
	
	bool	setPeakCharacterBookSheetName(TreeNode&trGUI, TreeNode& trOutput, int nToUpdate = UPDATE_BOTH);

	 /// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	bool    onBookChanged(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trCurrent);
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	
};

class XYZ2MatOutputGUIManager : public OutputGUIManagerBase
{
public:
	XYZ2MatOutputGUIManager()
	{
	}
	
	~XYZ2MatOutputGUIManager()
	{
	}

protected:
	//virtual 
	void	CheckWksOrMatrixBookSheet(int nID, bool& bWks);	
	
	//virtual 
	bool	IsAllowReportToSourceBook(TreeNode& trGUI);	
	
	//virtual 
	string	GetReportBookCombo(TreeNode& trGUI);
	
	//virtual 
	string 		GetOutputDestinationDefaultSetting(int nBookSheetType = IDE_REOPRT_BOOK);	
};


/**
Get workbook's name chosen by user
*/
//virtual
string 	OutputGUIManagerBase::GetSourceBookName(TreeNode& trGUI, string* pstrSourceSheet)
{
	///Sophy 6/26/2008 FIX_FAIL_TO_GET_INPUTDATA_TREENODE
	//return get_source_page_name(trGUI, pstrSourceSheet);
	TreeNode trInputData = GetInputDataNode( trGUI );
	if( !trInputData )
		trInputData = GetInputDataNode( GetGUITree( trGUI ) );//in NLFit, the structure of GUI tree might be a little different
	return get_source_page_name( trGUI, pstrSourceSheet, trInputData );
	///end FIX_FAIL_TO_GET_INPUTDATA_TREENODE
}

/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
//virtual
//string OutputGUIManagerBase::MakeSpecialType(string& strFirst, string& strSecond)
//{
	//string strRet;
	//
	//strRet = strFirst + STR_SPACE + strSecond;
	//
	//return strRet;
//}
/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
/**
Check whether allow to output report to source workbook in fitting dilog
*/
//virtual
bool	OutputGUIManagerBase::IsAllowReportToSourceBook(TreeNode& trGUI)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//return is_range_from_normal_book(GetNodeByTagname(trGUI,"InputData"));
	return is_range_from_normal_book( GetInputDataNode( trGUI) );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
}

///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
//bool OutputGUIManagerBase::ConstructOptions(TreeNode& trGUI, bool bAllowReportToSource, LPCSTR lpcszSourceBook)
bool OutputGUIManagerBase::ConstructOptions(TreeNode& trGUI)
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
{
	_DBCLASS("OutputGUIManagerBase::ConstructOptions")
	///Sophy 4/18/2008  GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	///Sophy 4/17/2008 XYZGRIDDING_HAVE_NO_OUTPUT_NODE
	//ASSERT(trOutput);
	if( !trOutput )
		return false;
	///end XYZGRIDDING_HAVE_NO_OUTPUT_NODE
	TreeNode trOutputBook = trOutput.Report.Book;
	TreeNode trOutputSheet = trOutput.Report.Sheet;
	ASSERT(trOutputBook);
	ASSERT(trOutputSheet);
	
	///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	bool bAllowReportToSource = IsAllowReportToSourceBook(trGUI);
	string	strSourceSheet;
	string	strSourceBook = GetSourceBookName(trGUI,&strSourceSheet);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	
	if(trOutputBook) /// Iris 4/14/2008 FIX_XYZGRIDDING_NO_REPORT_NODE_CAUSE_RUNTIME_ERR
	{	
		//bool WksReportOperation::setReportOutputBook(TreeNode& trBook, const string& strBook, bool bAllowToSource)
		trOutputBook.SetAttribute( STR_ALLOW_REPORT_TO_SOURCE_BOOK_ATTRIB, bAllowReportToSource);
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//buildReportBookOption(trOutputBook, bAllowReportToSource,lpcszSourceBook);
		/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
		//buildReportBookOption(trOutputBook, bAllowReportToSource, strSourceBook);
		buildReportBookOption(trGUI, trOutputBook, bAllowReportToSource, strSourceBook);
		/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//checkUpdateSourceCustomEntry(trGUI, trOutputBook, true);	/// Iris 4/15/2008 FIX_EMPTY_VAL_WHEN_THEME_INCLUDE_EXISTING_WITH_PAGE_NAME
		CheckUpdateSourceCustomEntry(trGUI, trOutputBook, true);
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	}
	
	// Prepare Combo list and value for Sheet node
	if(trOutputSheet) /// Iris 4/14/2008 FIX_XYZGRIDDING_NO_REPORT_NODE_CAUSE_RUNTIME_ERR
	{
		string strSheets = STR_NEW + STR_TOKEN_SEP;
		/// Iris 04/10/2008 NO_REAL_SHEET_NAME_IN_REPORT_SHEET
		//if(bAllowReportToSource)
		//	strSheets += STR_SOURCE_BOOK;
		if( IsAllowReportToSourceSheet(trGUI) )
			///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
			//strSheets += STR_SOURCE_BOOK + " " + strSourceSheet;
			/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			//strSheets += MakeSpecialType(STR_SOURCE_BOOK, strSourceSheet);
			strSheets += _make_special_type_str( STR_SOURCE_BOOK, strSourceSheet );
			/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			///end MAKE_SPECIAL_TYPE
		///end NO_REAL_SHEET_NAME_IN_REPORT_SHEET	
		trOutputSheet.SetAttribute(STR_COMBO_ATTRIB, strSheets);	
		if(trOutputSheet.IsEmpty())
		{
		/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
		//	trOutputSheet.strVal = STR_NEW;	
		trOutputSheet.strVal = GetOutputDestinationDefaultSetting(trOutputSheet.DataID);
		///end CENTRLIZE_SET_DEFAULT_VALUES_CODES
		}
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE	
		//checkUpdateSourceCustomEntry(trGUI, trOutputSheet, false);	/// Iris 4/15/2008 FIX_EMPTY_VAL_WHEN_THEME_INCLUDE_EXISTING_WITH_PAGE_NAME
		CheckUpdateSourceCustomEntry(trGUI, trOutputSheet, false);
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	}

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//if(trOutput.Data)
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	if ( trData )
	///end OP_DLG_NEW_STRUCTURE
	{
		/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		//setCurvesOutputBookSheet(trGUI, bAllowReportToSource, lpcszSourceBook);
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//constructCurveBookSheetOptions(trGUI, bAllowReportToSource, lpcszSourceBook);
		constructCurveBookSheetOptions(trGUI, bAllowReportToSource, strSourceBook);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		
		/// Iris 4/15/2008 FIX_EMPTY_VAL_WHEN_THEME_INCLUDE_EXISTING_WITH_PAGE_NAME
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//checkUpdateSourceCustomEntry(trGUI, trOutput.Data.Book, true);	
		//checkUpdateSourceCustomEntry(trGUI, trOutput.Data.Sheet, false);
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		//Already check&update in constructCurveBookSheetOptions->buildOutputBookSheetOption->UpdateBranchOnBookChange, so no need to check&update here
		/*
		CheckUpdateSourceCustomEntry(trGUI, trOutput.Data.Book, true);	
		CheckUpdateSourceCustomEntry(trGUI, trOutput.Data.Sheet, false);
		*/
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		///end FIX_EMPTY_VAL_WHEN_THEME_INCLUDE_EXISTING_WITH_PAGE_NAME
	}
	
	SetAllOutputBookSheetNames(trGUI, trOutput); /// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	//--- CPY 9/2/04, Notes window drop down
	/// Iris 11/04/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trNotes = trOutput.Report.DumpNotesWindow;
	TreeNode trNotes = OP_GUI_OUTPUT_TO_NOTES_CHECKBOX(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trNotes);
	if(trNotes) /// Iris 4/14/2008 FIX_XYZGRIDDING_NO_REPORT_NODE_CAUSE_RUNTIME_ERR
	{		
		string strNotesList = STR_TOKEN_SEP;
		strNotesList += STR_NONE + STR_TOKEN_SEP + STR_NEW;
		trNotes.SetAttribute(STR_COMBO_ATTRIB, strNotesList);
	}
	//---	
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	int nChangeParam = 0;
	if( trOutput.GetAttribute( STR_CHANGE_PARAM_ATTRIB, nChangeParam ) && 1 == nChangeParam )
	{
		///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS should disable output branch before update change param status
		//disableOutputDestination( trOutput );
		DisableOutputDestination( trOutput );
		///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
		SetIsChangeParam(nChangeParam); /// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
	}
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	return true;	
}

/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
void 	OutputGUIManagerBase::SetIsChangeParam(bool bChangeParam)
{
	m_bChangeParam = bChangeParam;
}

///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
//bool	OutputGUIManagerBase::isChangeParam()
bool	OutputGUIManagerBase::IsChangeParam()
///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
{
	return m_bChangeParam;
}
///end FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT

//moved from WksReportOperation::setCurvesOutputBookSheet
bool OutputGUIManagerBase::constructCurveBookSheetOptions(TreeNode& trGUI, bool bAllowReportToSource, LPCSTR lpcszSourceBook)
{
	_DBCLASS("OutputGUIManagerBase::constructCurveBookSheetOptions")
    ///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trCurves = trOutput.Data;
	TreeNode trCurves = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	if(!trCurves)
		return false;

	
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS, clean the old logic
	//int nSpecialType;
	//bool bNoReport = (nSpecialType==PDS_NONE || nSpecialType==PDS_SOURCE)? true:false;
	//if(trCurves.Book.IsEmpty())
	//{
		//trCurves.Book.strVal = STR_AUTO;	
		//if(bNoReport)
		//{
			//trCurves.Sheet.strVal = STR_NEW;
		//}
		//else
		//{
			//trCurves.Sheet.strVal = STR_NEW;
		//}
	//}
	//else if(trCurves.Sheet.strVal.IsEmpty())
	//{
		//trCurves.Sheet.strVal = STR_NEW;
	//}	
	int nReportBookType = str_to_predefined_type(trOutput.Report.Book.strVal);
	
	if(trCurves.Book.IsEmpty())
	{
	/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
		//trCurves.Book.strVal = STR_AUTO;	
		trCurves.Book.strVal = GetOutputDestinationDefaultSetting(trCurves.Book.DataID);
	///end CENTRLIZE_SET_DEFAULT_VALUES_CODES
	}
	
	if(trCurves.Sheet.strVal.IsEmpty())
	{
	/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
		//trCurves.Sheet.strVal = STR_NEW;
		trCurves.Sheet.strVal = GetOutputDestinationDefaultSetting(trCurves.Sheet.DataID);
		///end CENTRLIZE_SET_DEFAULT_VALUES_CODES
	}
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		
	string str2ndPart;
	int nCurveBookType = str_to_predefined_type(trCurves.Book.strVal, str2ndPart);
	
	if(PDS_SOURCE == nCurveBookType)
	{
		string strReportSourceBook = STR_SOURCE_BOOK;
		if(lpcszSourceBook)
		{
			string strSourceBook(lpcszSourceBook);
			///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
			//strReportSourceBook += " " + strSourceBook;
			/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			//strReportSourceBook = MakeSpecialType(STR_SOURCE_BOOK, strSourceBook);
			strReportSourceBook = _make_special_type_str(STR_SOURCE_BOOK, strSourceBook );
			/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			///end MAKE_SPECIAL_TYPE
		}
		trCurves.Book.strVal = strReportSourceBook; 
	}
	
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS, replace bAllowReportToSourceSheet with IsAllowReportToSourceSheet
	//buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, false, bAllowReportToSource, lpcszSourceBook); 
	buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, bAllowReportToSource, lpcszSourceBook); 
	///end ADD_DescStats_OUTPUT_CLASS

	return true;
}

bool OutputGUIManagerBase::OnReportBookChanged(TreeNode& tr)
{
	_DBCLASS("OutputGUIManagerBase::OnReportBookChanged")
	TreeNode 	trGUI = GetGUITree(tr);
	
	return OutputReportBookEvent(trGUI, NULL);
}
///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool	OutputGUIManagerBase::OnReportBookNameChanged( TreeNode& tr )
{
	TreeNode	trGUI = GetGUITree( tr );
	TreeNode	trOutput = GetOutputNode( trGUI );
	ASSERT( trOutput );
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.Data && PDS_REPORT == str_to_predefined_type( trOutput.Data.Book.strVal ) )
	{
		setCurveBookSheetName( trGUI, trOutput );
		
		return true; //notify Residual or FindXY or PartialCurves to update if exists any one
	}
	*/
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	if ( trData && PDS_REPORT == str_to_predefined_type( trData.Book.strVal ) )
	{
		setCurveBookSheetName(trGUI, trOutput);
		return true;
	}
	///end OP_DLG_NEW_STRUCTURE
	return false;
}
bool OutputGUIManagerBase::OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow)
{
	_DBCLASS("OutputGUIManagerBase::OnCurveBookChanged")

	TreeNode trGUI = GetGUITree(tr);
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);	

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trData = trOutput.Data;
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	int			nDBTY = checkGetXFDataBranch(tr, trBook, trData, nRow);
	ASSERT(trData);	
	
	TreeNode trRootNode;
	if( nDBTY == DBTY_X_FUNC_VAR )
		trRootNode = getXFunctionTreeNodeFromDataNode(trData);
	else
		trRootNode = trGUI;
	
	if( !trRootNode )
	{
		/// YuI 10/03/05 XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
		//	return error_report("Root node cannot be found!");
		// even though tree is not complete XFunctiuon tree (GetN tree for instance)
		// we still need to provide basic support for <new> and <same> for book sheet
		if( DBTY_X_FUNC_VAR == nDBTY )
		{
			string strTemp1;
			string strTemp2;
			xvarsBuildDataBranch(trData, strTemp1, strTemp2);
			return true;
		}
		else
			return error_report("OutputGUIManagerBase::OnCurveBookChanged Root node cannot be found!");
		/// end XVARIABLE_GETN_TRANSLATION_IMPROVEMENT
	}
	
	int nCurveBookType;
	string str2ndPart;
	/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
	//updateOutputCurveBookSetting(trRootNode, trData, nCurveBookType, str2ndPart);	
	updateOutputCurveBookSheetSetting(trRootNode, trData, nCurveBookType);
	///end CLEANUP_FIT_TYPE_CODES
	
	if (DBTY_X_FUNC_VAR == nDBTY)
	{
		string	strSourceSheet; 
		string strSourceBook;
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//strSourceBook = get_source_page_name(trRootNode, &strSourceSheet);
		strSourceBook = GetSourceBookName(trRootNode, &strSourceSheet);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		xvarsBuildDataBranch(trData, strSourceBook, strSourceSheet);
		return true;
	}

	/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
	//updateOutputCurveBookOption(tr, str2ndPart, nCurveBookType);
	///Sophy 4/18/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY tr don't have InputData subnode in NL Fitting case
	//updateOutputCurveBookSheetOption(tr, nCurveBookType);
	updateOutputCurveBookSheetOption(trRootNode, nCurveBookType);
	///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
	///end CLEANUP_FIT_TYPE_CODES 
	///Sophy 4/18/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
	//setCurveBookSheetName(tr, trOutput);/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	setCurveBookSheetName(trRootNode, trOutput);/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	//trData.Sheet.Enable = isBookExist(trData.BookName.strVal);
	///Sophy 9/8/2008 FIX_SHEET_COMBO_ENABLED_WHEN_APPLY_THEME_WITH_BOOK_AS_NEW
	//SetEnableAttribute(trData.Sheet, isBookExist(trData.BookName.strVal) );
	///Sophy 10/9/2008 QA80-10536-P2 SET_CURVE_SHEET_ENABLE_STATE_FOLLOW_NEW_DESIGN
	//SetEnableAttribute(trData.Sheet,( PDS_NEW != nCurveBookType ) && isBookExist(trData.BookName.strVal) );
	
	///Sophy 7/9/2009 QA80-13910-P1 FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	//SetEnableAttribute(trData.Sheet,( PDS_SOURCE == nCurveBookType || PDS_CUSTOM == nCurveBookType ) && isBookExist(trData.BookName.strVal) );
#ifndef	__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	SetEnableAttribute(trData.Sheet,( PDS_SOURCE == nCurveBookType || PDS_CUSTOM == nCurveBookType ) && isBookExist(trData.BookName.strVal) );
#else
	str_to_predefined_type(trData.Book.strVal, str2ndPart);
	SetEnableAttribute(trData.Sheet,( PDS_SOURCE == nCurveBookType && isBookExist(trData.BookName.strVal) ) || ( PDS_CUSTOM == nCurveBookType && isBookExist(str2ndPart) )  );
#endif	//__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	///end FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	///end SET_CURVE_SHEET_ENABLE_STATE_FOLLOW_NEW_DESIGN
	///end FIX_SHEET_COMBO_ENABLED_WHEN_APPLY_THEME_WITH_BOOK_AS_NEW
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION

	return true;
}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool	OutputGUIManagerBase::OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow )
{
	return true;
}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool 	OutputGUIManagerBase::OnSheetChanged(TreeNode& trGUI, TreeNode& trBookSheetBranch, int nWksType)
{
	if(!trBookSheetBranch)
		return false;
	
	string 	strReportSheet = trBookSheetBranch.Sheet.strVal;		
	string 	strReportBook = trBookSheetBranch.Book.strVal;
	
	int nType;
	string str2ndPart;
	nType = str_to_predefined_type(strReportSheet, str2ndPart);	
	switch(nType)
	{
	case PDS_CUSTOM:		
		//int nWksType = WKS_REPORT_TABLE; /// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)
			nWksType = WKS_DATA_SHEET;
		
		/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		//check_ask_custom_book_sheet_name(trGUI, trReport.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType, 0, bIsNLFitOutputEvent);
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//CheckAskCustomBookSheetName(trGUI, trBookSheetBranch.Sheet, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType, trBookSheetBranch.Sheet.DataID);
		CheckAskCustomBookSheetName(trGUI, trBookSheetBranch, str2ndPart, strReportBook, true, DBTY_CURVE_OUTPUT, nWksType, trBookSheetBranch.Sheet.DataID);		
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
		
		string strSheet = trBookSheetBranch.Sheet.strVal;
		if ( compare_string_localization(strSheet, STR_CUSTOM_E + STR_THREE_DOTS, true) )
			trBookSheetBranch.Sheet.strVal = STR_NEW;
		break;
	default:
		break;
	}
	
	return true;
}

bool	OutputGUIManagerBase::OnReportSheetChanged(TreeNode& tr)
{
	_DBCLASS("OutputGUIManagerBase::OnReportSheetChanged")

	TreeNode trGUI = GetGUITree(tr);
	
	TreeNode 	trReport = tr.Output.Report;
	bool bRet = OnSheetChanged(trGUI, trReport, WKS_REPORT_TABLE);
	if( bRet )
	{
		setReportBookSheetName(trGUI, tr.Output, UPDATE_SHEET);/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	}
	
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	//showReportColumnOption(trGUI);
	///end ADD_DescStats_OUTPUT_CLASS
	return bRet;
}

bool	OutputGUIManagerBase::OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow)
{
	_DBCLASS("OutputGUIManagerBase::OnCurveSheetChanged")

	TreeNode trGUI = GetGUITree(tr);

	TreeNode 	trOutput = tr.Output;
	if(!trOutput)
		///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
		//trOutput = tree_get_node_by_tagname(tr, "Output", true);
		trOutput = GetOutputNode( trGUI );
		///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trData = trOutput.Data;	
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	int			nDBTY = checkGetXFDataBranch(tr, trSheet, trData, nRow);
	
	TreeNode 	trRootNode;
	if( nDBTY == DBTY_X_FUNC_VAR )
		trRootNode = getXFunctionTreeNodeFromDataNode(trData);
	else
		trRootNode = trGUI;
	
	if( !trRootNode )
		return true;
	
	bool bRet = OnSheetChanged(trRootNode, trData, WKS_DATA_SHEET);
	if(bRet)
	{
		setCurveBookSheetName(tr, trOutput, UPDATE_SHEET);/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	}
	return bRet;

}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool	OutputGUIManagerBase::OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow )
{
	return true;
}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
//bool update_output_book_sheet_destination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault)
/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
//bool 	OutputGUIManagerBase::UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault, int nOutputType, int nBookSheetType, int nOPType)
/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
//bool 	OutputGUIManagerBase::UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault, int nBookSheetType)
///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
//bool 	OutputGUIManagerBase::UpdateOutputBookSheetDestination(TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault)
///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
//bool 	OutputGUIManagerBase::UpdateOutputBookSheetDestination(TreeNode& trGUI, TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault)
bool 	OutputGUIManagerBase::UpdateOutputBookSheetDestination(TreeNode& trGUI, TreeNode& trOutput, LPCSTR lpcszBookList, LPCSTR lpcszBookDefault, LPCSTR lpcszSheetList, LPCSTR lpcszSheetDefault, bool bCheckSourceCustom)
///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
///end CLEAN_UPDATE_COMBO_CODES
///end CLEANUP_FIT_TYPE_CODES
///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
{
	_DBCLASS("OutputGUIManagerBase::UpdateOutputBookSheetDestination")

	ASSERT(trOutput);
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	/*	
	if(trOutput.Book)
	{
		if(lpcszBookList)
		{
			trOutput.Book.RemoveAttribute(STR_COMBO_ATTRIB);
			trOutput.Book.SetAttribute(STR_COMBO_ATTRIB, lpcszBookList);
		}
		if(lpcszBookDefault)
			trOutput.Book.strVal = lpcszBookDefault;
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedBookName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(trOutput.Book, NULL, strSelectedBookName);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//getSelectedBookSheetName(trOutput.Book, NULL, nOutputType, nBookSheetType, strSelectedBookName);
		getSelectedBookSheetName(trOutput.Book, NULL, nBookSheetType, strSelectedBookName);
		///end CLEANUP_FIT_TYPE_CODES
		
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME		
		if(!strSelectedBookName.IsEmpty())
			set_str_insert_combo(trOutput.Book, strSelectedBookName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//else if(trOutput.Book.strVal.Find( STR_CUSTOM) > -1) 
		else if( find_string_localization(trOutput.Book.strVal, STR_CUSTOM_E) > -1 ) 
		///---END CLEAN_LOCALIZATION_CODE
			trOutput.Book.strVal = GetOutputDestinationDefaultSetting(nBookSheetType);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
	}
	if(trOutput.Sheet)
	{
		if(lpcszSheetList)
		{
			trOutput.Sheet.RemoveAttribute(STR_COMBO_ATTRIB);
			trOutput.Sheet.SetAttribute(STR_COMBO_ATTRIB, lpcszSheetList);
		}
		if(lpcszSheetDefault)
			trOutput.Sheet.strVal = lpcszSheetDefault;
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedSheetName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(NULL, trOutput.Sheet, NULL, strSelectedSheetName);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//getSelectedBookSheetName(trOutput.Book, trOutput.Sheet, nOutputType, nBookSheetType, NULL, strSelectedSheetName);
		getSelectedBookSheetName(trOutput.Book, trOutput.Sheet, nBookSheetType, NULL, strSelectedSheetName);
		///end CLEANUP_FIT_TYPE_CODES
		
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		if(!strSelectedSheetName.IsEmpty())
			set_str_insert_combo(trOutput.Sheet, strSelectedSheetName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//else if(trOutput.Sheet.strVal.Find( STR_CUSTOM) > -1) 
		else if( find_string_localization(trOutput.Sheet.strVal, STR_CUSTOM_E) > -1 ) 
		///---END CLEAN_LOCALIZATION_CODE
			trOutput.Sheet.strVal = GetOutputDestinationDefaultSetting(nBookSheetType + 1);
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME	
	}
	*/
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	//updateOutputDestination(trOutput.Book, lpcszBookList, lpcszBookDefault, true, nBookSheetType);
	//updateOutputDestination(trOutput.Sheet, lpcszSheetList, lpcszSheetDefault, false, nBookSheetType);
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//updateOutputDestination(trOutput.Book, true, lpcszBookList, lpcszBookDefault);
	//updateOutputDestination(trOutput.Sheet, false, lpcszSheetList, lpcszSheetDefault);
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//updateOutputDestination(trGUI, trOutput.Book, true, lpcszBookList, lpcszBookDefault);
	//updateOutputDestination(trGUI, trOutput.Sheet, false, lpcszSheetList, lpcszSheetDefault);
	updateOutputDestination(trGUI, trOutput.Book, true, lpcszBookList, lpcszBookDefault, bCheckSourceCustom);
	updateOutputDestination(trGUI, trOutput.Sheet, false, lpcszSheetList, lpcszSheetDefault, bCheckSourceCustom);	
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///end CLEANUP_FIT_TYPE_CODES
	SetOneBookSheetName( trGUI, GetOutputNode( trGUI ), trOutput, UPDATE_BOTH );///Sophy 6/5/2008 CORRECT_MATRIX_FIT_RESIDUAL_SHEETNAME_WITHOUT_UPDATING_OUTPUT_GUI
	return true;
}
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
//virtual
string OutputGUIManagerBase::GetReportBookCombo(TreeNode& trGUI)
{	
	/// Iris 5/27/2008 v8.0871 NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA
	/*
	ASSERT(0); //should never enter here
	string	strBookCombo;
	return strBookCombo;
	*/
	string	strSourceBook = GetSourceBookName(trGUI);
	string 	strBookCombo = IsAllowReportToSourceBook(trGUI) ? STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(strSourceBook) : STR_OUTPUT_REPORT_BOOK_COMBO;	
	
#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART
	vector<string> vs;
	strBookCombo.GetTokens(vs, '|');
	for(int nn = 0; nn < vs.GetSize(); nn++)
	{
		if( compare_string_localization(vs[nn], STR_NONE) )
			break;			
	}
	if( nn < vs.GetSize() )
		vs.RemoveAt(nn);
	strBookCombo.SetTokens(vs, '|');
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART

	return strBookCombo;
	///end NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA
}
/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
///Sophy 4/18/2008  GET_SUB_TREENODE_BY_ID_RECURSIVE
//virtual
TreeNode OutputGUIManagerBase::GetInputDataNode( TreeNode& trGUI )
{
	///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	//TreeNode trInputData = tree_get_node_by_dataid( trGUI, IDST_INPUT_DATA_OPTIONS, true ); //find InputData node recursively
	//return trInputData;
	///---Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	//pfn_get_input_output_node pfn = Project.FindFunction("get_inputdata_node", "OriginLab\\wksoperation.c", TRUE);
	static pfn_get_input_output_node pfn = Project.FindFunction("get_inputdata_node", "OriginLab\\wksoperation.c", TRUE);
	///---END ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	if( pfn )
	{
		TreeNode trInput = pfn( trGUI );
		ASSERT( trInput );
		return trInput;
	}
	///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
}
//virtual
TreeNode OutputGUIManagerBase::GetOutputNode( TreeNode& trGUI )
{
	///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
	//TreeNode trOutput = tree_get_node_by_dataid( trGUI, IDST_OUTPUT_RESULTS_OPTIONS, true ); //find Output treenode recursively
	//return trOutput;
	///---Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	//pfn_get_input_output_node pfn = Project.FindFunction("get_outputdata_node", "OriginLab\\wksoperation.c", TRUE);
	static pfn_get_input_output_node pfn = Project.FindFunction("get_outputdata_node", "OriginLab\\wksoperation.c", TRUE);
	///---END ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	if( pfn )
	{
		TreeNode& trOutput = pfn( trGUI );
		ASSERT( trOutput );
		return trOutput;
	}
	///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
}
///end GET_SUB_TREENODE_BY_ID_RECURSIVE
/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
//bool 	OutputGUIManagerBase::updateOutputDestination(TreeNode& trN, LPCSTR lpcszList, LPCSTR lpcszDefault, bool bIsBook, int nBookSheetType)
///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
//bool 	OutputGUIManagerBase::updateOutputDestination(TreeNode& trNode, bool bIsBook, LPCSTR lpcszList, LPCSTR lpcszDefault)
bool 	OutputGUIManagerBase::updateOutputDestination(TreeNode& trGUI, TreeNode& trNode, bool bIsBook, LPCSTR lpcszList, LPCSTR lpcszDefault, bool bCheckSourceCustom)
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
///end CLEAN_UPDATE_COMBO_CODES
{	
	if(!trNode)
		return false;	
	
	if(lpcszList)
	{
		trNode.RemoveAttribute(STR_COMBO_ATTRIB);
		trNode.SetAttribute(STR_COMBO_ATTRIB, lpcszList);
		string strList(lpcszList);
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trNode.Enable = ( strList.GetNumTokens('|') <= 1 )? false : true;
		bool bEnable = ( strList.GetNumTokens('|') <= 1 )? false : true;
		SetEnableAttribute( trNode, bEnable );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	}
	
	if(lpcszDefault)
	{
		trNode.strVal = lpcszDefault;
		string	strList(lpcszList);
		if( lpcszList && strList.Find(lpcszDefault) < 0 )
		{
			///Sophy 9/19/2008 ATTEMPT_TO_SET_AS_SOURCE_WHEN_DONT_REPORT_FIT_CURVE
			//trNode.strVal = strList.GetToken(0, '|');
			if( !bCheckSourceCustom )
				trNode.strVal = strList.GetToken(0, '|');
			///end ATTEMPT_TO_SET_AS_SOURCE_WHEN_DONT_REPORT_FIT_CURVE
		}
	}
	
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	/*
	string strSelectedName;
	if(bIsBook)
		getSelectedBookSheetName(trN, NULL, nBookSheetType, strSelectedName);
	else
		getSelectedBookSheetName(trN.Parent().Book, trN, nBookSheetType, NULL, strSelectedName);
		
	
	if(!strSelectedName.IsEmpty())
	{
		set_str_insert_combo(trN, strSelectedName, STR_CUSTOM + STR_THREE_DOTS); 	
	}
	else if( find_string_localization(trN.strVal, STR_CUSTOM_E) > -1 ) 
	{
		trN.strVal = GetOutputDestinationDefaultSetting(nBookSheetType);
	}
	*/	
	if(bCheckSourceCustom)
	{
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE		
		//checkUpdateSourceCustomEntry(trNode, bIsBook);
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//checkUpdateSourceCustomEntry(trGUI, trNode, bIsBook);
		CheckUpdateSourceCustomEntry(trGUI, trNode, bIsBook);
		///End FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	}
	///end CLEAN_UPDATE_COMBO_CODES
	
	return true;
}
///end CLEANUP_FIT_TYPE_CODES

/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
//void	OutputGUIManagerBase::checkUpdateSourceCustomEntry(TreeNode& trGUI, TreeNode& trNode, bool bIsBook)
void	OutputGUIManagerBase::CheckUpdateSourceCustomEntry(TreeNode& trGUI, TreeNode& trNode, bool bIsBook)
///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
{
	if(!trNode)
		return;
	
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//checkSourceEntryToUpdateCombo(trNode, bIsBook);
	CheckSourceEntryToUpdateCombo(trGUI, trNode, bIsBook);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	int		nType = str_to_predefined_type(trNode.strVal);
	if(PDS_CUSTOM == nType)
	{
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//checkCustomEntryToUpdateCombo(trNode, bIsBook);
		checkCustomEntryToUpdateCombo(trGUI, trNode, bIsBook);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	}
	///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	if( !bIsBook )
		checkUpdateSheetComboOnBookChanged( trGUI, trNode.Parent() );
	///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
}
///end CLEAN_UPDATE_COMBO_CODES
///Sophy 6/2/2008 QA80-10934-P11 FIX_SHEET_COMBO_NOT_UPDATED_AFTER_BOOK_CHANGED
void	OutputGUIManagerBase::checkUpdateSheetComboOnBookChanged( TreeNode& trGUI, TreeNode& trBookSheetBranch)
{
	string			strBookName;
	string			strSheetCombo;
	string			str2ndPart;
	vector<string>	vsList;
	
	strBookName = trBookSheetBranch.BookName.strVal;
	trBookSheetBranch.Sheet.GetAttribute( STR_COMBO_ATTRIB, strSheetCombo );
	if( strBookName.IsEmpty() || strSheetCombo.IsEmpty() )
		return;
	
	Page pg(strBookName);
	///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	//if( !pg )
		//return;
	//bool bAllowCustom = pg ? true : false;///Sophy 1/13/2009 v8.0995d QA80-10536-P15 SHEET_LEVEL_IN_OUTPUT_RESIDUAL_FOR_MATRIX_FIT_SHOULD_ONLY_HAVE_NEW
	///Sophy 6/26/2008 FIX_ALLOW_RESIDUAL_TO_FIT_CURVE_AND_OVERWRITE_ITS_RESULT
	int nPageType = 0;
	if( pg )
		nPageType = pg.GetType();
	///end FIX_ALLOW_RESIDUAL_TO_FIT_CURVE_AND_OVERWRITE_ITS_RESULT
	strSheetCombo.GetTokens( vsList, '|');
	///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	///Sophy 4/27/2009 QA80-13480 OUTPUT_SHEET_LEVEL_ONLY_ALLOW_NEW_FOR_MATRIX_FIT
	//bool bAllowCustom = pg ? (EXIST_MATRIX != nPageType || IDST_RESIDUAL_CURVE_OPTIONS != trBookSheetBranch.DataID) : false;///Sophy 1/13/2009 v8.0995d QA80-10536-P15 SHEET_LEVEL_IN_OUTPUT_RESIDUAL_FOR_MATRIX_FIT_SHOULD_ONLY_HAVE_NEW
	bool bAllowCustom = pg ? EXIST_MATRIX != nPageType : false;
	///end OUTPUT_SHEET_LEVEL_ONLY_ALLOW_NEW_FOR_MATRIX_FIT
	//strSheetCombo.GetTokens( vsList, '|');///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	for( int ii = 0; ii < vsList.GetSize(); ii++)
	{
		if( PDS_CUSTOM == str_to_predefined_type( vsList[ii], str2ndPart ) )
		{
			///Sophy 7/6/2009 SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
			//if( pg )
			if( bAllowCustom )
			///end SUPPORT_NANOSIZER_OUTPUTGUIMANAGER
			{
				if( str2ndPart.Compare(STR_THREE_DOTS) )
				{
					Layer ly = pg.Layers( str2ndPart );
					if( !ly )
						remove_str_from_combo( trBookSheetBranch.Sheet, vsList[ii], false);
				}
			}
			else// if( PDS_FIT_CURVE != str_to_predefined_type( trBookSheetBranch.Book.strVal, str2ndPart ) )
			{
				remove_str_from_combo( trBookSheetBranch.Sheet, STR_CUSTOM, false);
				//return;
			}
	
		}
	}
	if( bAllowCustom && strSheetCombo.Find( STR_CUSTOM + STR_THREE_DOTS ) < 0 )
	{
		trBookSheetBranch.Sheet.GetAttribute( STR_COMBO_ATTRIB, strSheetCombo );
		///Sophy 6/26/2008 FIX_CUSTOMIZE_SHEET_NAME_NOT_WORK
		strSheetCombo.TrimRight('|'); //there might be extra STR_TOKEN_SEP at the end of the attribute, see STR_MATFITTING_RESIDUALOUT_SHEET_COMBO
		///end FIX_CUSTOMIZE_SHEET_NAME_NOT_WORK
		strSheetCombo += STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;			
		trBookSheetBranch.Sheet.SetAttribute( STR_COMBO_ATTRIB, strSheetCombo );
	}
	///Sophy 2/2/2009 v8.0969 BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
	int nBackupID;
	trBookSheetBranch.GetAttribute(STR_BACKUP_ID_ATTRIB, nBackupID);
	bool bAllowToFittedCurve = true;
	if ( PDS_FIT_CURVE != str_to_predefined_type( trBookSheetBranch.Book.strVal, str2ndPart ) || EXIST_MATRIX == nPageType )
		bAllowToFittedCurve = false; //book not fitted curve or from matrix(may overwrite existing result, so not allowed when from matrix)
		
	if ( IDE_PFM_OUTPUT_BASELINE_DATA_TO == trBookSheetBranch.DataID || IDE_PFM_OUTPUT_BASELINE_DATA_TO == nBackupID )
		bAllowToFittedCurve = false; //baseline data
	
	if ( IDE_PFM_OUTPUT_SUBTRACTED_DATA_TO == trBookSheetBranch.DataID || IDE_PFM_OUTPUT_SUBTRACTED_DATA_TO == nBackupID )
		bAllowToFittedCurve = false; //subtracted baseline data
	///end BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
	///Sophy 6/24/2008 QA80-10934-P16 CHECK_SHEET_COMBO_ITEM_FITTED_CURVE_TO_OCCUR_ON_RIGHT_TIME
	if( !bAllowToFittedCurve )
	{
		remove_str_from_combo( trBookSheetBranch.Sheet, STR_FIT_CURVE, false );
		if( PDS_FIT_CURVE == str_to_predefined_type( trBookSheetBranch.Sheet.strVal, str2ndPart ) )
			trBookSheetBranch.Sheet.strVal = STR_NEW;
	}
	else
	{
		///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
		//set_str_insert_combo( trBookSheetBranch.Sheet, STR_FIT_CURVE, STR_NEW );
		insert_str_into_combo( trBookSheetBranch.Sheet, STR_FIT_CURVE, STR_NEW );// no need to update Sheet.strVal
		///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	}
	///end CHECK_SHEET_COMBO_ITEM_FITTED_CURVE_TO_OCCUR_ON_RIGHT_TIME
	///Sophy 7/2/2008 FIX_FITTED_CURVE_SHEET_COMBO_CAN_BE_EDITED_WHEN_FIT_FROM_NO_SOURCE_GRAPH
	trBookSheetBranch.Sheet.GetAttribute( STR_COMBO_ATTRIB, strSheetCombo );
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	//if( 1 == strSheetCombo.GetNumTokens( '|' ) ) //when there exists only one token, combo list will become editable text field, if user edit and click ok, the result will not be correct
	if( 1 > strSheetCombo.Count( '|' ) ) //when there exists only one token, combo list will become editable text field, if user edit and click ok, the result will not be correct
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	{
		strSheetCombo += STR_TOKEN_SEP;
		trBookSheetBranch.Sheet.SetAttribute( STR_COMBO_ATTRIB, strSheetCombo );
	}
	///end FIX_FITTED_CURVE_SHEET_COMBO_CAN_BE_EDITED_WHEN_FIT_FROM_NO_SOURCE_GRAPH
	return;
}
///end FIX_SHEET_COMBO_NOT_UPDATED_AFTER_BOOK_CHANGED
///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
/*
bool	OutputGUIManagerBase::SetEnableAttribute( TreeNode& trGUI, TreeNode& trNode, bool bEnable )	// default true
{	
	ASSERT( trGUI );
	TreeNode trOutput = GetOutputNode( trGUI );
	ASSERT( trOutput );
	
	int	nChangeParam = 0;
	if( trOutput.GetAttribute(STR_CHANGE_PARAM_ATTRIB, nChangeParam ) && 1 == nChangeParam )// change param operation, do nothing
		return false;
	
	trNode.Enable = bEnable;
	
	return true;
}
*/
bool	OutputGUIManagerBase::SetEnableAttribute(TreeNode& trNode, bool bEnable )	// default true
{
	///Sophy 12/1/2008 v8.0981 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
	//if( isChangeParam() )// for change param operation, do nothing since should keep all output destination nodes disable
		//return false;
	///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	//if( isChangeParam() )    
	if( IsChangeParam() )    
	///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	{
		bool bRet = hasOutputReported(trNode, _get_output_index_of_one_node(trNode)) ;//if change param mode & branch has been reported, keep it disabled
		if( bRet )
			return false;
	}
	
	trNode.Enable = bEnable;	
	tree_set_or_remove_attribute(trNode.Parent(), STR_SKIP_THEME_ATTRIB);///Sophy 12/19/2008 v8.0988c QA80-12798 SKIP_THEME_APPLIED_TO_OUTPUT_DISABLED_NODE_WHEN_CHANGE_PARAMS, if can change enable status, can apply theme to it's branch
	return true;
}
///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER

///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
void	OutputGUIManagerBase::UpdateBranchOnBookChange( TreeNode& trGUI, TreeNode& trBookSheetBranch, bool bCheckUpdateBook )
{
	TreeNode trOutput = GetOutputNode( trGUI );
	
	if( bCheckUpdateBook )
		CheckUpdateSourceCustomEntry( trGUI, trBookSheetBranch.Book, true);
	
	SetOutputBookName( trGUI, trOutput, trBookSheetBranch );
	CheckUpdateSourceCustomEntry( trGUI, trBookSheetBranch.Sheet, false);
	SetOutputSheetName( trGUI, trOutput, trBookSheetBranch );
	return;
}
///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE

///Sophy/Iris 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
bool	OutputGUIManagerBase::CheckSourceEntryToUpdateCombo(TreeNode& trGUI, TreeNode& trNode, bool bIsBook)
{
	bool	bValueChanged = false;
	string  strVal = trNode.strVal;
	string	strCombo;	
	trNode.GetAttribute(STR_COMBO_ATTRIB, strCombo);

	bool	bHasSource;
	string		strSource;

	if( bIsBook )
	{
		///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		//bHasSource = IsAllowReportToSourceBook( trGUI );
		bHasSource = IsAllowToSourceBook( trGUI, trNode );
		///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		strSource = GetSourceBookName( trGUI );

	}
	else
	{
		/// Sophy 5/04/2008 FIX_NLFIT_SHEET_SETTING_CANNOT_BE_SAVED_IN_THEME
		//bHasSource = IsAllowReportToSourceSheet( trGUI );
		bHasSource = IsAllowToSourceSheet( trGUI ,trNode );
		/// End FIX_NLFIT_SHEET_SETTING_CANNOT_BE_SAVED_IN_THEME
		/// Sophy 9/5/2008 REMOVE_SOURCE_FROM_SHEET_COMBO_WHEN_BOOK_IS_NOT_SOURCE found in stats on row
		TreeNode trBookSheetBranch = trNode.Parent();
		ASSERT( trBookSheetBranch );
		if( trBookSheetBranch )
		{
			if( trBookSheetBranch.Book )
			{
				string	strBookValue = trBookSheetBranch.Book.strVal;
				if( strBookValue.Find( STR_SOURCE_BOOK ) < 0 )
					bHasSource = false;
			}
		}
		///end REMOVE_SOURCE_FROM_SHEET_COMBO_WHEN_BOOK_IS_NOT_SOURCE
		GetSourceBookName( trGUI, &strSource ); //get source sheet name
	}
	
	if( bHasSource )
	{		
		//check update value
		string	str2ndPart;
		if( PDS_SOURCE == str_to_predefined_type(trNode.strVal, str2ndPart) )
		{
			if( 0 != str2ndPart.CompareNoCase(strSource) )//different
			{
				///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
				//trNode.strVal = STR_SOURCE_BOOK + " " + strSource;
				/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			    //trNode.strVal = MakeSpecialType(STR_SOURCE_BOOK, strSource);
			    trNode.strVal = _make_special_type_str( STR_SOURCE_BOOK, strSource );
			    /// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
				///end MAKE_SPECIAL_TYPE
				bValueChanged = true;
			}
		}
		//check update combo
		///Sophy 4/14/2008 UPDATE_COMBO_LIST
		//if(strCombo.Find(STR_SOURCE_BOOK) < 0) //not in combo
		//{	
		    /////Sophy 4/10/2008 MAKE_SPECIAL_TYPE
			////set_str_insert_combo( trNode, STR_SOURCE_BOOK + " " + strSource, STR_NEW );
			////set_str_insert_combo( trNode, MakeSpecialType(STR_SOURCE_BOOK, strSource), STR_NEW);
			//insert_str_to_str_list(MakeSpecialType(STR_SOURCE_BOOK, strSource), strCombo, STR_NEW);
			//trNode.SetAttribute(STR_COMBO_ATTRIB, strCombo); //update combolist
			/////end MAKE_SPECIAL_TYPE
		//}
		//else//exists but might be out of date
		//{
			//remove_str_from_str_list(STR_SOURCE_BOOK,strCombo,false);//not full matched
			/////Sophy 4/10/2008 MAKE_SPECIAL_TYPE
			////insert_str_to_str_list(STR_SOURCE_BOOK + " " + strSource, strCombo, STR_NEW); //insert before <new>
			//insert_str_to_str_list(MakeSpecialType(STR_SOURCE_BOOK, strSource), strCombo, STR_NEW); //insert before <new>
			/////end MAKE_SPECIAL_TYPE
			//trNode.SetAttribute(STR_COMBO_ATTRIB, strCombo);  //update combolist
		//}
		if(strCombo.Find(STR_SOURCE_BOOK) > -1 ) // source exists
		{
			remove_str_from_str_list(STR_SOURCE_BOOK, strCombo, false); //remove it first
		}		
		
		/// Iris 4/15/2008 FIX_FIT_VALUE_BOOK_COMBO_ORDER_IS_CHANGED
		///// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		////insert_str_to_str_list(MakeSpecialType(STR_SOURCE_BOOK, strSource), strCombo, STR_NEW); //add source to string
		//insert_str_to_str_list( _make_special_type_str( STR_SOURCE_BOOK, strSource ), strCombo, STR_NEW );//add source to string
		///// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION		
		string 	strBefore = STR_REPORT;
		if( strCombo.Find(strBefore) < 0 ) //not found <Report>
			strBefore = STR_NEW;
		insert_str_to_str_list( _make_special_type_str( STR_SOURCE_BOOK, strSource ), strCombo, strBefore );
		///end FIX_FIT_VALUE_BOOK_COMBO_ORDER_IS_CHANGED
		
		trNode.SetAttribute(STR_COMBO_ATTRIB, strCombo);  //update combolist
		///end UPDATE_COMBO_LIST
	}
	else
	{
		if(strCombo.Find(STR_SOURCE_BOOK) > -1) // if input data not source book, then remove source from list
		{
			///Sophy 4/11/2008 UPDATE_COMBO_LIST
			//remove_str_from_combo(trNode, trNode.strVal, false);
			remove_str_from_combo(trNode, STR_SOURCE_BOOK, false);// false for not fullmatch remove
			///End UPDATE_COMBO_LIST
		}
		if(trNode.strVal.Find(STR_SOURCE_BOOK) > -1 )
		{
			trNode.strVal = STR_NEW;
			bValueChanged = true; 
		}
		if(trNode.strVal.Find('<') < 0) // strVal is empty,need to assign something to it
		{
			trNode.strVal = STR_NEW;
			bValueChanged = true;
		}
	}

	return bValueChanged;
	
}
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE

/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
//void	OutputGUIManagerBase::checkCustomEntryToUpdateCombo(TreeNode& trNode, bool bIsBook)
void	OutputGUIManagerBase::checkCustomEntryToUpdateCombo(TreeNode& trGUI, TreeNode& trNode, bool bIsBook)
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
{	
	string	strName;
	bool	bIsExisted;
	if( bIsBook )
	{
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//bIsExisted = checkGetSpecialBookSheetName(trNode, NULL, strName);
		///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		//bIsExisted = checkGetSpecialBookSheetName(trNode.Parent().BookName, NULL, strName);
		bIsExisted = checkGetSpecialBookSheetName(trNode.Parent(), NULL, strName, NULL, true);
		///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	}
	else// is sheet
	{
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//bIsExisted = checkGetSpecialBookSheetName(trNode.Parent().Book, trNode, strName);
		///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		//bIsExisted = checkGetSpecialBookSheetName(trNode.Parent().BookName, trNode.Parent().SheetName, strName);		
		bIsExisted = checkGetSpecialBookSheetName(trNode.Parent(), trNode.Parent().SheetName, strName, NULL, false);		
		///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	}
	
	if( !strName.IsEmpty() )
	{
		if(bIsExisted)
		{
			set_str_insert_combo(trNode, trNode.strVal, STR_CUSTOM + STR_THREE_DOTS); 	
		}
		else if( find_string_localization(trNode.strVal, STR_CUSTOM_E) > -1 ) // if the book/sheet is not existed, need to update with defalt
		{
			string	strNewVal = GetOutputDestinationDefaultSetting(trNode.DataID);
			///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
			remove_str_from_combo(trNode, trNode.strVal, true);// true for fullmatch remove
			///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
			string	strOldVal;
			if( trNode.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldVal) && !strOldVal.IsEmpty() && 0 != strOldVal.CompareNoCase(trNode.strVal) )
			{				
				strNewVal = strOldVal;
			}
			
			trNode.strVal = strNewVal;
			
		}
	}
}

///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
//bool	OutputGUIManagerBase::checkGetSpecialBookSheetName(const TreeNode& trBook, const TreeNode& trSheet, string& strSelectedBookName, string& strSelectedSheetName)
///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
//bool	OutputGUIManagerBase::checkGetSpecialBookSheetName(const TreeNode& trBookName, const TreeNode& trSheetName, string& strSelectedBookName, string& strSelectedSheetName)
bool	OutputGUIManagerBase::checkGetSpecialBookSheetName(const TreeNode& trBookSheetBranch, const TreeNode& trSheetName, string& strSelectedBookName, string& strSelectedSheetName, bool bIsBook)
///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
{
	string 	strBook, strSheet;
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//if(trBook)
	//{
		//str_to_predefined_type(trBook.strVal, strBook);
		//ASSERT( !strBook.IsEmpty() );
	//}
	///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	/*
	if( trBookName )// check sheet, trBook is node of  trBookSheetBranch.BookName type
	{
		strBook = trBookName.strVal;
		ASSERT( !strBook.IsEmpty() );
	}
	*/
	if( trBookSheetBranch )
	{
		if( bIsBook )
			str_to_predefined_type( trBookSheetBranch.Book.strVal, strBook );
		else
			strBook = trBookSheetBranch.BookName.strVal;
		
		ASSERT( !strBook.IsEmpty() );
	}
	///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	
	if(strSelectedBookName)
		strSelectedBookName = strBook;
	
	Page	pg(strBook);
	if(!pg)
		return false;		
		
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//if(trSheet)
	if( trSheetName )
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	{
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//str_to_predefined_type(trSheet.strVal, strSheet);
		strSheet = trSheetName.strVal;
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		ASSERT( !strSheet.IsEmpty() );
		
		Layer ly = pg.Layers(strSheet);
		if( !ly )
			return false;
		
		if(strSelectedSheetName)
			strSelectedSheetName = strSheet;
	}
	
	return true;
}
///end CLEAN_UPDATE_COMBO_CODES


string 	OutputGUIManagerBase::GetOutputDestinationDefaultSetting(int nBookSheetType)
{
	_DBCLASS("OutputGUIManagerBase::GetOutputDestinationDefaultSetting")
	string strDefault;
	switch(nBookSheetType)
	{
	case IDE_REOPRT_BOOK:
		strDefault = STR_AUTO;
		break;
	case IDE_REPORT_SHEET:
		strDefault = STR_NEW;
		break;
	case IDE_RESULT_CURVE_BOOK:
		strDefault = STR_AUTO;
		break;
	case IDE_RESULT_CURVE_SHEET:
		strDefault = STR_NEW;
		break;
	case IDE_REPORT_DUMP_NOTESWIN:	
		strDefault = STR_NONE;		///Jasmine 04/11/08 DUMP_NOTESWIN_DEFAULT_SET_NONE
		break;
	default:
		break;
	}
	return strDefault;
}

int 	OutputGUIManagerBase::checkGetXFDataBranch(TreeNode &trGUI, TreeNode& trNode, TreeNode &trData, int nRow)
{
	//_DBCLASS("OutputGUIManagerBase::checkGetXFDataBranch")
	if(!trData)
	{
		if(trNode)
		{
			trData = trNode.Parent();
			if(trData)
				return DBTY_X_FUNC_VAR;
		}
	}
		
	return DBTY_CURVE_OUTPUT;
}

/// Iris 04/10/2008 NO_REAL_SHEET_NAME_IN_REPORT_SHEET
/*
bool 	OutputGUIManagerBase::OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook)
{
	_DBCLASS("OutputGUIManagerBase::OutputReportBookEvent")
	TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	ASSERT(trOutput);
	
	TreeNode trReport = trOutput.Report;
	ASSERT(trReport);
	trReport.Book.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trReport.Book.strVal);

	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES	
	//string strReportBook = trReport.Book.strVal;
	//
	//int 	nReportBookType;
	//string 	str2ndPart;
	//if( !strReportBook.IsEmpty() )
		//nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
	//
	//if( !str2ndPart.IsEmpty() && PDS_THREE_DOTS != str_to_predefined_type(str2ndPart) ) //Iris 01/26/2007 v8.0548 ONLY to check when specified page name with <Source> or Existing...
	//{
		//Page 	pg(str2ndPart);
		//bool	bInvalidPage = false;
		//if(	PDS_SOURCE == nReportBookType || PDS_EXISTING == nReportBookType)
			//bInvalidPage = !pg.IsValid();
		//if( PDS_INVALID == nReportBookType || bInvalidPage)
		//{
			//string 	strOldVal;
			//if( trReport.Book.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldVal) )
			//{
				//strReportBook = strOldVal;
				//nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
			//}
			//else
			//{
				//strReportBook = STR_SOURCE_BOOK;
				//nReportBookType = PDS_SOURCE;
			//}
		//}
		//trReport.Book.strVal = strReportBook;
	//}
		
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//checkUpdateSourceCustomEntry(trReport.Book, true);
	checkUpdateSourceCustomEntry(trGUI, trReport.Book, true);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	string	strReportBook = trReport.Book.strVal;
	string	str2ndPart;
	int		nReportBookType = str_to_predefined_type(strReportBook, str2ndPart);
	///end CLEAN_UPDATE_COMBO_CODES	
	
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 	
	/////Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	//int nOutputType = 0;
	////end CLEANUP_FIT_TYPE_CODES
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trFittedCurve = trGUI.Output.Data;
	TreeNode 	trFittedCurve = trOutput.Data;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 	
	//if(trFittedCurve)
		//trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
	//////end CLEANUP_FIT_TYPE_CODES
	////end CLEANUP_FIT_TYPE_CODES	
	
	string 		strSheetList = STR_NEW; // for updatting sheet combo
	///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	
	bool 	bNoReport = false;
	bool	bSheetEnable = true;
	switch(nReportBookType)
	{
	case PDS_NONE:
		bSheetEnable = false;
		bNoReport = true;
		
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES		
		/////Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///////Cheney 2007-8-30 QA70-10290-sug4 FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
		////_update_residual_and_findxy_setting_if_no_report(trGUI.Output.Residual);
		////_update_residual_and_findxy_setting_if_no_report(trGUI.Output.FindXY);
		///////end FIX_STH_ABOUT_OUTPUT_SETTING_FOR_3D_FIT
		/////Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		////int nOutputType = 0;
		////TreeNode trFittedCurve = trGUI.Output.Data;
		////if( trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType == OPERATION_OUTPUT_XYZ_FITTING )
		//if( nOutputType == OPERATION_OUTPUT_XYZ_FITTING )
		/////end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		//{
			/////Cheney 2007-10-31 QA70-10536-p10 FIND_Z_SHOULD_ALSO_HIDE_REPORT
			////TreeNode trResidual = trGUI.Output.Residual;
			///////Cheney 2007-10-24 QA70-10536 FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
			//////update_output_book_sheet_destination(trResidual, NULL, STR_NEW, NULL, STR_NEW);
			////string strResidualCombo;
			////if(trResidual.Book.GetAttribute(STR_COMBO_ATTRIB, strResidualCombo))
			////{
				////remove_str_from_str_list(STR_REPORT, strResidualCombo);
				////if(trResidual.Book.strVal.Compare(STR_REPORT) == 0)
					///////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
					//////update_output_book_sheet_destination(trResidual, strResidualCombo, STR_NEW, NULL, NULL);
					////update_output_book_sheet_destination(trResidual, strResidualCombo, STR_NEW, NULL, NULL, nOutputType, IDE_REOPRT_BOOK);
					///////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				////else
					///////Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
					//////update_output_book_sheet_destination(trResidual, strResidualCombo, NULL, NULL, NULL);
					////update_output_book_sheet_destination(trResidual, strResidualCombo, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK);
					///////end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			////}
			///////FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
			////trResidual.Sheet.Enable = false;
			 /////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			 ////_update_xyzfitting_residual_or_findz_setting(trGUI.Output.Residual, nOutputType, IDE_REOPRT_BOOK);
			 ////_update_xyzfitting_residual_or_findz_setting(trGUI.Output.FindXY, nOutputType, IDE_FIND_XY_BOOK);
			 //updateXYZFittingResidualOrFindZSetting(trOutput.Residual, nOutputType, IDE_REOPRT_BOOK);
			 //updateXYZFittingResidualOrFindZSetting(trOutput.FindXY, nOutputType, IDE_FIND_XY_BOOK);
			/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			 /////end FIND_Z_SHOULD_ALSO_HIDE_REPORT
//
		//}
		///end CLEANUP_FIT_TYPE_CODES
		
		///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		if(!trFittedCurve)
			break;
		///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		///Cheney 2007-10-24 QA70-10536 FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
		///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
		//if( trFittedCurve.Book.strVal.Compare(STR_REPORT) != 0 )
		if ( PDS_REPORT != cvt_str_to_predefined_type(trFittedCurve.Book.strVal) )
		///---END CLEAN_LOCALIZATION_CODE
			break;
		///FIX_SOME_NEW_PROBLEMS_REPORT_BY_MAX
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING || !is_range_from_normal_book( _get_input_data_branch(trGUI) ) )
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING || !is_range_from_normal_book( GetNodeByTagname(trGUI, "InputData") ) )
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//if( !is_range_from_normal_book( GetNodeByTagname(trGUI, "InputData") ) )
		if( !IsAllowReportToSourceBook( trGUI ) )
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEANUP_FIT_TYPE_CODES
		///end 	MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			{
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFittedCurve, NULL, STR_NEW, NULL, STR_NEW);
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trFittedCurve, NULL, STR_NEW, NULL, STR_NEW, IDE_REOPRT_BOOK);
			///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//UpdateOutputBookSheetDestination(trFittedCurve, NULL, STR_NEW, NULL, STR_NEW);
			UpdateOutputBookSheetDestination(trGUI, trFittedCurve, NULL, STR_NEW, NULL, STR_NEW);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE

			///end CLEAN_UPDATE_COMBO_CODES
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			}
			else
			{
			string strCombo;
			if(trFittedCurve.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
				trFittedCurve.Book.strVal = strCombo.GetToken(1,'|');
			}
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		break;
		
	case PDS_SOURCE:
		if(lpcszBook)
		{
			string strBook(lpcszBook);
			trReport.Book.strVal = STR_SOURCE_BOOK + " " + strBook;
		}
		///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)// stats on rows
		/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
		//if(isStatsOnRows(trGUI))
		if(IsAllowReportToSourceSheet(trGUI))
		///end ADD_DescStats_OUTPUT_CLASS
		//------
		{
			insert_str_to_str_list(STR_SOURCE_BOOK, strSheetList);
		}
		///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
		break;
		
	case PDS_NEW:
		trReport.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
		
	case PDS_CUSTOM:
		bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strReportBook, str2ndPart))? true:false;
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//check_ask_custom_book_sheet_name(trGUI, trReport.Book, str2ndPart, strReportBook, false);
		CheckAskCustomBookSheetName(trGUI, trReport.Book, str2ndPart, strReportBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
		//Page pg( trReport.Book.strVal.GetToken(1,'>') );
		string 	strPage;
		str_to_predefined_type(trReport.Book.strVal, strPage);
		Page	pg(strPage);
		///end CLEANUP_FIT_TYPE_CODES
		if(!pg)
		{//select default value
			///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//Page pgSource(get_source_page_name(trGUI));
			Page pgSource(GetSourceBookName(trGUI));
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			if(!pgSource)
				return false;
			pg = pgSource;
		}
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)// stats on rows
		/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
		//if(isStatsOnRows(trGUI))
		if(IsAllowReportToSourceSheet(trGUI))
		///end ADD_DescStats_OUTPUT_CLASS
		//------
		{
			if(!lstrlen( get_sheets_in_book(pg, WKS_DATA_SHEET) ))
			{
				trReport.Sheet.strVal = STR_NEW;
				bSheetEnable = false;
			}
			else
			{
				bSheetEnable = true;
			}
		}
		else
		{			
			if(!lstrlen( get_sheets_in_book(pg, WKS_REPORT_TABLE) ))
			{
				trReport.Sheet.strVal = STR_NEW;
			}
			bSheetEnable = false; 
		}
		break;
		
	///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	case PDS_AUTO:
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
		//if(isStatsOnRows(trGUI))
		if(IsAllowReportToSourceSheet(trGUI))
		///end ADD_DescStats_OUTPUT_CLASS
		{
			insert_str_to_str_list(STR_SOURCE_BOOK, strSheetList);
			trOutput.Report.Sheet.strVal = STR_INSERT_SOURCE_SHEET;
		}
		else
		//-----
			trReport.Sheet.strVal = STR_NEW;
			bSheetEnable = false;
		break;		
	///end FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	
	default:
		break;
	}
	trReport.Sheet.Enable = bSheetEnable;	
	int nCurveBookType = PDS_USER;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//if(trGUI.Output.Data)
	//	nCurveBookType = str_to_predefined_type(trGUI.Output.Data.Book.strVal, str2ndPart);
	if(trOutput.Data)
		nCurveBookType = str_to_predefined_type(trOutput.Data.Book.strVal, str2ndPart);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	//bool	 bAllowReportToSrcSheet = false;
	//int 	nn;
	//if(trGUI.GetAttribute(STR_ALLOW_REPORT_TO_SOURCE_SHEET_ATTRIB, nn) && nn > 0)
		//bAllowReportToSrcSheet = true;
	bool	 bAllowReportToSrcSheet = IsAllowReportToSourceSheet(trGUI);	
	///end ADD_DescStats_OUTPUT_CLASS
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trBook = trGUI.OutPut.Report.Book;
	TreeNode trBook = trOutput.Report.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	int nAllowToSourceBook = 0;
	trBook.GetAttribute( STR_ALLOW_REPORT_TO_SOURCE_BOOK_ATTRIB, nAllowToSourceBook);
	buildReportBookOption(trBook, nAllowToSourceBook, lpcszBook);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, bAllowReportToSrcSheet, true, lpcszBook);
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS, replace bAllowReportToSourceSheet with IsAllowReportToSourceSheet
	//buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, bAllowReportToSrcSheet, true, lpcszBook);
	buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, true, lpcszBook);
	///end ADD_DescStats_OUTPUT_CLASS
	
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(PDS_SOURCE == nReportBookType)
		bSheetEnable = bAllowReportToSrcSheet ? true:false;
	
	trReport.Sheet.Enable = bSheetEnable;
	
	trReport.Book.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trReport.Book.strVal);
	
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	//UpdateOutputBookSheetDestination(trReport, NULL, NULL, strSheetList, NULL, nOutputType, IDE_REOPRT_BOOK, nOutputType);	///Cheney 2007-11-7 10536 p14-p16 FIX_MORE_PREBLEMS_ABOUT_OUTPUT_DESTNATION
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
	//UpdateOutputBookSheetDestination(trReport, NULL, NULL, strSheetList, NULL, IDE_REOPRT_BOOK);
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//UpdateOutputBookSheetDestination(trReport, NULL, NULL, strSheetList);
	UpdateOutputBookSheetDestination(trGUI, trReport, NULL, NULL, strSheetList);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///end CLEAN_UPDATE_COMBO_CODES
	///end CLEANUP_FIT_TYPE_CODES
	
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	////show_report_column_option(trGUI);
	//showReportColumnOption(trGUI);
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	///end ADD_DescStats_OUTPUT_CLASS
	
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	setReportBookSheetName(trGUI, trOutput);  
	if( trOutput.Data && PDS_REPORT == str_to_predefined_type(trOutput.Data.Book.strVal) )
		setCurveBookSheetName(trGUI, trOutput);  
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	return true;	
}
*/
void 	OutputGUIManagerBase::updateCurveOnReportBookChange(TreeNode& trGUI, TreeNode& trOutput)
{
	ASSERT(trOutput);
	ASSERT(trOutput.Report.Book);
	
	TreeNode	trCurve = trOutput.Data;
	if(trCurve)
	{
		int		nReportBookType = str_to_predefined_type(trOutput.Report.Book.strVal);			
		int  	nCurveBookType = str_to_predefined_type(trCurve.Book.strVal);			
		buildOutputBookSheetOption( trGUI, nReportBookType, nCurveBookType, true, GetSourceBookName(trGUI) );
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trCurve.Sheet.Enable = isBookExist( trCurve.BookName.strVal );
		///Sophy 10/9/2008 QA80-10536-P2 SET_CURVE_SHEET_ENABLE_STATE_FOLLOW_NEW_DESIGN
		//SetEnableAttribute( trCurve.Sheet, isBookExist( trCurve.BookName.strVal ) );
		SetEnableAttribute( trCurve.Sheet, ( PDS_SOURCE == nCurveBookType || PDS_CUSTOM == nCurveBookType ) && isBookExist( trCurve.BookName.strVal ) );
		///end SET_CURVE_SHEET_ENABLE_STATE_FOLLOW_NEW_DESIGN
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	}
}

void 	OutputGUIManagerBase::updateReportSheetOnBookChange(TreeNode& trGUI, TreeNode& trOutput)
{	
	ASSERT(trOutput);
	
	TreeNode 	trReport = trOutput.Report;
	ASSERT(trReport);
	
	TreeNode 	trBook = trReport.Book;
	ASSERT(trBook);

	string	str2ndPart;
	int		nReportBookType = str_to_predefined_type(trBook.strVal, str2ndPart);
	
	string	strSourceBook, strSourceSheet;
	bool	bAllowReportToSourceSheet = IsAllowReportToSourceSheet(trGUI);
	strSourceBook = GetSourceBookName(trGUI, &strSourceSheet);
	
	///Sophy 7/9/2009 QA80-13910-P1 FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	//bool	bSheetEnable = true;
#ifndef	__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	bool	bSheetEnable = true;
#else
	bool	bSheetEnable = trReport.Sheet.Enable;
#endif	//__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	///end FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	string	strSheetList = STR_NEW;
	string	strSheetVal = (trReport.Sheet.IsEmpty())? "" : trReport.Sheet.strVal;
	switch(nReportBookType)
	{
	case PDS_NONE:	
		bSheetEnable = false;
		break;	
		
	case PDS_SOURCE:		
	case PDS_AUTO:
		if(IsAllowReportToSourceSheet(trGUI))
		{
			string 		strEntry = STR_INSERT_SOURCE_SHEET + " " + strSourceSheet;
			insert_str_to_str_list(strEntry, strSheetList);
			strSheetVal = strEntry;
		}
		else
		{
			strSheetVal = STR_NEW;
			///Sophy 11/13/2008 v8.970 QA80-10731-P1 FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW should disable it here
			////bSheetEnable = false;	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			bSheetEnable = false;
			///end FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		}
		///Sophy 11/13/2008 v8.970 QA80-10731 FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		//bSheetEnable = false;		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		///end FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		break;	
		
	case PDS_NEW:
		strSheetVal = STR_NEW;
		bSheetEnable = false;
		break;
		
	case PDS_CUSTOM:
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//CheckAskCustomBookSheetName(trGUI, trReport.Book, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		/// Iris 5/29/2008 QA80-11620 v8.0873 FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX, use 0 here is not make sense, should pass DataID of changed node
		//CheckAskCustomBookSheetName(trGUI, trReport, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);		
		///Sophy 7/17/2009 v8.0998-55 MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		//CheckAskCustomBookSheetName(trGUI, trReport, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, trBook.DataID);		
		bool bChanged = CheckAskCustomBookSheetName(trGUI, trReport, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, trBook.DataID);		
		///end MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		///end FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX		
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		
		string 		strPage;
		if( PDS_CUSTOM == str_to_predefined_type(trReport.Book.strVal, strPage) )// if click Cancel in Project Browse, will keep old val for Book here
		{		
			Page		pg(strPage);			
			if( !bAllowReportToSourceSheet //allow report to source sheet means this report is data format, else will be table format 
				|| bAllowReportToSourceSheet && !lstrlen( get_sheets_in_book(pg, WKS_DATA_SHEET) ) ) //no falt sheet
			{
				strSheetVal = STR_NEW;
				bSheetEnable = false;
			}		
			else
			{
				strSheetList += STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			}
		}		
		///Sophy 11/13/2008 v8.970 QA80-10731-P1 FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW if user cancel, should keep old sheet combo
		///Sophy 7/17/2009 v8.0998-55 MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		//trReport.Sheet.GetAttribute( STR_COMBO_ATTRIB, strSheetList );
		if ( !bChanged ) //user cancel the select operation.
			trReport.Sheet.GetAttribute( STR_COMBO_ATTRIB, strSheetList );
		///end MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		///end FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		break;		
		
	default:
		break;
	}
	///Sophy 9/9/2008 KEEP_REPORT_SHEET_AS_COMBO
	if( strSheetList.Find('|') < 0 )
		strSheetList = strSheetList + "|";
	///end KEEP_REPORT_SHEET_AS_COMBO
	
	///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	//updateOutputDestination(trGUI, trReport.Sheet, false, strSheetList, strSheetVal);	
	bool bCheckSourceCustom = false; //when change parameter, need to check book/sheet in case user delete them before change param
	if ( IsChangeParam() )
	{
		bCheckSourceCustom = true;
		if ( !trReport.Sheet.IsEmpty() )
			strSheetVal = trReport.Sheet.strVal; //keep old value
	}
	
	updateOutputDestination(trGUI, trReport.Sheet, false, strSheetList, strSheetVal, bCheckSourceCustom);	
	///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	//trReport.Sheet.Enable = bSheetEnable;	
	SetEnableAttribute( trReport.Sheet, bSheetEnable);
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
}

///Sophy 11/27/2008 v8.980d CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
typedef bool (* HAS_CURVE_REPORTED)(const TreeNode& trGUI, const int nRangeIndex, const int nDatasetIndex = 0);
///end CHANGE_PARAM_SHOULD_KEEP_BRAHCH_ENABLE_WHEN_CURVE_NOT_REPORTED_BEFORE
///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
//void	OutputGUIManagerBase::disableOutputDestination( TreeNode& trOutput )
virtual void	OutputGUIManagerBase::DisableOutputDestination( TreeNode& trOutput )
///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS
{
	ASSERT( trOutput );
		
	if( trOutput.Report )
		DisableOutputBookSheetBranch( trOutput.Report );
	
	/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.Data )
		DisableOutputBookSheetBranch( trOutput.Data );
	*/
	TreeNode trGUI = trOutput.Parent();
	ASSERT(trGUI.tagName == "GUI");
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	if( trData )
		DisableOutputBookSheetBranch( trData );	
	///end OP_DLG_NEW_STRUCTURE
	
	return;
}

void	OutputGUIManagerBase::DisableOutputBookSheetBranch( TreeNode& trBookSheetBranch)
{
	ASSERT( trBookSheetBranch );
	
	if( trBookSheetBranch.Book && hasOutputReported(trBookSheetBranch.Book, _get_output_index_of_one_node(trBookSheetBranch.Book)) )
		trBookSheetBranch.Book.Enable = false;
	if( trBookSheetBranch.BookName )
		trBookSheetBranch.BookName.Enable = false;
	if( trBookSheetBranch.Sheet && hasOutputReported(trBookSheetBranch.Sheet, _get_output_index_of_one_node(trBookSheetBranch.Sheet)) )
		trBookSheetBranch.Sheet.Enable = false;
	if( trBookSheetBranch.SheetName )
		trBookSheetBranch.SheetName.Enable = false;
	if( trBookSheetBranch.SheetName2 )
		trBookSheetBranch.SheetName2.Enable = false;
	///Sophy 5/29/2008 QA80-11605-P3 FIX_REPORT_TABLE_COLUMN_NODE_NOT_DISABLED
	if( trBookSheetBranch.Column)
		trBookSheetBranch.Column.Enable = false;
	///end FIX_REPORT_TABLE_COLUMN_NODE_NOT_DISABLED
	
	///Sophy 12/19/2008 v8.0988c QA80-12798 SKIP_THEME_APPLIED_TO_OUTPUT_DISABLED_NODE_WHEN_CHANGE_PARAMS
	trBookSheetBranch.SetAttribute(STR_SKIP_THEME_ATTRIB, 1);
	///end SKIP_THEME_APPLIED_TO_OUTPUT_DISABLED_NODE_WHEN_CHANGE_PARAMS
	return;
}
///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER

bool 	OutputGUIManagerBase::OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode 	trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	updateReportSheetOnBookChange(trGUI, trOutput);
	
	//moved after setCurveBookSheetName
	//updateCurveOnReportBookChange(trGUI, trOutput);///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	setReportBookSheetName(trGUI, trOutput);  
	if( trOutput.Data && PDS_REPORT == str_to_predefined_type(trOutput.Data.Book.strVal) )
		setCurveBookSheetName(trGUI, trOutput);  
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	
	updateCurveOnReportBookChange(trGUI, trOutput);///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	
	return true;	
}
///end NO_REAL_SHEET_NAME_IN_REPORT_SHEET


///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//For NLFit event trGUI is opGUI node of m_trNFO, or else trGUI is GUI node of operation tree
//static TreeNode _get_node_by_tagname(TreeNode& trGUI, bool bIsNLFitOutputEvent = false, LPCSTR lpcszTagName = "Output")
TreeNode OutputGUIManagerBase::GetNodeByTagname(TreeNode& trGUI, LPCSTR lpcszName)
{	
	return tree_get_node_by_tagname(trGUI, lpcszName, true);
}
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//static bool _open_custom_input_box(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet = true, int nDBTY = DBTY_CURVE_OUTPUT, int nSheetType = WKS_ALL)  ///Iris 11/23/04 CHANGED_RETURN_VAL
///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
//bool OutputGUIManagerBase::openCustomInputBox(TreeNode& trGUI, string strBook, string& strOutput, bool bSheet, int nDBTY, int nSheetType)  ///Iris 11/23/04 CHANGED_RETURN_VAL
bool OutputGUIManagerBase::openCustomInputBox(TreeNode& trBookSheetBranch, string strBook, string& strOutput, bool bSheet, int nDBTY, int nSheetType)  ///Iris 11/23/04 CHANGED_RETURN_VAL
///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{	
	string 	strPageName;
	///Sophy 4/17/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY default is <auto> and we can simply get source book name
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//string 	strRealSourcePage = get_source_page_name(trGUI);
	//TreeNode 	trInputData = GetNodeByTagname(trGUI, "InputData");
	/////Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	////string	strRealSourcePage = get_source_page_name(trGUI, NULL, trInputData);
	//string 		strRealSourcePage = GetSourceBookName(trGUI);
	/////end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	//
	////when selection of Report Book is "<Source>  book1" or "<custom> book1", need convert to real page name
	////else if it is "<custom>...", the default of input box should be empty
	//int nType;
	//string str2ndPart;	
	//str2ndPart = page_short_name_from_display_name(strBook, nType);
//
	//switch(nType)
	//{
	//case PDS_USER:
		//strPageName = str2ndPart;
		//break;
	//case PDS_SOURCE:
	//case PDS_CUSTOM:
		//if(str2ndPart.IsEmpty())
			//strPageName = strRealSourcePage;
		//else
			//if(str2ndPart.Compare(STR_THREE_DOTS))
				//strPageName = str2ndPart;
		//break;
	//case PDS_FIT_CURVE:
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////strPageName = _get_fitcurve_page_name(trGUI);
		//strPageName = getFitCurvePageName(trGUI);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			//break;
	//case PDS_REPORT:
		/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		////strPageName = _get_report_page_name(trGUI);
		//strPageName = getReportPageName(trGUI);
		/////end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
			//break;
	//default:
		//break;
	//}
	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	//strPageName = getReportPageName( trGUI );

	strPageName = getOutputBookName( trBookSheetBranch );
	///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
	string strNameList;
	if(!bSheet)
	{
		vector<string> vsPages;
		char chToken = '|';
		get_project_pages_name(vsPages);
		strNameList.SetTokens(vsPages, chToken);
	}
	else
	{			
		int nSheet=0;
		Page pg(strPageName);
		if(!pg)
			return false;

		strNameList = get_sheets_in_book(pg, nSheetType);
	}	

	if(!lstrlen(strNameList))
		return false;
	GETN_TREE(tr)
	GETN_LIST(list, "Existing name", 0, strNameList)
	///Sophy 7/9/2009 QA80-13910-P2 NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
	//if(GetNBox(tr, _L("Select Name..."), "  " ))
#ifndef	__NLFIT_DLG_BECOME_MODELESS__
	if(GetNBox(tr, _L("Select Name..."), "  " ))
#else
	if ( GetNBox(tr, _L("Select Name..."), "  ", NULL, NULL, GetWindow(OGW_DB_ACTIVE_DLG)) )
#endif	//__NLFIT_DLG_BECOME_MODELESS__
	///end NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
	{
		strOutput = getSelectedStringFromCombolist(tr.list);
	}
	
	if(!strOutput.IsEmpty())
	{
		///Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//strOutput = STR_CUSTOM + " " + strOutput;   ///Iris 11/23/04 
		///Sophy/Iris 4/14/2008 MAKE_SPECIAL_TYPE
		//strOutput = STR_CUSTOM + strOutput;   ///Iris 11/23/04 
		/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION 
		//strOutput = MakeSpecialType(STR_CUSTOM, strOutput);
		strOutput = _make_special_type_str( STR_CUSTOM, strOutput );
		/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		///end MAKE_SPECIAL_TYPE
		///end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		return true;	
	}
	return false;
}

//------ CPY 8/23/2007 CHENEY_MOVED_SOME_FILES_BROKE_MDIM_XF
///Iris 4/01/05 CENTRALIZE_GET_SEL_STR_FROM_COMBOLIST
string    OutputGUIManagerBase::getSelectedStringFromCombolist(TreeNode &trList)
{
	if(!trList)
		return "";
	
	string			  strNameList;
   	vector<string>    vsNames;   	
   	trList.GetAttribute(STR_COMBO_ATTRIB, strNameList);
   	strNameList.GetTokens(vsNames, '|');
   	
	int     nChoose = trList.nVal;
   	return nChoose < vsNames.GetSize()? vsNames[nChoose] : "";
}
////---- end CHENEY_MOVED_SOME_FILES_BROKE_MDIM_XF


///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
//These two functions are replaced by getOutputBookName(TreeNode& trBookSheetBranch );
/*
///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
//static string _get_fitcurve_page_name(TreeNode& trOperation)
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
string OutputGUIManagerBase::getFitCurvePageName(TreeNode& trGUI)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	string strName;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trGUI = tree_get_node_by_tagname(trOperation, "GUI", true);
	//TreeNode trBook = trGUI.Output.Data.Book;
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	TreeNode trBook = trOutput.Data.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trBook)
	{
		int nType;
		string str2ndPart;
		nType = str_to_predefined_type(trBook.strVal, str2ndPart);
		if(!str2ndPart.IsEmpty())
		{
			if(str2ndPart.Compare(STR_THREE_DOTS))
				strName = str2ndPart;
		}
		if(PDS_REPORT == nType)
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = _get_report_page_name(trGUI);
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//strName = getReportPageName(trGUI);
			strName = getOutputBookName( trOutput.Report );
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

		if(PDS_SOURCE == nType)
		{
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = get_source_page_name(trGUI);
			///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
			//TreeNode trInputData = GetNodeByTagname(trGUI, "InputData");
			TreeNode trInputData = GetInputDataNode( trGUI );
			///end GET_SUB_TREENODE_BY_ID_RECURSIVE
			///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//strName = get_source_page_name(trGUI, NULL, trInputData);
			strName = GetSourceBookName(trGUI);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		}
	}	
	return strName;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//static string _get_report_page_name(TreeNode& trOperation)
string OutputGUIManagerBase::getReportPageName(TreeNode& trGUI)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	string strName;
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trReportBook = trOperation.Output.Report.Book;
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	TreeNode trReportBook = trOutput.Report.Book;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trReportBook)
	{
		int nType;
		string str2ndPart;
		nType = str_to_predefined_type(trReportBook.strVal, str2ndPart);
		if(!str2ndPart.IsEmpty())
		{
			if(str2ndPart.Compare(STR_THREE_DOTS))
				strName = str2ndPart;
		}
		else if(PDS_SOURCE == nType)
		{
			///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
			//strName = get_source_page_name(trOperation);
			///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
			//TreeNode trInputData = GetNodeByTagname(trGUI, "InputData");
			TreeNode trInputData = GetInputDataNode( trGUI );
			///end GET_SUB_TREENODE_BY_ID_RECURSIVE
			///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//strName = get_source_page_name(strGUI, NULL, trInputData);
			strName = GetSourceBookName(trGUI);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		}
	}
	return strName;
}
*/
string	OutputGUIManagerBase::getOutputBookName( TreeNode& trBookSheetBranch )
{
	return trBookSheetBranch.BookName.strVal;
}
bool	OutputGUIManagerBase::isBookExist( LPCSTR lpcszBookName )
{
	string strBookName( lpcszBookName );
	Page pg( strBookName );
	if( !pg )
		return false;
	return true;
}
///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION


/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
/*
///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//static void _check_wks_or_matrix_book_sheet(int nReportMatrix, int nID, bool& bWks = true)
void OutputGUIManagerBase::checkWksOrMatrixBookSheet(int nOutputType, int nID, bool& bWks)
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
{
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//if(nReportMatrix == 0)
	if(nOutputType == OPERATION_OUTPUT_GENERAL)
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	{
		bWks = true;
		return;
	}
	
	switch(nID)
	{
	case IDE_RESIDUAL_CURVE_BOOK:
	case IDE_RESIDUAL_CURVE_SHEET:
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//if(nReportMatrix == 1) //Surface fitting
		if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING) //Surface fitting
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			bWks = true;
		else
			bWks = false; //Matrix fitting
		break;
		
	case IDE_RESULT_CURVE_BOOK:
	case IDE_RESULT_CURVE_SHEET:
		bWks = false;
		break;
			
	default:
		bWks = true;
		break;
	}	
}
*/
void 	OutputGUIManagerBase::CheckWksOrMatrixBookSheet(int nID, bool& bWks)
{
	bWks = true;
	return;
}
///end CLEANUP_FIT_TYPE_CODES



///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool update_output_curve_book_setting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook)
/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES 
//bool OutputGUIManagerBase::updateOutputCurveBookSetting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, string& str2ndPart, LPCSTR lpcszBook)
bool OutputGUIManagerBase::updateOutputCurveBookSheetSetting(TreeNode& trRootNode, TreeNode& trData, int& nCurveBookType, LPCSTR lpcszBook)
///end CLEANUP_FIT_TYPE_CODES
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	_DBCLASS("OutputGUIManagerBase::updateOutputCurveBookSheetSetting")
	if(!trRootNode || !trData)
		return false;
	
	string strCurveBook = trData.Book.strVal;
	string str2ndPart;
	nCurveBookType = str_to_predefined_type(strCurveBook, str2ndPart);		


	///Sophy 7/9/2009 QA80-13910-P1 FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	//bool	bSheetEnable = true;
#ifndef	__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	bool	bSheetEnable = true;
#else
	bool	bSheetEnable = trData.Sheet.Enable;
#endif	//__FIX_SHEET_LEVEL_ENABLED_IF_CANCEL_CUSTOMISING_BOOK__
	///end FIX_SHEEL_LEVEL_ENABLED_WHEN_CANCEL_CUSTOMIZING_BOOKNAME
	switch(nCurveBookType)
	{
	case PDS_NONE:
		bSheetEnable = false;
		break;
	case PDS_REPORT:
		break; ///Sophy 7/3/2008 KEEP_CURVE_SHEET_VALUE_WHEN_SWITCH_BETWEEN_PANELS_ON_BOOK_TYPE_IS_REPORT //corresponding bug : when switch between Advanced & Output pages, output settings are reset .
	case PDS_NEW:
		trData.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
	case PDS_CUSTOM: ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT	
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//check_ask_custom_book_sheet_name(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//CheckAskCustomBookSheetName(trRootNode, trData.Book, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		CheckAskCustomBookSheetName(trRootNode, trData, str2ndPart, strCurveBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESULT_CURVE_BOOK);
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
		//Page pg( trData.Book.strVal.GetToken(1,'>') );
		string 	strPage;
		str_to_predefined_type(trData.Book.strVal, strPage);
		Page	pg(strPage);
		///END CLEANUP_FIT_TYPE_CODES
		if(!pg)		
		{//select default value
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//trData.Book.strVal = STR_NEW;
			//trData.Sheet.strVal = STR_NEW;
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			bSheetEnable = false;
		}
		break;
	case PDS_SOURCE: //if lpcszBook != NULL, should update trData.Book.strVal, means src data change
		if(lpcszBook)
		{
			string strBook(lpcszBook);
			///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
			//trData.Book.strVal = STR_SOURCE_BOOK + " " + strBook;
			/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			//trData.Book.strVal = MakeSpecialType(STR_SOURCE_BOOK, strBook);
			trData.Book.strVal = _make_special_type_str( STR_SOURCE_BOOK, strBook );
			/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			///end MAKE_SPECIAL_TYPE
		}
		break;
	///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	case PDS_AUTO:
		//trData.Sheet.strVal = STR_NEW; ///Sophy 7/3/2008 KEEP_CURVE_SHEET_VALUE_WHEN_SWITCH_BETWEEN_PANELS_ON_BOOK_TYPE_IS_REPORT //corresponding bug : when switch between Advanced & Output pages, output settings are reset .
		bSheetEnable = false;
		break;
	///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	default:
		break;
	}	
	if(trData.Book.Enable)
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trData.Sheet.Enable = bSheetEnable;
		SetEnableAttribute( trData.Sheet, bSheetEnable);
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	
	return true;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool update_output_curve_book_option(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook)
/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
//bool OutputGUIManagerBase::updateOutputCurveBookOption(TreeNode& trGUI, string& str2ndPart, int nCurveBookType, LPCSTR lpcszBook)
bool OutputGUIManagerBase::updateOutputCurveBookSheetOption(TreeNode& trGUI, int nCurveBookType, LPCSTR lpcszBook)
///end CLEANUP_FIT_TYPE_CODES
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	_DBCLASS("OutputGUIManagerBase::updateOutputCurveBookSheetOption")
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode 	trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	TreeNode 	trBook = trOutput.Report.Book;
	ASSERT(trBook);
	
	/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
	//int nReportBookType = str_to_predefined_type(trBook.strVal, str2ndPart);
	int nReportBookType = str_to_predefined_type(trBook.strVal);
	///end CLEANUP_FIT_TYPE_CODES
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//build_output_book_sheet_option(trGUI, nReportBookType, nCurveBookType, false, true, lpcszBook);
	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS, replace bAllowReportToSourceSheet with IsAllowReportToSourceSheet
	//buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, false, true, lpcszBook);
	buildOutputBookSheetOption(trGUI, nReportBookType, nCurveBookType, true, lpcszBook);
	///end ADD_DescStats_OUTPUT_CLASS
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	return true;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool output_curve_book_event(TreeNode& trGUI, LPCSTR lpcszBook)
bool OutputGUIManagerBase::OutputCurveBookEvent(TreeNode& trGUI, LPCSTR lpcszBook)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	_DBCLASS("OutputGUIManagerBase::OutputCurveBookEvent")
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//update_output_curve_book_setting(trGUI, trGUI.OutPut.Data, nCurveBookType, str2ndPart, lpcszBook);
	//update_output_curve_book_option(trGUI, str2ndPart, nCurveBookType, lpcszBook);
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	int nCurveBookType;
	/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
	//string str2ndPart;
	//updateOutputCurveBookSetting(trGUI, trOutput.Data, nCurveBookType, str2ndPart, lpcszBook);
	//updateOutputCurveBookOption(trGUI, str2ndPart, nCurveBookType, lpcszBook);
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE	
	//updateOutputCurveBookSheetSetting(trGUI, trOutput.Data, nCurveBookType, lpcszBook);
	updateOutputCurveBookSheetSetting(trGUI, OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI), nCurveBookType, lpcszBook);
	///end OP_DLG_NEW_STRUCTURE
	updateOutputCurveBookSheetOption(trGUI, nCurveBookType, lpcszBook);
	///end CLEANUP_FIT_TYPE_CODES
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	return true;
}
///Sophy 4/16/2008 OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT
bool OutputGUIManagerBase::OnFittedResultSheetArrangementChanged( TreeNode& trGUI )
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	if( !trOutput.RCSheet )
	{
		return false;//invalid node
	}
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.Data && trOutput.Data.Sheet ) //make sure treenoded exist
	{
		string strAttri;
		if(RESULT_SHEET_SEPARATE == trOutput.RCSheet.nVal ) //should store old attribute list and update combo list
		{
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//trOutput.Data.Sheet.Enable = !trOutput.RCSheet.Show;// if RCSheet.Show, should disable Data.Sheet,else enable it
			///Sophy 7/10/2008 DISABLE_CURVE_SHEET_ON_CHANGE_PARAM_WHEN_FIT_WITH_MULTIPLE_COLUMNS
			//trOutput.Data.Sheet.Enable = trOutput.RCSheet.Show? false : trOutput.Data.Sheet.Enable;
			bool bEnable = trOutput.RCSheet.Show? false : trOutput.Data.Sheet.Enable;
			SetEnableAttribute( trOutput.Data.Sheet, bEnable );
			///end DISABLE_CURVE_SHEET_ON_CHANGE_PARAM_WHEN_FIT_WITH_MULTIPLE_COLUMNS
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		}
		// when RCSheet.nVal is RESULT_SHEET_COMBINED ,should set Data.Sheet.Enable value true
		else
		{
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//trOutput.Data.Sheet.Enable = true;
			///Sophy 7/10/2008 DISABLE_CURVE_SHEET_ON_CHANGE_PARAM_WHEN_FIT_WITH_MULTIPLE_COLUMNS
			//trOutput.Data.Sheet.Enable = trOutput.RCSheet.Show? true : trOutput.Data.Sheet.Enable; 
			bool bEnable = trOutput.RCSheet.Show? true : trOutput.Data.Sheet.Enable;
			SetEnableAttribute( trOutput.Data.Sheet, bEnable );
			///end DISABLE_CURVE_SHEET_ON_CHANGE_PARAM_WHEN_FIT_WITH_MULTIPLE_COLUMNS
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		}
	}
	else  //invalid node
	{
		return false;
	}
	*/
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	if( trData && trData.Sheet ) //make sure treenoded exist
	{
		if ( RESULT_SHEET_SEPARATE == trOutput.RCSheet.nVal )
		{
			bool bEnable = trOutput.RCSheet.Show ? false : trData.Sheet.Enable;
			SetEnableAttribute(trData.Sheet, bEnable);
		}
	}
	else
	{
		ASSERT(FALSE);
		return false;
	}
	///end OP_DLG_NEW_STRUCTURE
	return true;
}
///end OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT

bool OutputGUIManagerBase::OnBookSheetNameChanged(TreeNode& trCurrentNode)
{
	_DBCLASS("OutputGUIManagerBase::OnBookSheetNameChanged")	
	
	if(trCurrentNode && trCurrentNode.PrevNode && !trCurrentNode.strVal.IsEmpty() && PDS_NEW == str_to_predefined_type(trCurrentNode.PrevNode.strVal) )
	{
		// if changed BookName or SheetName on GUI when type is <new>, should remember this change to attribute, if change type to other and change back to <new>, should keep user's change.
		TreeNode	trNameForNew = trCurrentNode.NextNode;
		if( trNameForNew && trNameForNew.tagName == "NameForNew" )
		{
			trNameForNew.strVal = trCurrentNode.strVal;
		}
		//if(trCurrentNode.Parent().tagName == "Report" && trCurrentNode.tagName == "SheetName" )
		//	printf("%s.%s	Set : STR_CHANGED_ATTRIB	%s  OutputGUIManagerBase::OnBookSheetNameChanged\n", trCurrentNode.Parent().tagName, trCurrentNode.tagName, trCurrentNode.strVal);
		return true;
	}
	return false;
}


///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void	update_output_report_and_curve_setting(TreeNode& trGUI, LPCSTR lpcszSrcPageName)
void	OutputGUIManagerBase::UpdateOutputReportAndCurveSetting(TreeNode& trGUI, LPCSTR lpcszSrcPageName)
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	_DBCLASS("OutputGUIManagerBase::UpdateOutputReportAndCurveSetting")
	
	string strSrcPageName(lpcszSrcPageName);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//if( !strSrcPageName.IsEmpty() )			
	//{
		//output_curve_book_event(trGUI, strSrcPageName);
		//output_report_book_event(trGUI, strSrcPageName);
	//}
	//else
	//{
		//output_curve_book_event(trGUI, NULL);
		//output_report_book_event(trGUI, NULL);
	//}
	OutputCurveBookEvent(trGUI, strSrcPageName);
	OutputReportBookEvent(trGUI, strSrcPageName);
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
}
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING

// Not used now
/////Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//bool OutputGUIManagerBase::isNLFitOutputEvent(const TreeNode& tr)
//{
	//int nNLFitOutputEvent = 0;
	//tr.GetAttribute(STR_NLFIT_OUTPUT_NODE_EVENT_ATTRIB, nNLFitOutputEvent);
	//if(nNLFitOutputEvent == NLFIT_OUTPUT_NODE_EVENT)
		//return true;
	//
	//return false;	
//}

///Sophy/Iris 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
void	OutputGUIManagerBase::UpdateOutputOnDataChange(TreeNode& trGUI)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode	trOuput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	bool	bRet;
	
	if(trOutput.Report)
	{
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//checkSourceEntryToUpdateCombo(trOuput.Report.Book, true);
		//checkSourceEntryToUpdateCombo(trOuput.Report.Sheet, false);
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trOutput.Report.Book, true);
		/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG, 
		// to fix if open dialog without select data, --> BookName is empty, acceptable; but after select data in dialog, ==> BookName still empty
		//if( bRet ) 
		///end FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setReportBookSheetName(trGUI, trOutput, UPDATE_BOOK); //update bookname
		}
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trOutput.Report.Sheet, false);
		//if( bRet ) /// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setReportBookSheetName(trGUI, trOutput, UPDATE_SHEET); //update sheetname
		}
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	}
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	if ( trData )
	{
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//checkSourceEntryToUpdateCombo(trOuput.Data.Book, true);
		//checkSourceEntryToUpdateCombo(trOuput.Data.Sheet, false);
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trData.Book, true);
		//if( bRet ) /// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setCurveBookSheetName(trGUI, trOutput, UPDATE_BOOK); //update bookname
		}
		
		bRet = CheckSourceEntryToUpdateCombo(trGUI, trData.Sheet, false);
		//if( bRet ) /// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setCurveBookSheetName(trGUI, trOutput, UPDATE_SHEET); //update sheetname
		}
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///Sophy 4/16/2008 OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT
		OnFittedResultSheetArrangementChanged( trGUI ); //to update the status of Data.Sheet.Enable
		///end OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT		
	}
}


///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE

TreeNode OutputGUIManagerBase::GetGUITree(TreeNode& tr)
{
	return tr;
}
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void check_ask_custom_book_sheet_name(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType)
///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
//void OutputGUIManagerBase::CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trReport, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType)
///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
//void	OutputGUIManagerBase::CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trBookSheetBranch, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType)
bool	OutputGUIManagerBase::CheckAskCustomBookSheetName(TreeNode& trGUI, TreeNode& trBookSheetBranch, const string& str2ndPart, const string& strReportBook, bool bSheet, int nDBTY, int nSheetType, int nBookSheetType)
///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	if(str2ndPart.Compare(STR_THREE_DOTS))
	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	//	return;
		return false;
	///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	bool	bChanged = false;	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	string	strOutput;
	if (!bSheet) //book
	{
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//int		nReportMatrix = 0;
		//if(trGUI.Output.Data)
		//	trGUI.Output.Data.GetAttribute(STR_REPORT_MATRIX_DATA, nReportMatrix);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//int		nOutputType = 0;
		///end CLEANUP_FIT_TYPE_CODES
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(trGUI.Output.Data)
		//	trGUI.Output.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
		///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
		//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
		TreeNode trOutput = GetOutputNode( trGUI );
		///end GET_SUB_TREENODE_BY_ID_RECURSIVE
		ASSERT(trOutput);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//if(trOutput.Data)
		//	trOutput.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
		///end CLEANUP_FIT_TYPE_CODES
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		
		bool bWks;
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//_check_wks_or_matrix_book_sheet(nReportMatrix, nBookSheetType, bWks);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//checkWksOrMatrixBookSheet(nOutputType, nBookSheetType, bWks);
		CheckWksOrMatrixBookSheet(nBookSheetType, bWks);
		///end CLEANUP_FIT_TYPE_CODES
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		
		string 	strPath = "Originlab\\ProjectBrowser.c";
		///---Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
		//FUNC_STR_DWORD_HWND_BOOL pfn;
		//pfn = Project.FindFunction("ProjectBrowseBook", strPath);
		static FUNC_STR_DWORD_HWND_BOOL pfn = Project.FindFunction("ProjectBrowseBook", strPath);
		///---END ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT

		string 	strSelectedName;
		///Sophy 7/9/2009 QA80-13910-P2 NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
		//if( pfn && pfn(strSelectedName, 0, GetWindow(), bWks) && !strSelectedName.IsEmpty())
#ifndef	__NLFIT_DLG_BECOME_MODELESS__
		if( pfn && pfn(strSelectedName, 0, GetWindow(), bWks) && !strSelectedName.IsEmpty())
#else
		if( pfn && pfn(strSelectedName, 0, GetWindow(OGW_DB_ACTIVE_DLG), bWks) && !strSelectedName.IsEmpty())
#endif	//__NLFIT_DLG_BECOME_MODELESS__
		///end NLFIT_DLG_BECOME_MODELESS_AFTER_CUSTOMIZING_BOOK_SHEET_NAME
		{
			///Sophy/Iris 4/14/2008 MAKE_SPECIAL_TYPE
			//strSelectedName = STR_CUSTOM + strSelectedName;
			/// Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			//strSelectedName = MakeSpecialType(STR_CUSTOM, strSelectedName);
			strSelectedName = _make_special_type_str( STR_CUSTOM, strSelectedName );
			/// end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
			///end MAKE_SPECIAL_TYPE
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//set_str_insert_combo(trReport, strSelectedName, STR_CUSTOM + STR_THREE_DOTS);
			set_str_insert_combo(trBookSheetBranch.Book, strSelectedName, STR_CUSTOM + STR_THREE_DOTS);
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			bChanged = true; ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		}
		else
		{
			string strOldComboVal;
			///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			//trReport.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldComboVal);
			//trReport.strVal = strOldComboVal;
			trBookSheetBranch.Book.GetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldComboVal);
			trBookSheetBranch.Book.strVal = strOldComboVal;
			///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		}
	}	
	else//sheet
	{
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		/*
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(_open_custom_input_box(trGUI, strReportBook, strOutput, bSheet, nDBTY, nSheetType))
		if(openCustomInputBox(trGUI, strReportBook, strOutput, bSheet, nDBTY, nSheetType))
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL	
		{
			trReport.strVal = strOutput;
			//insert custom string to drop down string list
			string strAttri;
			trReport.GetAttribute(STR_COMBO_ATTRIB, strAttri);
			///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS,STR_TOKEN_SEP);
			insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS,true, STR_TOKEN_SEP);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			trReport.SetAttribute(STR_COMBO_ATTRIB, strAttri);		
		}
		else
			trReport.strVal = STR_NEW;
		*/
		if(openCustomInputBox(trBookSheetBranch, strReportBook, strOutput, bSheet, nDBTY, nSheetType))
		{
			///Sophy 7/3/2008 INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE
			/*
			trBookSheetBranch.Sheet.strVal = strOutput;
			string strAttri;
			trBookSheetBranch.Sheet.GetAttribute(STR_COMBO_ATTRIB, strAttri);
			insert_str_to_str_list(strOutput, strAttri, STR_CUSTOM + STR_THREE_DOTS,true, STR_TOKEN_SEP);
			trBookSheetBranch.Sheet.SetAttribute(STR_COMBO_ATTRIB, strAttri);
			*/
			set_str_insert_combo( trBookSheetBranch.Sheet, strOutput, STR_CUSTOM + STR_THREE_DOTS, true );
			///end INSERT_STR_INTO_TREENODE_COMBO_WITHOUT_UPDATE_ITS_VALUE
			bChanged = true; ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		}
		else
		{
			string strOldVal;
			trBookSheetBranch.Sheet.GetAttribute( STR_ATTRIB_OLD_COMBO_VAL, strOldVal);
			trBookSheetBranch.Sheet.strVal = strOldVal;
		}
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	}
	
	return bChanged;	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE

}


/// YuI 05/23/05
TreeNode OutputGUIManagerBase::getXFunctionTreeNodeFromDataNode(TreeNode& trData)
{
	TreeNode trReturn;
	if( !trData )
		return trReturn;
	TreeNode trVar = trData.Parent();
	if( !trVar )
		return trReturn;
	TreeNode trVars = trVar.Parent();
	if( !trVars )
		return trReturn;
	trReturn = trVars.Parent();
	return trReturn;
}
/// end YuI 05/23/05


void	OutputGUIManagerBase::xvarsBuildDataBranch(TreeNode &trData, string &strSourcePage, string &strSourceLayer)
{
	string strCurrentlySelectedPage = trData.Book.strVal;
	string strBook = buildPageContextList(strSourcePage, EXIST_WKS);
	trData.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);

	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	//if( strCurrentlySelectedPage.IsEmpty() || strCurrentlySelectedPage.Compare(STR_SOURCE_BOOK) )
	///Sophy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//if ( PDS_SOURCE != cvt_str_to_predefined_type(strCurrentlySelectedPage) )
	if ( PDS_SOURCE != str_to_predefined_type(strCurrentlySelectedPage) )
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	///---END CLEAN_LOCALIZATION_CODE
		checkNodeStrvalWithComboItems(trData.Book, STR_SAME);
		/// end XVARIABLE_SAME_IMPLEMENTATION
		
	strCurrentlySelectedPage = trData.Book.strVal;
	int nBookType = str_to_predefined_type(strCurrentlySelectedPage);	
	
	bool bDefaultSourceSheet = false;
	
	string strSeletedBook;
	if( PDS_SOURCE == nBookType )
	{		
		strSeletedBook = strSourcePage;
		if(!strSourceLayer.IsEmpty())
			bDefaultSourceSheet = true;
	}
	else
		strSeletedBook  = trData.Book.strVal;
	
	string strSheet = buildLayerContextList(strSourceLayer, strSeletedBook, nBookType);

	//	trData.Sheet.strVal =  STR_SOURCE_BOOK;
	int nSheetType = str_to_predefined_type(trData.Sheet.strVal);	
	trData.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
	
	if( nSheetType == PDS_SAME )
		checkNodeStrvalWithComboItems(trData.Sheet, STR_SAME);
	else
		checkNodeStrvalWithComboItems(trData.Sheet, bDefaultSourceSheet? STR_SOURCE_BOOK : STR_SAME);
}

string OutputGUIManagerBase::buildLayerContextList( LPCSTR lpcszSource,LPCSTR lpcszPageName , int nBookType)
{
	string strList;
	
	vector<string> vsList;
	
	getLayerNameFromPage(vsList, lpcszPageName);
	
	strList = buildContextList(vsList, lpcszSource, nBookType, false);
	
	return strList;
}

void OutputGUIManagerBase::getLayerNameFromPage(vector<string> &vsLayerList, string &strPageName)
{
	Page pg(strPageName);
	vsLayerList.RemoveAll();
	if(!pg)
		return ;
	foreach(Layer lay in pg.Layers)
		vsLayerList.Add(lay.GetName());
}

string OutputGUIManagerBase::buildContextList(vector<string> vsList, LPCSTR lpcszSource, int nBookType, bool bIsPageList)
{
	string strList;
	
	bool bInsertSource = true;
	
	if(!bIsPageList && PDS_SOURCE != nBookType)
		bInsertSource = false;
	
	if(bInsertSource)
	{
		int nSourceIndex = vsList.Find(lpcszSource);
		
		if(nSourceIndex >= 0)
		{
			vsList.RemoveAt(nSourceIndex);
			///Insert the source book to first of the vector
			vsList.InsertAt(0, lpcszSource);
			
			///<source> item should in second of the list.
			vsList.InsertAt(0, STR_SOURCE_BOOK);
		}
	}
	
	///<New> item should in the first of the list
	vsList.InsertAt(0, STR_NEW);
	
	/// YuI 05/23/05 XVARIABLE_SAME_IMPLEMENTATION
	// later will add some logic when <same> is appropriate entry
	// for now insert always
	vsList.InsertAt(1, STR_SAME);
	/// end XVARIABLE_SAME_IMPLEMENTATION
	char	chToken = '|';
	int nListItemCount = strList.SetTokens(vsList,chToken );
	
	return strList;
}

// Return: TRUE if value ok or value set to default, FALSE if could not check
BOOL OutputGUIManagerBase::checkNodeStrvalWithComboItems(TreeNode& tn, LPCSTR lpcszDefault)
{
	// Tree node is required
	if( !tn.IsValid() )
		return FALSE; // invalid tree node

	// Tree node must have the Combo attribute
	string strCombo;
	if( !tn.GetAttribute(STR_COMBO_ATTRIB, strCombo) )
		return FALSE; // no Combo attribute

	// Default string must be a Combo item
	if( !isStrToken(lpcszDefault, strCombo, '|') )
	//---- CPY 4/16/05 ACTIVE_BOOK_SHEET_AS_DEFAULT_FOR_XF
	//		return FALSE;
	{
		error_report("OutputGUIManagerBase::checkNodeStrvalWithComboItems found default not in combo list");
		strCombo += (string)STR_TOKEN_SEP + lpcszDefault;
		tn.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	}
	//----
	
	// If value is not a Combo item then set value to default
	if( !isStrToken(tn.strVal, strCombo, '|') )
		tn.strVal = lpcszDefault;
	
	return TRUE;
}

/// EJP 2005-04-13 v8.0222 QA70-7615 XFUNC_TREEVIEW_SHOW_WRONG_DATA_BOOK_AND_SHEET
BOOL OutputGUIManagerBase::isStrToken(LPCSTR lpcszFind, LPCSTR lpcszTokens, char chDelimiter)
{
	if( lpcszFind == NULL || *lpcszFind == 0 )
		return FALSE;

	string strTokens = lpcszTokens;

	///int n = strTokens.Find(lpcszFind);
	///if( -1 == n || (n > 0 && chDelimiter != strTokens[n - 1] )
	///	return FALSE;

	int nTokens = strTokens.GetNumTokens(chDelimiter);
	string strToken;
	for( int nToken = 0; nToken < nTokens; nToken++ )
	{
		strToken = strTokens.GetToken(nToken, chDelimiter);
		if( 0 == strToken.Find(lpcszFind) )
			return TRUE;
	}
	return FALSE;
}


///Sophy 11/28/2008 KEEP_PA_OUTPUT_BRANCH_ENABLE_WHEN_HASNOT_BEEN_REPORTED
bool	OutputGUIManagerBase::hasOutputReported(const TreeNode& trNode, const int nOutputRangeIndex)
{
	TreeNode Output = trNode.Parent().Parent();
	TreeNode trGUI = Output.Parent();
	
	///---Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	//HAS_CURVE_REPORTED pfn = Project.FindFunction("has_output_one_range_been_reported", "OriginLab\\wksoperation.c", TRUE);
	static HAS_CURVE_REPORTED pfn = Project.FindFunction("has_output_one_range_been_reported", "OriginLab\\wksoperation.c", TRUE);
	///---END ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
	if( !pfn ) //if can not find function, treat as has been reported
		return true;
	
	if( OUTPUT_CALIBRATION_CURVE_SHEET_1_RNG_INDEX == nOutputRangeIndex )
	{
		if( pfn(trGUI, nOutputRangeIndex) || pfn(trGUI, OUTPUT_CALIBRATION_CURVE_SHEET_2_RNG_INDEX) )
			return true;
		else
			return false;
	}
	else
		return pfn(trGUI, nOutputRangeIndex);
}

///end KEEP_PA_OUTPUT_BRANCH_ENABLE_WHEN_HASNOT_BEEN_REPORTED

/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
/*
bool OutputGUIManagerBase::isStatsOnRows(TreeNode& trGUI)
{
	return (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true:false;
}
*/
/// Sophy 5/04/2008 NLFIT_SHEET_SETTING_CANNOT_BE_SAVED_IN_THEME
bool OutputGUIManagerBase::IsAllowToSourceSheet(TreeNode& trGUI, TreeNode& trSheet)
{
	bool bIsAllowed = false;
	switch( trSheet.DataID )
	{
	case IDE_REPORT_SHEET:
		bIsAllowed = IsAllowReportToSourceSheet( trGUI );
		break;
	case IDE_FIND_XY_SHEET:
		bIsAllowed = false;   // FINDXY branch sheet keep <new>
		break;
	case IDE_RESIDUAL_CURVE_SHEET:
	case IDE_RESULT_CURVE_SHEET:
	case IDE_PARTIAL_CURVE_SHEET:
		///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		/*
		///Sophy 5/04/2008 FIX_PA_FIT_PEAK_TREENODE_DENY_ACCESS
		//ASSERT( trGUI.Output);
		TreeNode trOutput = GetOutputNode( trGUI );
		ASSERT( trOutput );
		///End FIX_PA_FIT_PEAK_TREENODE_DENY_ACCESS
		bIsAllowed = IsAllowCurveReportToSourceSheet( trOutput);
		*/
		///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
		//bIsAllowed = IsAllowCurveToSourceSheet( trGUI, trSheet );	
		TreeNode trOutput = GetOutputNode( trGUI );
		ASSERT( trOutput );
		bIsAllowed = IsAllowCurveReportToSourceSheet( trOutput, trSheet );
		///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
		///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		break;
	default:
		break;
	}
	return bIsAllowed;
}
/// End NLFIT_SHEET_SETTING_CANNOT_BE_SAVED_IN_THEME
bool OutputGUIManagerBase::IsAllowReportToSourceSheet(TreeNode& trGUI)
{
	return false;
}
///end ADD_DescStats_OUTPUT_CLASS

/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
/*
bool		OutputGUIManagerBase::IsAllowCurveReportToSourceSheet(TreeNode& trOutput)
{
	ASSERT(trOutput);
	if(!trOutput.Data.Book)
		return error_report("Output.Data.Book doesn't exist in OutputGUIManagerBase::IsAllowCurveReportToSourceSheet");
	
	int 	nCurveBookType = str_to_predefined_type(trOutput.Data.Book.strVal);
	return (PDS_SOURCE == nCurveBookType);
}
*/
bool		OutputGUIManagerBase::IsAllowCurveReportToSourceSheet(TreeNode& trOutput, TreeNode& trSheet )
{
	TreeNode trBookSheetBranch = trSheet.Parent();
	ASSERT( trBookSheetBranch );
	
	int		nCurveType = str_to_predefined_type( trBookSheetBranch.Book.strVal );
	return( PDS_SOURCE == nCurveType );
}
///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
///end MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET

/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
static bool _is_allow_report_to_report_book(TreeNode& trNode)
{
	ASSERT(trNode);
	return ( PDS_NONE != str_to_predefined_type(trNode.strVal) );	
}

bool		OutputGUIManagerBase::IsAllowReportToReportBook(TreeNode& trOutput, int nNodeID)
{
	if(IDE_RESULT_CURVE_BOOK == nNodeID)
		return IsAllowCurveReportToReportBook(trOutput);

	return _is_allow_report_to_report_book(trOutput.Report.Book);
}
///end ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK

/// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
bool		OutputGUIManagerBase::IsAllowCurveReportToReportBook(TreeNode& trOutput)
{
	ASSERT(trOutput);
	ASSERT(trOutput.Report.Book);
	
	/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
	//int 	nReportBookType = str_to_predefined_type(trOutput.Report.Book.strVal);
	//return (PDS_NONE != nReportBookType);
	return _is_allow_report_to_report_book(trOutput.Report.Book);
	///end ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
}
///end REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
bool		OutputGUIManagerBase::IsAllowCurveReportToSourceBook( TreeNode& trGUI )
{
	///Sophy 6/20/2008 QA80-10536-P3 FORBID_OUTPUT_TO_SOURCE_WHEN_FIT_FROM_ABNORMAL_BOOK_GRAPH
	//return true;
	TreeNode trInput = GetInputDataNode( trGUI );
	ASSERT( trInput );
	return is_range_from_normal_book( trInput );
	///end FORBID_OUTPUT_TO_SOURCE_WHEN_FIT_FROM_ABNORMAL_BOOK_GRAPH
}

bool		OutputGUIManagerBase::IsAllowToSourceBook( TreeNode& trGUI, TreeNode& trBook)
{
	bool	bIsAllowed = false;
	switch( trBook.DataID )
	{
	case IDE_REOPRT_BOOK:
		bIsAllowed = IsAllowReportToSourceBook( trGUI );
		break;
	///Sophy 6/26/2008 CLEAN_CODE
	/*
	case IDE_RESULT_CURVE_BOOK:
		bIsAllowed = IsAllowCurveReportToSourceBook( trGUI );
		break;
	default:
		///Sophy 6/20/2008 QA80-10536-P3 FORBID_OUTPUT_TO_SOURCE_WHEN_FIT_FROM_ABNORMAL_BOOK_GRAPH
		//bIsAllowed = true;
		bIsAllowed = IsAllowCurveReportToSourceBook( trGUI );
		break;
		///end FORBID_OUTPUT_TO_SOURCE_WHEN_FIT_FROM_ABNORMAL_BOOK_GRAPH
	*/
	default:
		bIsAllowed = IsAllowCurveReportToSourceBook( trGUI );
	///end CLEAN_CODE
	}
	return bIsAllowed;
}
///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
/* use IsAllowCurveReportToSourceSheet instead of this function
bool		OutputGUIManagerBase::IsAllowCurveToSourceSheet( TreeNode& trGUI, TreeNode& trSheet)
{
	TreeNode trBookSheetBranch = trSheet.Parent();
	ASSERT( trBookSheetBranch );
	
	int		nCurveType = str_to_predefined_type( trBookSheetBranch.Book.strVal );
	
	return( PDS_SOURCE == nCurveType );
}
*/
///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
string OutputGUIManagerBase::buildPageContextList( LPCSTR lpcszSource, uint nPageType, int nBookType)
{
	string strList;
	
	vector<string> vsList;
	
	///Cheney 2007-8-23 QA70-10290 FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	//_get_project_pages_name(vsList, nPageType);
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING 
	//FUNC_GET_PROJECT_PAGE_NAMES pfn = Project.FindFunction("get_project_pages_name", "OriginLab\\Event_utils", true);
	//if(pfn)
	//	pfn(vsList, nPageType);
	get_project_pages_name(vsList, nPageType);
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	///end FITCURVE_AND_REPORT_SHOULD_BE_SAME_BOOK_IF_SRC_DATA_FROM_DIFF_BOOK
	
	strList = buildContextList(vsList, lpcszSource, nBookType);
	
	return strList;
}

/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
bool	OutputGUIManagerBase::CheckUpdateOnNoReport(TreeNode& trGUI, TreeNode& trBookSheetBranch)
{
	bool	bValChanged = false;
	if( !trBookSheetBranch )
		return bValChanged;
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode	trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput.Report.Book);
	
	string	strReportBook = trOutput.Report.Book.strVal;
	///Sophy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//int 	nReportBookType = cvt_str_to_predefined_type(strReportBook);
	int 	nReportBookType = str_to_predefined_type(strReportBook);	
	///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
	//check update values of .Book and .Sheet on the type of Output.Report.Book
	if(PDS_NONE == nReportBookType)
	{
		///Sophy 4/25/08 ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		//if(PDS_REPORT == cvt_str_to_predefined_type(trBookSheetBranch.Book.strVal))
		if(PDS_REPORT == str_to_predefined_type(trBookSheetBranch.Book.strVal))
		///end ROW_STATS_PUT_RESULTS_COL_TO_BEGINNING_OF_SRC_SHEET
		{
			if( !IsAllowReportToSourceBook( trGUI ) )
			{
				trBookSheetBranch.Book.strVal = STR_NEW;
				trBookSheetBranch.Sheet.strVal = STR_NEW;
			}
			else
			{
				string strCombo;
				if(trBookSheetBranch.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
				///Sophy 5/26/2008 FIX_FIT_CURVE_BOOKNAME_BECOME_EMPTY_WHEN_REPORT_BOOK_SHIFT_TO_NONE
				//	trBookSheetBranch.Book.strVal = strCombo.GetToken(1, '|');//to get source entry
				{
					trBookSheetBranch.Book.strVal = strCombo.GetToken(1, '|');
				}
				///end FIX_FIT_CURVE_BOOKNAME_BECOME_EMPTY_WHEN_REPORT_BOOK_SHIFT_TO_NONE
			}
			bValChanged = true;
		}
	}
	
	// check update Combo of .Book on the type of Output.Report.Book is None
	string		strBook;
	if( trBookSheetBranch.Book.GetAttribute(STR_COMBO_ATTRIB, strBook) )
	{
		if( !IsAllowReportToReportBook(trOutput, trBookSheetBranch.Book.DataID) )
		{
			remove_str_from_str_list(STR_REPORT, strBook);
		}
		else 
		{
			insert_str_to_str_list(STR_REPORT, strBook, STR_NEW);
		}
		trBookSheetBranch.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);
	}
	return bValChanged;
	
}
///END ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
	
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet, bool bAllowReportToSrcBook, LPCSTR lpcszBook)
/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//void build_output_book_sheet_option(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet, bool bAllowReportToSrcBook, LPCSTR lpcszBook, bool bIsNLFitOutputEvent)
/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS, replace bAllowReportToSourceSheet with IsAllowReportToSourceSheet
//void OutputGUIManagerBase::buildOutputBookSheetOption(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSourceSheet, bool bAllowReportToSrcBook, LPCSTR lpcszBook)
void 	OutputGUIManagerBase::buildOutputBookSheetOption(TreeNode& trGUI, int nReportBookType, int nCurveBookType, bool bAllowReportToSrcBook, LPCSTR lpcszBook)
///end ADD_DescStats_OUTPUT_CLASS
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	_DBCLASS("OutputGUIManagerBase::buildOutputBookSheetOption")
	string strBook, strSheet;
	
	//bool bNoReport = PDS_NONE == nReportBookType? true:false; /// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
	//bool bReportSource = PDS_SOURCE == nReportBookType? true:false; /// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
	/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
	//bool bCurveSource = PDS_SOURCE == nCurveBookType? true:false;
	///end MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET

	/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS	
	//if(!bAllowReportToSourceSheet)
		//bReportSource = false;
	////--------- CPY 10/15/07 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING_BROKE_STATS_ON_ROWS
	//else if(!bReportSource && PDS_AUTO == nReportBookType)
		//bReportSource = true; // can add code later to <new> if does not really make sense to do so, but at this point, we should allow
	////---------
	///end ADD_DescStats_OUTPUT_CLASS
	
	///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
	//string strReportBook = STR_SOURCE_BOOK;
	string strCurveBook = STR_AUTO + STR_TOKEN_SEP + STR_SOURCE_BOOK;
	///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	if(lpcszBook)
	{
		string strBook(lpcszBook);
		///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
		//strCurveBook += " " + strBook;
		///Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		//strCurveBook = MakeSpecialType(strCurveBook, strBook);
		strCurveBook = _make_special_type_str( strCurveBook, strBook );
		///end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		///end MAKE_SPECIAL_TYPE
	}
	
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trCurves = trGUI.Output.Data;
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trCurves = trOutput.Data;
	TreeNode trCurves = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	if(trCurves)
	{
		/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK		
		///// Iris 04/10/2008 NO_REAL_SHEET_NAME_IN_REPORT_SHEET, moved from old OutputGUIManagerBase::OutputReportBookEvent, the logic of updating Output.Curve should keep in this method.
		////check update .Book and .Sheet on the type of Output.Report.Book
		//if(PDS_NONE == nReportBookType)
		//{
			//if(PDS_REPORT == cvt_str_to_predefined_type(trCurves.Book.strVal))
			//{
				//if( !IsAllowReportToSourceBook( trGUI ) )
				//{
					//trCurves.Book.strVal = STR_NEW;
					//trCurves.Sheet.strVal = STR_NEW;
				//}
				//else
				//{
					//string strCombo;
					//if(trCurves.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
						//trCurves.Book.strVal = strCombo.GetToken(1, '|');//to get source entry
				//}
			//}
		//}
		/////end NO_REAL_SHEET_NAME_IN_REPORT_SHEET
		///end ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
		
		
		trCurves.Book.GetAttribute(STR_COMBO_ATTRIB, strBook); 
		trCurves.Sheet.GetAttribute(STR_COMBO_ATTRIB, strSheet);
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//if(strBook.IsEmpty() || lpcszBook) //need update combo list
		if(strBook.IsEmpty() ) //need update combo list
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
			strBook = strCurveBook + STR_TOKEN_SEP + STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		
		if(strSheet.IsEmpty())
			strSheet = STR_SOURCE_BOOK + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		
		/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
		///// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
		////if(bNoReport)
		//if( !IsAllowCurveReportToReportBook(trOutput) )
		/////end REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
		//{
			//remove_str_from_str_list(STR_REPORT, strBook);
			//remove_str_from_str_list(STR_REPORT, strSheet); //Iris 4/07/2008 (Just added Comments - always not allow report curve data to report sheet since report sheet is a hierarchy sheet but curve sheet must be flat sheet.)
		//}
		//else 
		//{
			//insert_str_to_str_list(STR_REPORT, strBook, STR_NEW);
		//}
		///end ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
		
		/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
		//if(bCurveSource)
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		/* replaced by CheckSourceEntryToUpdateCombo
		//if( IsAllowCurveReportToSourceSheet(trOutput) )
		/////end MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET	
		//{
			//insert_str_to_str_list(STR_SOURCE_BOOK, strSheet, STR_NEW);
		//}
		//else
		//{
			//remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
		//}
		*/
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES, setup in CheckUpdateFitOutputBookSheetGUI
		/*
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//int		nOutputToMatrix = 0;
		//if( trCurves.GetAttribute(STR_REPORT_MATRIX_DATA, nOutputToMatrix))
		//{
		//	if(nOutputToMatrix == 1) //surface fitting, = 2 matrix Fitting
		int nOutputType = 0; 
		if( trCurves.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) )
		{
			if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING) 
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			{
				remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			}
			remove_str_from_str_list(STR_REPORT, strBook);
			remove_str_from_str_list(STR_REPORT, strSheet);
			remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
			remove_str_from_str_list(STR_CUSTOM, strSheet);
			if(trCurves.Book.strVal.IsEmpty())
			{
				///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
				//if(nOutputToMatrix == 1)
				if(nOutputType == OPERATION_OUTPUT_XYZ_FITTING)
				///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
					trCurves.Book.strVal = STR_NEW;
				else
					trCurves.Book.strVal = STR_SOURCE_BOOK;
			}
				
			if(trCurves.Sheet.strVal.IsEmpty())
				trCurves.Sheet.strVal = STR_NEW;
		}
		*/
		///end CLEANUP_FIT_TYPE_CODES
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		/* replaced by CheckSourceEntryToUpdateCombo
		//if(!bAllowReportToSrcBook)
		//{
			/////Cheney QA70-10315 IF_SOURCE_DATA_FROM_EXCEL_SHOULD_NOT_ADD_FIT_CURVE_TO_SOURCE
			////remove_str_from_str_list(STR_SOURCE_BOOK, strBook);
			////remove_str_from_str_list(STR_SOURCE_BOOK, strSheet);
			//string strSourceBook = STR_SOURCE_BOOK;
			//if(lpcszBook)
			//{
				//string str(lpcszBook);
				/////Sophy 4/10/2008 MAKE_SPECIAL_TYPE
				////strSourceBook += " " + str;
				/////Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
				////strSourceBook = MakeSpecialType(STR_SOURCE_BOOK, str);
				//strSourceBook = _make_special_type_str( STR_SOURCE_BOOK, str );
				/////end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
				/////end MAKE_SPECIAL_TYPE
			//}
			//remove_str_from_str_list(strSourceBook, strBook);
			//remove_str_from_str_list(strSourceBook, strSheet);
			/////end IF_SOURCE_DATA_FROM_EXCEL_SHOULD_NOT_ADD_FIT_CURVE_TO_SOURCE
		//}
		*/
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		/*
		/////Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		//if theme has existd info, should insert in combo
		string strSelectedBookName, strSelectedSheetName;
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
		//get_selected_book_sheet_name(trCurves.Book, trCurves.Sheet, strSelectedBookName, strSelectedSheetName);
		/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
		//getSelectedBookSheetName(trCurves.Book, trCurves.Sheet, nOutputType, IDE_RESULT_CURVE_BOOK, strSelectedBookName, strSelectedSheetName);
		getSelectedBookSheetName(trCurves.Book, trCurves.Sheet, IDE_RESULT_CURVE_BOOK, strSelectedBookName, strSelectedSheetName);
		///end CLEANUP_FIT_TYPE_CODES
		
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		
		trCurves.Book.SetAttribute(STR_COMBO_ATTRIB, strBook);  	
		checkCorrectOutputOption(trCurves.Book, STR_NEW);
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(!strSelectedBookName.IsEmpty())
			set_str_insert_combo(trCurves.Book, strSelectedBookName, STR_CUSTOM + STR_THREE_DOTS); 
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		trCurves.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);			
		checkCorrectOutputOption(trCurves.Sheet, STR_NEW);
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(!strSelectedSheetName.IsEmpty())
			set_str_insert_combo(trCurves.Sheet, strSelectedSheetName, STR_CUSTOM + STR_THREE_DOTS); 	
		///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		*/
		///Sophy 4/9/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trCurves, strBook, NULL, strSheet, NULL);
		UpdateOutputBookSheetDestination(trGUI, trCurves, strBook, NULL, strSheet, NULL);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES	
		///Sophy 4/16/2008 OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT
		OnFittedResultSheetArrangementChanged( trGUI );
		///end OUTPUT_DATA_SHEET_ENABLE_NOT_UNIVERSUALLY_CORRECT
		
		// remove or add <report> for Ouput.Data.Book when Output.Report.Book is <None> or others
		CheckUpdateOnNoReport(trGUI, trCurves); /// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		/*
		CheckUpdateSourceCustomEntry(trGUI, trCurves.Book,true);
		SetOneBookSheetName( trGUI, trOutput, trCurves, UPDATE_BOOK );	//need to update bookname
		
		CheckUpdateSourceCustomEntry(trGUI, trCurves.Sheet,false);
		SetOneBookSheetName( trGUI, trOutput, trCurves, UPDATE_SHEET);
		*/
		UpdateBranchOnBookChange( trGUI, trCurves );
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	}
	else // if no Curve output, then only update Sheet from Book
	{
		bool 	bReportSource = IsAllowReportToSourceSheet(trGUI); /// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
		
		strSheet = STR_NEW + STR_TOKEN_SEP;
		if(bReportSource)
			strSheet += STR_SOURCE_BOOK;
	
		// should include <existing...> option for Sheet for Stats on Rows when Book is <existing...>
		//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
		//if(trGUI.StatsOnRows && trGUI.StatsOnRows.nVal && PDS_CUSTOM == nReportBookType && trGUI.Output.Report.Sheet.Enable)// stats on rows
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//if(_is_stats_on_rows(trGUI) && PDS_CUSTOM == nReportBookType && trGUI.Output.Report.Sheet.Enable)
		/// Iris 4-05-2008 ADD_DescStats_OUTPUT_CLASS
		//if(isStatsOnRows(trGUI) && PDS_CUSTOM == nReportBookType && trOutput.Report.Sheet.Enable)
		if(bReportSource && PDS_CUSTOM == nReportBookType && trOutput.Report.Sheet.Enable)
		///end ADD_DescStats_OUTPUT_CLASS
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL 
		//------
		{
			strSheet = STR_NEW + "|" + STR_CUSTOM + STR_THREE_DOTS; ///Arvin 08/31/07 PDS_CUSTOM_CAN_NOT_WORK_IN_STATS_ON_ROWS
		}
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//trGUI.Output.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
		trOutput.Report.Sheet.SetAttribute(STR_COMBO_ATTRIB, strSheet);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
		
		string strDefault = bReportSource? STR_SOURCE_BOOK : STR_NEW;
		///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
		//_check_correct_output_option(trGUI.Output.Report.Sheet, strDefault);
		checkCorrectOutputOption(trOutput.Report.Sheet, strDefault);
		///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	}

}

/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
/*
/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
//void	OutputGUIManagerBase::getSelectedBookSheetName(const TreeNode& trBook, const TreeNode& trSheet, int nOutputType, int nBookSheetType, string& strSelectedBookName, string& strSelectedSheetName)
void	OutputGUIManagerBase::getSelectedBookSheetName(const TreeNode& trBook, const TreeNode& trSheet, int nBookSheetType, string& strSelectedBookName, string& strSelectedSheetName)
///end CLEANUP_FIT_TYPE_CODES
{
	/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	//string strBook = trBook.strVal;
	//string strSheet;
	//if(trSheet)
		//strSheet = trSheet.strVal;
	//_get_custom_book_or_sheet_name(strBook);
	//_get_custom_book_or_sheet_name(strSheet);
	string 	strBook, strSheet;
	if(trBook)
		str_to_predefined_type(trBook.strVal, strBook);
	if(trSheet)
		str_to_predefined_type(trSheet.strVal, strSheet);
	///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
	
	bool bWks = false;
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
	//checkWksOrMatrixBookSheet(nOutputType, nBookSheetType, bWks);
	CheckWksOrMatrixBookSheet(nBookSheetType, bWks);
	///end CLEANUP_FIT_TYPE_CODES
	
	Page pg;
	if(bWks)
	{
		WorksheetPage wp(strBook);
		pg = wp;
	}
	else
	{
		MatrixPage mp(strBook);
		pg = mp;
	}
	
	if(!pg)
		return;
	
	if(strSelectedBookName)
		strSelectedBookName = trBook.strVal;
	
	Layer ly = pg.Layers(strSheet);
	if(ly && strSelectedSheetName && trSheet)
		strSelectedSheetName = trSheet.strVal;
}
*/
///end CLEAN_UPDATE_COMBO_CODES

void OutputGUIManagerBase::checkCorrectOutputOption(TreeNode& trOutput, LPCSTR lpcszCorrect)
{
	if(!trOutput)
		return;
	
	string strOptions;
	trOutput.GetAttribute(STR_COMBO_ATTRIB, strOptions);
	
	string strVal = trOutput.strVal;
	string str2ndPart;
	int nType = str_to_predefined_type(strVal, str2ndPart);
	if( 0 != str2ndPart.Compare(strVal) && !str2ndPart.IsEmpty())
		return;
	if(-1 == strOptions.Find(strVal))
		trOutput.strVal = (NULL == lpcszCorrect)? strOptions.GetToken(0) : lpcszCorrect;
}


//CPY 10/15/07 QA70-10536 POST_SR0_725_OUTPUT_LOCATION_CLEANUP
//need to be properly cleaned up to support both Auto and Theme
// based on bAllowToSource, properly reset trBook.strVal and the combo list
// it not yet initialized, then init to Auto
/// Iris 3/26/2008 v8.0832 CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
//bool build_report_book_option(TreeNode& trBook, bool bAllowToSource, LPCSTR lpcszBook)
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
//bool OutputGUIManagerBase::buildReportBookOption(TreeNode& trBook, bool bAllowToSource, LPCSTR lpcszSourceBook)
bool OutputGUIManagerBase::buildReportBookOption(TreeNode& trGUI, TreeNode& trBook, bool bAllowToSource, LPCSTR lpcszSourceBook)
/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
///end CLEANUP_OUTPUT_BOOK_SHEET_AREA_TO_CLASS
{
	_DBCLASS("OutputGUIManagerBase::buildReportBookOption")
	if( !trBook )
		return false;	
	
	bool 	bSourceBook = false;
	string 	strOldVal = trBook.strVal;
	bool 	bWasEmpty = strOldVal.IsEmpty()? true : false;
	if( !bWasEmpty )
	{
		int 	nType;
		page_short_name_from_display_name(strOldVal, nType);
		bSourceBook = nType == PDS_SOURCE? true: false;
	}	
	
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//according to old logic
	if(lpcszSourceBook == NULL)
		return bSourceBook;
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	
	string 	strBookEntry = STR_SOURCE_BOOK;
	string 	strSourceBook(lpcszSourceBook);
	if(!strSourceBook.IsEmpty())
		///Sophy 4/10/2008 MAKE_SPECIAL_TYPE
		//strBookEntry += " " + strSourceBook;
		///Sophy 4/15/2008 MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		//strBookEntry = MakeSpecialType(STR_SOURCE_BOOK, strSourceBook);
		strBookEntry = _make_special_type_str( STR_SOURCE_BOOK, strSourceBook );
		///end MOVE_MAKE_SPECIAL_TYPE_TO_STATIC_GLOBAL_FUNCTION
		///end MAKE_SPECIAL_TYPE
	/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN	
	//string 	strCombo = STR_NONE + STR_TOKEN_SEP + STR_AUTO;
	//if(bAllowToSource)
	//{
		//strCombo += STR_TOKEN_SEP + strBookEntry;
	//}

	//strCombo += STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;	
	string	strCombo = GetReportBookCombo( trGUI);
	/// End FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
	if(bWasEmpty)
	{
	/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
		//trBook.strVal = STR_AUTO;
		trBook.strVal = GetOutputDestinationDefaultSetting(trBook.DataID);
	///end CENTRLIZE_SET_DEFAULT_VALUES_CODES
	}
	
	else if(bSourceBook)
	{
		///Cheney 2007-11-9 QA70-10536 FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//trBook.strVal = STR_AUTO;
		trBook.strVal = strBookEntry;
		///end FIX_SOME_NEW_BUGS_OF_OUTPUT_DESTNATION
		//bSourceBook = false; /// Iris 4/03/2008 v8.0836 CLEAN_DUPLICATE_AND_COMPLEX_CODES, old logic is strange, should keep bSourceBook is true here
	}
	
	trBook.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	/// Iris 4/03/2008 v8.0836 CLEAN_DUPLICATE_AND_COMPLEX_CODES, looks the logic is incorrect so updated.
	//trBook.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, trBook.strVal);
	trBook.SetAttribute(STR_ATTRIB_OLD_COMBO_VAL, strOldVal);
	///end CLEAN_DUPLICATE_AND_COMPLEX_CODES	
	
	return bSourceBook;
}
//---- end SR0_725_OUTPUT_LOCATION_NOT_REMEMBER_IN_LAST_USED

string OutputGUIManagerBase::getNameForNewType(TreeNode& trName)
{
	string		strName;
	TreeNode	trNameForNew = trName.NextNode;
	if( trNameForNew && trNameForNew.tagName == "NameForNew" && !trNameForNew.IsEmpty() )
	{
		strName = trNameForNew.strVal;
	}
	else
	{
		trName.GetAttribute(STR_DEFAULT_ATTRIB, strName);
	}	
	
	return strName;
}


/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
typedef	int (*pfn_get_report_output_destination)(const TreeNode& trGUI, const TreeNode& trBookSheetBranch);
/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
typedef TreeNode (*pfn_get_input_output_node)( const TreeNode& trGUI );
///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
string OutputGUIManagerBase::getBookNameByType(const TreeNode& trGUI, const TreeNode& trOutput, const TreeNode& trBookSheetBranch, int nBookType, LPCSTR lpcsz2ndPart, bool* pbBookNameEnable)
{	
	string  str2ndPart(lpcsz2ndPart);
	string	strBookName = "";
	bool	bBookNameEnable = false;
	switch(nBookType)
	{
	case PDS_SOURCE:
	case PDS_CUSTOM:
		strBookName = str2ndPart;
		break;
		
	case PDS_NEW:	
		/// Iris 4/22/2008 FIX_INCORRECT_REPORT_SHEET_NAME_IN_XYZFIT_AND_MATFIT
		//TreeNode 	trBookName = trBookSheetBranch.BookName;
		//if(trBookName)
		//	trBookName.GetAttribute(STR_DEFAULT_ATTRIB, strBookName);		
		strBookName = getNameForNewType(trBookSheetBranch.BookName);
		///end FIX_INCORRECT_REPORT_SHEET_NAME_IN_XYZFIT_AND_MATFIT
		bBookNameEnable = true;
		break;
		
	case PDS_AUTO:
		// No way to set STR_REPORT_DESTINATION_TYPE_ATTRIB attribute now, so keep this control empty for Auto
		//// convert book type from auto to real book type
		////nReportBookType = GetReportOutPutDestination(trGUI.InputData);
		//TreeNode 	trReportBook = trBookSheetBranch.Book;
		//if( trReportBook && trReportBook.GetAttribute(STR_REPORT_DESTINATION_TYPE_ATTRIB, nReportBookType) )
		//{
			//strReportBookName = get_report_book_name_by_type(trGUI, trOutput, nReportBookType, lpcszReport2ndPart, &bReportBookNameEnable);
		//}
		/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
		strBookName = "";
		///---Sim 08-20-2010 ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
		//pfn_get_report_output_destination pfn = Project.FindFunction("get_report_output_destination", "OriginLab\\wksoperation.c", TRUE);
		static pfn_get_report_output_destination pfn = Project.FindFunction("get_report_output_destination", "OriginLab\\wksoperation.c", TRUE);
		///---END ORG-877 LF_AND_PF_DLG_OPEN_SPEEP_IMPROVEMENT
		if ( pfn )
		{
			int nReportBookType = pfn(trGUI, trBookSheetBranch);
			if ( PDS_INVALID != nReportBookType && PDS_AUTO != nReportBookType ) // avoid deadly recursive
			{
				strBookName = getBookNameByType(trGUI, trOutput, trBookSheetBranch, nReportBookType, lpcsz2ndPart, pbBookNameEnable);
			}
		}
		/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE		
		break;
		
	case PDS_REPORT:
		strBookName = trOutput.Report.BookName.strVal;
		break;
		
	case PDS_FIT_CURVE:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//strBookName = trOutput.Data.BookName.strVal;
		strBookName = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI).BookName.strVal;
		///end OP_DLG_NEW_STRUCTURE
		break;
		
	case PDS_NONE:		
	default:
		break;
	}
	
	if( strBookName.IsEmpty() && nBookType == PDS_SOURCE)
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//strBookName = get_source_page_name(trGUI.Parent(), NULL, GetNodeByTagname(trGUI,"InputData"));
		strBookName = GetSourceBookName(trGUI);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	
	// Need to uncomment when above Auto case works.
	//if( strReportBookName.IsEmpty() && nReportBookType != PDS_NONE )
	//	error_report( "get_report_book_name_by_type() found empty strReportBookName for !PDS_NONE type");

	if(pbBookNameEnable)
		*pbBookNameEnable = bBookNameEnable;
	
	return strBookName;
}

string	OutputGUIManagerBase::getSheetNameByType(TreeNode& trGUI, TreeNode& trBookSheetBranch, int nSheetType, LPCSTR lpcsz2ndPart, bool* pbSheetNameEnable)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	string  str2ndPart(lpcsz2ndPart);
	string	strSheetName = "";
	bool	bSheetNameEnable = false;
	switch(nSheetType)
	{
	// <source>	 and <existing>... cases for stats on row
	case PDS_SOURCE:
	case PDS_CUSTOM:
			strSheetName = str2ndPart;
		break;
		
	case PDS_NEW:
		/// Iris 4/22/2008 FIX_INCORRECT_REPORT_SHEET_NAME_IN_XYZFIT_AND_MATFIT
		//TreeNode 	trSheetName = trBookSheetBranch.SheetName;
		//if(trSheetName)
		//{
			//trSheetName.GetAttribute(STR_DEFAULT_ATTRIB, strSheetName);		
			////printf("%s.%s	Get : STR_DEFAULT_ATTRIB	%s  OutputGUIManagerBase::getSheetNameByType\n", trBookSheetBranch.tagName, trSheetName.tagName, strSheetName);
		//}
		strSheetName = getNameForNewType(trBookSheetBranch.SheetName);  
		///end FIX_INCORRECT_REPORT_SHEET_NAME_IN_XYZFIT_AND_MATFIT
		bSheetNameEnable = true;
		break;
		
	case PDS_FIT_CURVE:
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//strSheetName = trOutput.Data.SheetName.strVal;
		strSheetName = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI).SheetName.strVal;
		///end OP_DLG_NEW_STRUCTURE
		break;	
		
	case PDS_NONE:
	default:
		break;
	}
	
	if( PDS_SOURCE == nSheetType && strSheetName.IsEmpty() )
	{ 
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//get_source_page_name(trGUI,&strSheetName);
		GetSourceBookName(trGUI, &strSheetName);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		if(strSheetName.IsEmpty())
			error_report("OutputGUIManagerBase::getSheetNameByType found empty 2nd report part for Source type");			
	}
	
	if(pbSheetNameEnable)
		*pbSheetNameEnable = bSheetNameEnable;
	
	return strSheetName;	
}

// set report book name control with real book name
bool 	OutputGUIManagerBase::SetOutputBookName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch)
{
	//TreeNode trOutputBook = trOutput.Report.Book;
	//TreeNode trOutputBookName = trOutput.Report.BookName;
	///Sophy 4/17/2008 MAKE_SURE_FINDXY_BRANCE_EXIST // should make sure trBookSheetBranch exist before get BookName
	//TreeNode trBookName = trBookSheetBranch.BookName;
	//ASSERT(trOutput);
	//ASSERT(trBookSheetBranch);
	//ASSERT(trBookName);
	ASSERT(trOutput);
	if( !trBookSheetBranch ) // MR fit don't have FindXY node(trBookSheetBranch will be NULL) and should return,or else trBookSheetBranch.BookName will cause runtime error
		return false;
	TreeNode trBookName = trBookSheetBranch.BookName;
	ASSERT(trBookName);
	///end MAKE_SURE_FINDXY_BRANCE_EXIST	
	_DBPRINTF("Output.%s.Book - OutputGUIManagerBase::SetOutputBookName\n", trBookSheetBranch.tagName);

	string	str2ndPart;
	int 	nReportType = str_to_predefined_type(trBookSheetBranch.Book.strVal, str2ndPart);
	
	bool	bBookNameEnable;
	trBookName.strVal = getBookNameByType(trGUI, trOutput, trBookSheetBranch, nReportType, str2ndPart, &bBookNameEnable);			
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	//trBookName.Enable = bBookNameEnable;
	SetEnableAttribute( trBookName, bBookNameEnable );
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///Sophy 4/21/2008 SAVE_OLD_COMBO_VALUE_IN_CASE_NEED_TO_RESTORE_IT
	TreeNode trBook = trBookSheetBranch.Book;
	trBook.SetAttribute( STR_ATTRIB_OLD_COMBO_VAL, trBook.strVal );
	///end SAVE_OLD_COMBO_VALUE_IN_CASE_NEED_TO_RESTORE_IT
	return true;
}

// set report sheet name control with real sheet name
bool 	OutputGUIManagerBase::SetOutputSheetName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch)
{
	//TreeNode trOutputSheet = trOutput.Report.Sheet;
	//TreeNode trOutputSheetName = trOutput.Report.SheetName;
	///Sophy 4/17/2008 MAKE_SURE_FINDXY_BRANCE_EXIST
	//TreeNode trSheetName = trBookSheetBranch.SheetName;
	//ASSERT(trOutput);
	//ASSERT(trBookSheetBranch);
	//ASSERT(trSheetName);
	ASSERT(trOutput);
	if( !trBookSheetBranch )
		return false;
	TreeNode trSheetName = trBookSheetBranch.SheetName;
	ASSERT(trSheetName);
	///end MAKE_SURE_FINDXY_BRANCE_EXIST
	_DBPRINTF("Output.%s.Sheet - OutputGUIManagerBase::SetOutputSheetName\n", trBookSheetBranch.tagName);

	string	str2ndPart;
	int 	nReportType = str_to_predefined_type(trBookSheetBranch.Sheet.strVal, str2ndPart);
	
	bool	bSheetNameEnable;
	trSheetName.strVal = getSheetNameByType(trGUI, trBookSheetBranch, nReportType, str2ndPart, &bSheetNameEnable);	
	
	///Sophy 6/11/2008 QA80-10934-P15 FIX_FINDXY_SHEETNAME2_DISPLAY_ERROR
	if( trBookSheetBranch.SheetName2 ) // NLFit FindXY
	{
		if( PDS_NEW == nReportType )
			trBookSheetBranch.SheetName2.strVal = getNameForNewType( trBookSheetBranch.SheetName2 );
		else
			trBookSheetBranch.SheetName2.strVal = getSheetNameByType(trGUI, trBookSheetBranch, nReportType, str2ndPart, &bSheetNameEnable);
		
		SetEnableAttribute( trBookSheetBranch.SheetName2, bSheetNameEnable );
	}
	///end FIX_FINDXY_SHEETNAME2_DISPLAY_ERROR
	///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	//trSheetName.Enable = bSheetNameEnable;	
	SetEnableAttribute( trSheetName, bSheetNameEnable );
	///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	TreeNode trSheet = trBookSheetBranch.Sheet;
	trSheet.SetAttribute( STR_ATTRIB_OLD_COMBO_VAL, trSheet.strVal );
	///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
	return true;
}

bool	OutputGUIManagerBase::setReportBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate)
{	
	bool	bRet = SetOneBookSheetName(trGUI, trOutput, trOutput.Report, nToUpdate);
	
	/// Iris 4/16/2008 SHOULD_DISABLE_OTHERS_IF_REPORT_BOOK_IS_NODE
	if( PDS_NONE == str_to_predefined_type(trOutput.Report.Book.strVal) && trOutput.Report.SheetName.Enable )
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trOutput.Report.SheetName.Enable = false;
		SetEnableAttribute( trOutput.Report.SheetName, false );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///end SHOULD_DISABLE_OTHERS_IF_REPORT_BOOK_IS_NODE
	
	return bRet;
}

bool		OutputGUIManagerBase::setCurveBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate)
{
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.Data, nToUpdate);
	return SetOneBookSheetName(trGUI, trOutput, OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI), nToUpdate);
	///end OP_DLG_NEW_STRUCTURE
}

bool	OutputGUIManagerBase::SetOneBookSheetName(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trBookSheetBranch, int nToUpdate)
{
	if( UPDATE_BOOK == nToUpdate || UPDATE_BOTH == nToUpdate )
		SetOutputBookName(trGUI, trOutput, trBookSheetBranch);	
		
	if( UPDATE_SHEET == nToUpdate  || UPDATE_BOTH == nToUpdate )
		SetOutputSheetName(trGUI, trOutput, trBookSheetBranch);
	
	return true;
}

bool		OutputGUIManagerBase::SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput)
{
	if( trOutput.Report) /// Iris 4/14/2008 FIX_XYZGRIDDING_NO_REPORT_NODE_CAUSE_RUNTIME_ERR
		setReportBookSheetName(trGUI, trOutput);
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//if( trOutput.Data ) //if no Output.Data node like DestStats, no need to set book & sheet name
	TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	if ( trData )
	///end OP_DLG_NEW_STRUCTURE
		setCurveBookSheetName(trGUI, trOutput);
	
	return true;
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME


////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               ANOVAOutputGUIManager	     		      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
/// Iris 5/27/2008 v8.0871 NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA
bool		ANOVAOutputGUIManager::IsAllowReportToSourceBook(TreeNode& trGUI)
{
	string	strBook = GetSourceBookName(trGUI);
	return !strBook.IsEmpty();
}

//virtual
string 		ANOVAOutputGUIManager::GetSourceBookName(TreeNode& trGUI, string* pstrSourceSheet)
{
	string		strBook;
	TreeNode 	trInput = GetInputDataNode(trGUI);
	///Sophy 6/10/2008 FIX_REPORT_BOOK_NAME_EMPTY_NO_DATA_SELECTED_OPEN_DIALOG
	/*
	TreeNode 	trOne = trInput.Data.FirstNode ? trInput.Data.FirstNode : trInput.Data;
	
	// this area will rewrite to ANOVA 1 way output class and ANOVA 2 way output class to get .Data node
	if( 0 != trOne.GetNodeCount() ) // 2 way		
	{
		trOne = trOne.FirstNode;
	}
	
	
	if( trInput.Data && trOne && !trOne.IsEmpty() ) 
	{
		strBook = trOne.strVal;
		
		int nBegin = strBook.Find('[');
		if( nBegin < 0 )
			return "";
		nBegin++;
		
		int nEnd = strBook.Find(']');
		if( nEnd < 0 )
			return "";
		nEnd--;
		
		strBook = strBook.Mid(nBegin, nEnd - nBegin + 1);
	}
	*/
	int	nUseMode = 0;
	DataRange drInput;
	
	if( trInput.GetAttribute( STR_USE_ATTRIB, nUseMode ) && 1 == nUseMode ) // raw
		drInput.Create( trInput.Data, true );
	else																	// index
		drInput.Create( trInput, true );
	
	if( trInput.Data.Factor0_0 )											// two way, raw temporary solution
		drInput.Create( trInput.Data.Factor0_0, true );
	
	is_range_from_normal_book( drInput, &strBook, pstrSourceSheet );
	///end FIX_REPORT_BOOK_NAME_EMPTY_NO_DATA_SELECTED_OPEN_DIALOG
	return strBook;
}
///end NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               DescStatsOutputGUIManager   		      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
string 		DescStatsOutputGUIManager::GetOutputDestinationDefaultSetting(int nBookSheetType)
{
	string	strDefault = OutputGUIManagerBase::GetOutputDestinationDefaultSetting(nBookSheetType);
	switch(nBookSheetType)
	{
	case IDE_REOPRT_BOOK:
		strDefault = STR_SOURCE_BOOK;
		break;
	case IDE_REPORT_SHEET:
		strDefault = STR_INSERT_SOURCE_SHEET;
		break;
	default:
		break;
	}
	return strDefault;
}
///end CENTRLIZE_SET_DEFAULT_VALUES_CODES

bool	DescStatsOutputGUIManager::isStatsOnRows(TreeNode& trGUI)
{
	return (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true:false;
}
/// Sophy 5/08/2008 FIX_BUG_REPORT_BOOK_BLANK_WHEN_NO_DATUM_SELECTED_IN_STATS_ON_COLUMN
//virtual 
string	DescStatsOutputGUIManager::GetReportBookCombo(TreeNode& trGUI)
{
	string	strSourceBook = GetSourceBookName(trGUI);
	string 	strBookCombo = IsAllowReportToSourceBook(trGUI)? STR_STATS_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(strSourceBook) : STR_STATS_OUTPUT_REPORT_BOOK_COMBO;	
	return strBookCombo;
}
bool 	DescStatsOutputGUIManager::IsAllowReportToSourceSheet(TreeNode& trGUI)
{
	return isStatsOnRows(trGUI);
}

//virtual	
bool	DescStatsOutputGUIManager::OnReportSheetChanged(TreeNode& tr)
{
	_DBCLASS("DescStatsOutputGUIManager::OnReportSheetChanged");
	
	bool	bRet = OutputGUIManagerBase::OnReportSheetChanged(tr);
	
	TreeNode trGUI = GetGUITree(tr);
	showReportColumnOption(trGUI);
	
	return bRet;
}

//virtual 
bool 	DescStatsOutputGUIManager::OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook)
{
	_DBCLASS("DescStatsOutputGUIManager::OutputReportBookEvent");
	
	bool	bRet = OutputGUIManagerBase::OutputReportBookEvent(trGUI, lpcszBook);
	
	showReportColumnOption(trGUI);
	return bRet;
}

///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void show_report_column_option(TreeNode& trGUI)
//void show_report_column_option(TreeNode& trGUI, bool bIsNLFitOutputEvent)
/// Iris 4/07/2008 ADD_DescStats_OUTPUT_CLASS
//void OutputGUIManagerBase::showReportColumnOption(TreeNode& trGUI)
void DescStatsOutputGUIManager::showReportColumnOption(TreeNode& trGUI)
///end ADD_DescStats_OUTPUT_CLASS
///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
{
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode 	trReport = trGUI.Output.Report;
	//TreeNode	trCol = trReport.Column;
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	TreeNode trReport = trOutput.Report;
	TreeNode trCol  = trReport.Column;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	//------ CPY 11/12/2007 DESC_STATS_ON_ROWS_AUTO_SHOULD_SET_PROPER_SHEET
	//bool 		bStatsOnRows = (trGUI.StatsOnRows && trGUI.StatsOnRows.nVal)? true : false;
	bool 		bStatsOnRows = isStatsOnRows(trGUI);
	//------	
	
	if(bStatsOnRows && trCol)
	{		
		int		nReportBookType = str_to_predefined_type(trReport.Book.strVal);
		int		nReportSheetType = str_to_predefined_type(trReport.Sheet.strVal);
		bool	bShowColumnOption = false;
		if(PDS_SOURCE == nReportBookType && PDS_SOURCE == nReportSheetType ||
			PDS_CUSTOM == nReportBookType && PDS_CUSTOM == nReportSheetType )
			bShowColumnOption = true;
			
		trCol.Show = bShowColumnOption;
	}
}



////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               FitOutputGUIManager   				      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//virtual
bool 	FitOutputGUIManager::OnReportBookChanged(TreeNode& tr)
{
	if(OutputGUIManagerBase::OnReportBookChanged(tr))
	{
		///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
		//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
		TreeNode trOutput = GetOutputNode( tr );
		///end GET_SUB_TREENODE_BY_ID_RECURSIVE
		///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
		//setResidualBookSheetName(tr, trOutput);
		//setFindXYBookSheetName(tr, trOutput);			
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		/*
		if( trOutput.Data && PDS_REPORT == str_to_predefined_type(trOutput.Data.Book.strVal) )
		{
			if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
				setResidualBookSheetName(tr, trOutput);
			if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) )
				setFindXYBookSheetName(tr, trOutput);			
		}
		*/
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
			UpdateBranchOnBookChange(tr, trOutput.Residual, false); //here we needn't to update book combo
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) ) //MR Fit doesn't have FindXY treenode
			UpdateBranchOnBookChange(tr, trOutput.FindXY, false);
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		if( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
			UpdateBranchOnBookChange(tr, trResidual, false); //here we needn't to update book combo
		
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) ) //MR Fit doesn't have FindXY treenode
			UpdateBranchOnBookChange(tr, trFindXY, false);
		///end OP_DLG_NEW_STRUCTURE
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		return true;
		///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
	}
	return false;
}
///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
//virtual
bool	FitOutputGUIManager::OnReportBookNameChanged( TreeNode& tr )
{
	if( OutputGUIManagerBase::OnReportBookNameChanged( tr ) )
	{
		TreeNode	trOutput = GetOutputNode( tr );
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Data && PDS_REPORT == str_to_predefined_type(trOutput.Data.Book.strVal) )
		{
			if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
				setResidualBookSheetName(tr, trOutput);
			if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) )
				setFindXYBookSheetName(tr, trOutput);			
		}
		*/
		TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(tr);
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if ( trData && PDS_REPORT == str_to_predefined_type(trData.Book.strVal) )
		{
			if ( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
				setResidualBookSheetName(tr, trOutput);
			if ( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) )
				setFindXYBookSheetName(tr, trOutput);
		}
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}
	
	return false;
}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

//virtual
bool 	FitOutputGUIManager::OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow)
{
	if(OutputGUIManagerBase::OnCurveBookChanged(tr, trBook, nRow))
	{
		///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
		//TreeNode trOutput = GetNodeByTagname(tr, "Output");
		TreeNode trOutput = GetOutputNode( tr );
		///end GET_SUB_TREENODE_BY_ID_RECURSIVE
		
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
		{
			setResidualBookSheetName(tr, trOutput);
		}
		
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) )
		{
			setFindXYBookSheetName(tr, trOutput);
		}
		*/
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
			UpdateBranchOnBookChange( tr, trOutput.Residual, false ); //no need to check book combo here
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) )
			UpdateBranchOnBookChange( tr, trOutput.FindXY, false );
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if ( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
			UpdateBranchOnBookChange(tr, trResidual, false);
		if ( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) )
			UpdateBranchOnBookChange(tr, trFindXY, false);
		///end OP_DLG_NEW_STRUCTURE
		return true;
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	}
	return false;
}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool 	FitOutputGUIManager::OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow )
{
	if( OutputGUIManagerBase::OnCurveBookNameChanged( tr, trBookName, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Book.strVal) )
		{
			setResidualBookSheetName(tr, trOutput);
		}
		
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Book.strVal) )
		{
			setFindXYBookSheetName(tr, trOutput);
		}
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if ( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
			setResidualBookSheetName(tr, trOutput);
		if ( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) )
			setFindXYBookSheetName(tr, trOutput);
		///end OP_DLG_NEW_STRUCTURE
	}
	
	return true;
}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

bool 	FitOutputGUIManager::OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow)
{
	if(OutputGUIManagerBase::OnCurveSheetChanged(tr, trSheet, nRow))
	{
		///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
		//TreeNode trOutput = GetNodeByTagname(tr, "Output");
		TreeNode trOutput = GetOutputNode( tr );
		///end GET_SUB_TREENODE_BY_ID_RECURSIVE
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Sheet.strVal) )
		{
			setResidualBookSheetName(tr, trOutput, UPDATE_SHEET);
		}
		///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Sheet.strVal) )
		{
			setFindXYBookSheetName(tr, trOutput, UPDATE_SHEET);
		}	
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if ( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
			setResidualBookSheetName(tr, trOutput, UPDATE_SHEET);
		if ( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) )
			setFindXYBookSheetName(tr, trOutput, UPDATE_SHEET);
		///end OP_DLG_NEW_STRUCTURE
		///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
		return true;
	}	
	return false;
}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool	FitOutputGUIManager::OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow )
{
	if( OutputGUIManagerBase::OnCurveSheetNameChanged( tr, trSheetName, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual && PDS_FIT_CURVE == str_to_predefined_type(trOutput.Residual.Sheet.strVal) )
		{
			setResidualBookSheetName(tr, trOutput, UPDATE_SHEET);
		}
		
		if( trOutput.FindXY && PDS_FIT_CURVE == str_to_predefined_type(trOutput.FindXY.Sheet.strVal) )
		{
			setFindXYBookSheetName(tr, trOutput, UPDATE_SHEET);
		}
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(tr);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(tr);
		if ( trResidual && PDS_FIT_CURVE == str_to_predefined_type(trResidual.Book.strVal) )
			setResidualBookSheetName(tr, trOutput, UPDATE_SHEET);
		if ( trFindXY && PDS_FIT_CURVE == str_to_predefined_type(trFindXY.Book.strVal) )
			setFindXYBookSheetName(tr, trOutput, UPDATE_SHEET);
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}
	return false;
}
///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

bool	FitOutputGUIManager::OnResidualBookChanged(TreeNode& tr)
{
	_DBCLASS("FitOutputGUIManager::OnResidualBookChanged")
	
	TreeNode trGUI = GetGUITree(tr);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trCurrent = trOutput.Residual;
	TreeNode trCurrent = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trCurrent);
	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	//string 	strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	string 	strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	string	strSheetVal = ( trCurrent.Sheet.IsEmpty()) ? "" : trCurrent.Sheet.strVal; ///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	string 	strBook = trCurrent.Book.strVal, str2ndPart;
	int 	nBookType = str_to_predefined_type(strBook, str2ndPart);
	
	bool	bSheetEnable = trCurrent.Sheet.Enable;
	switch(nBookType)
	{
	case PDS_FIT_CURVE:
		strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
		strSheetVal = STR_FIT_CURVE; ///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		bSheetEnable = true;
		break;
		
	case PDS_NEW:
		///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		//trCurrent.Sheet.strVal = STR_NEW;
		strSheetVal = STR_NEW;
		///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		bSheetEnable = false;
		break;
		
	case PDS_CUSTOM:
		//bool bIsCustom = (PDS_CUSTOM == str_to_predefined_type(strBook, str2ndPart))? true:false; ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//CheckAskCustomBookSheetName(trGUI, trCurrent.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);
		bool bNeedChangeCombo = CheckAskCustomBookSheetName(trGUI, trCurrent, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
		//Page pg( trCurrent.Book.strVal.GetToken(1,'>') );
		string 	strPage;
		str_to_predefined_type(trCurrent.Book.strVal, strPage);
		Page	pg(strPage);
		///end CLEANUP_FIT_TYPE_CODES
		if(!pg)
		{//select default value
			if( IsPlotFitCurve( trGUI.FittedCurve ) )
			{
				trCurrent.Book.strVal = STR_FIT_CURVE;
				strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
				///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
				//trCurrent.Sheet.strVal = STR_FIT_CURVE;
				strSheetVal = STR_FIT_CURVE;
				///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
			}
			else
			{
				trCurrent.Book.strVal = STR_NEW;
				strCombo = STR_NEW;
				///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
				//trCurrent.Sheet.strVal = STR_NEW;
				strSheetVal = STR_NEW;
				///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
			}
		}
		else
		{
			///Sophy 6/2/2008 QA80-10934-P13 FIX_REMOVE_FITTED_VALUE_FROM_SHEET_COMBO_WHEN_CUSTOMIZED_BOOKNAME
			//if( bChanged )	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE if Book doesn't change, no need to update sheet name
			//	trCurrent.Sheet.strVal = STR_NEW;
			if( bNeedChangeCombo )
			{
				trCurrent.Sheet.strVal = STR_NEW;
				strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			}
			///end FIX_REMOVE_FITTED_VALUE_FROM_SHEET_COMBO_WHEN_CUSTOMIZED_BOOKNAME
			///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
			bSheetEnable = true;
			string strtemp = get_sheets_in_book(pg, WKS_DATA_SHEET);			
			if(!lstrlen( strtemp) )
				bSheetEnable = false;
		}
		break;
		
	case PDS_REPORT:
		strCombo = STR_NEW + STR_TOKEN_SEP;
		///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		//trCurrent.Sheet.strVal = STR_NEW;
		strSheetVal = STR_NEW;
		///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		break;
	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	case PDS_SOURCE:
		strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		//trCurrent.Sheet.strVal = STR_NEW;///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
		///Sophy 7/17/2009 v8.0998-55 MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		if ( strSheetVal.IsEmpty() )
			strSheetVal = STR_NEW;
		///end MORE_FIX_WRONG_SHEET_LEVEL_WHEN_DO_STATS_ON_ROW
		bSheetEnable = true;
	///end FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	default:
		break;
	}
	
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	int 		nOutputType = 0;
	TreeNode 	trFittedCurve = trOutput.Data;
	if( trFittedCurve && trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType > OPERATION_OUTPUT_XYZ_FITTING )	
	{
		remove_str_from_str_list(STR_FIT_CURVE, strCombo);
		remove_str_from_str_list(STR_CUSTOM + STR_THREE_DOTS, strCombo);
	}
	*/
	if( GetOutputType() != EXIST_WKS )
	{
		remove_str_from_str_list(STR_FIT_CURVE, strCombo);
		remove_str_from_str_list(STR_CUSTOM + STR_THREE_DOTS, strCombo);
	}
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	///Sophy 6/22/2009 QA80-10731-P2 WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	//trCurrent.Sheet.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	bool bCheckSourceCustom = false; //when change parameter, need to check book/sheet in case user delete them before change param
	if ( IsChangeParam() )
	{
		bCheckSourceCustom = true;
		if ( !trCurrent.Sheet.IsEmpty() )
			strSheetVal = trCurrent.Sheet.strVal; //keep old value
	}
	
	//here can not access private member of base class, so can not use "updateOutputBookSheetDestination".
	UpdateOutputBookSheetDestination(trGUI, trCurrent, NULL, NULL, strCombo, strSheetVal, bCheckSourceCustom); 
	///end WRONG_SHEET_LEVEL_FOR_STATS_AND_ANALYSIS_WHEN_CHANGE_PARAMETER
	if(trCurrent.Book.Enable) //Iris 02/05/2007 click Change Parameter to open dialog, Book and Sheet both should disabled.
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trCurrent.Sheet.Enable = bSheetEnable;
		SetEnableAttribute( trCurrent.Sheet, bSheetEnable );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		
	///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	//validating code temporary moved into setResidualBookSheetName;
	/*
	setResidualBookSheetName(trGUI, trOutput); /// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	CheckUpdateSourceCustomEntry( trGUI, trCurrent.Book, true); ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	CheckUpdateSourceCustomEntry( trGUI, trCurrent.Sheet, false);	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	*/
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	//setResidualBookSheetName(trGUI, trOutput); /// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	UpdateBranchOnBookChange(trGUI, trCurrent);
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	return true;	
}

bool 	FitOutputGUIManager::OnFindXYBranchChanged(TreeNode& tr, int nRow)
{
	_DBCLASS("FitOutputGUIManager::OnFindXYBranchChanged")
	TreeNode trGUI = GetGUITree(tr);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART
	///Sophy 9/17/2008 IMPROVE_GET_CALIBRATION_CODE
	//TreeNode trCalibration =  tree_get_node_by_tagname(tr, "Calibration", true);
	//if(!trCalibration)
	//{
		//TreeNode trRoot = tr.Parent();
		//if(trRoot)
			//trCalibration =  tree_get_node_by_tagname(trRoot, "Calibration", true);
	//}	
	TreeNode trCalibration =  trGUI.Calibration;
	if( !trCalibration )
	{
		if( trGUI.OpGUI )
			trCalibration = trGUI.OpGUI.Calibration;
	}	
	///end IMPROVE_GET_CALIBRATION_CODE
	ASSERT(trCalibration);
	/// Iris 9/16/2008 PA_FIT_USE_NEW_PEAK_FIT_OP, get runtime error when trFindXYOutput is invlid
	if(!trCalibration)
		return false;
	///end PA_FIT_USE_NEW_PEAK_FIT_OP
	
	TreeNode trFindXYOutput = tree_get_node(tr, nRow);
	ASSERT(trFindXYOutput);
	/// Iris 9/16/2008 PA_FIT_USE_NEW_PEAK_FIT_OP, get runtime error when trFindXYOutput is invlid
	if(!trFindXYOutput)
		return false;
	///end PA_FIT_USE_NEW_PEAK_FIT_OP
	
	TreeNode trBranch1 = trCalibration.Custom2;
	TreeNode trBranch2 = trCalibration.Custom3;

	//When current operation is "Find Z from X Y", trBranch1 and trBranch2 are NULL,
	//trCalibration has not sub-branch trBranch1 and trBranch2.  
	if(!trBranch1 && !trBranch2)
	{
		if(trCalibration.Use && trFindXYOutput)
		{
			///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
			//trFindXYOutput.Enable = true;
			SetEnableAttribute( trFindXYOutput, true );
			///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
			trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		}
		else
		{
			trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
			///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
			//trFindXYOutput.Enable = false;
			SetEnableAttribute( trFindXYOutput, false );
			///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		}
		return true;
	}

	if(trBranch1.Use + trBranch2.Use && trFindXYOutput)
	{
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trFindXYOutput.Enable = true;
		SetEnableAttribute( trFindXYOutput, true );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
	}
	if(!(trBranch1.Use + trBranch2.Use) && trFindXYOutput)
	{
		trFindXYOutput.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_KEEP_SIZE_ON_COLLAPSE);
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trFindXYOutput.Enable = false;
		//SetEnableAttribute( trFindXYOutput, false );
		///Sophy 5/29/2008 QA80-11605-P4 FIX_FINDXY_BRANCH_BECOME_ENABLED_ON_CHANGE_PARAMETER
		trFindXYOutput.Enable = false;
		///end FIX_FINDXY_BRANCH_BECOME_ENABLED_ON_CHANGE_PARAMETER
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	}
#endif //OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART
	
	setFindXYBookSheetName(trGUI, trOutput);
	return true;	
}


bool 	FitOutputGUIManager::OnFindXYBookChanged(TreeNode& tr)
{
	_DBCLASS("FitOutputGUIManager::OnFindXYBookChanged")
	TreeNode trGUI = GetGUITree(tr);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trFindXY = trOutput.FindXY;
	TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trFindXY);
	
	bool	bEnable = trFindXY.Sheet.Enable;//centralize code
	string 	strBook = trFindXY.Book.strVal, str2ndPart;
	int 	nBookType = str_to_predefined_type(strBook, str2ndPart);	
	switch(nBookType)
	{
	case PDS_CUSTOM:
		///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		//CheckAskCustomBookSheetName(trGUI, trFindXY.Book, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		CheckAskCustomBookSheetName(trGUI, trFindXY, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		/// Iris 4-05-2008 CLEANUP_FIT_TYPE_CODES
		//Page pg( trFindXY.Book.strVal.GetToken(1,'>') );
		string 	strPage;
		str_to_predefined_type(trFindXY.Book.strVal, strPage);
		Page	pg(strPage);
		///end CLEANUP_FIT_TYPE_CODES
		if(!pg)
		{
			if( IsPlotFitCurve( trGUI.FittedCurve ) )
				trFindXY.Book.strVal = STR_FIT_CURVE;//select default value
			else
				trFindXY.Book.strVal = STR_NEW;
		}
		///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		else
			bEnable = true;//SetEnableAttribute( trFindXY.Sheet, true );
		///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		break;
		
	case PDS_SOURCE:
	case PDS_FIT_CURVE:
	case PDS_REPORT:
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trFindXY.Sheet.Enable = true;
		bEnable = true; //SetEnableAttribute( trFindXY.Sheet, true );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		break;
		
	case PDS_NEW:
		trFindXY.Sheet.strVal = STR_NEW;
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trFindXY.Sheet.Enable = false;
		bEnable = false; //SetEnableAttribute( trFindXY.Sheet, false );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		break;
		
	default:
		break;
	}
	
	SetEnableAttribute( trFindXY.Sheet, bEnable );//centralize code
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	//setFindXYBookSheetName(trGUI, trOutput); /// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
	UpdateBranchOnBookChange(trGUI, trFindXY );
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	return true;
}


bool	FitOutputGUIManager::OnResidualSheetChanged(TreeNode& tr)
{
	_DBCLASS("FitOutputGUIManager::OnResidualSheetChanged")
	TreeNode trGUI = GetGUITree(tr);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trResidual = trOutput.Residual;
	TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trResidual);
	
	bool bRet = OnSheetChanged(trGUI, trResidual, WKS_DATA_SHEET);	
	if(bRet)
	{
		///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		//since now in setResidualBookSheetName we also update book/sheet combo,but what we need here is just to update sheetname, so this logic should be changed correspondingly
		//setResidualBookSheetName(trGUI, trOutput, UPDATE_SHEET); /// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
		SetOutputSheetName( trGUI, trOutput, trResidual );
		///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	}
	return bRet;	
}


bool	FitOutputGUIManager::OnFindXYSheetChanged(TreeNode& tr)
{
	_DBCLASS("FitOutputGUIManager::OnFindXYSheetChanged")
	TreeNode trGUI = GetGUITree(tr);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trFindXY = trOutput.FindXY;
	TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	///Sophy 4/17/2008 MAKE_SURE_FINDXY_BRANCE_EXIST
	//ASSERT(trFindXY);
	if( !trFindXY )
		return false;
	///end MAKE_SURE_FINDXY_BRANCE_EXIST
	bool bRet = OnSheetChanged(trGUI, trFindXY, WKS_DATA_SHEET);	
	if(bRet)
	{
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		/*
		///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		//since now in setResidualBookSheetName we also update book/sheet combo,but what we need here is just to update sheetname, so this logic should be changed correspondingly
		//setFindXYBookSheetName(trGUI, trOutput);/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
		SetOutputSheetName( trGUI, trOutput, trFindXY );
		///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
		*/
		setFindXYBookSheetName( trGUI, trOutput, UPDATE_SHEET );
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	}
	return bRet;	
}
///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
//virtual
void		FitOutputGUIManager::DisableOutputDestination( TreeNode& trOutput )
{
	OutputGUIManagerBase::DisableOutputDestination(trOutput);
		
	/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.Residual )
		DisableOutputBookSheetBranch( trOutput.Residual );
	
	if( trOutput.FindXY )
		DisableOutputBookSheetBranch( trOutput.FindXY );
	*/
	TreeNode trGUI = trOutput.Parent();
	ASSERT(trGUI.tagName == "GUI");
	TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	if( trResidual )
		DisableOutputBookSheetBranch( trResidual);
	
	TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	if( trFindXY )
		DisableOutputBookSheetBranch(trFindXY);
	///end OP_DLG_NEW_STRUCTURE
}
///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS

/// Iris 3/28/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES
bool		FitOutputGUIManager::setResidualBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate)
{
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	/*
	///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	//before set book/sheet name, we should check whether have to update combolist, this is a temporary solution, need to clean after SR2
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.Residual, nToUpdate);
	CheckUpdateSourceCustomEntry( trGUI, trOutput.Residual.Book, true); ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	SetOutputBookName( trGUI, trOutput, trOutput.Residual );
	CheckUpdateSourceCustomEntry( trGUI, trOutput.Residual.Sheet, false);	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	SetOutputSheetName( trGUI, trOutput, trOutput.Residual );
	return true;
	///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	*/
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.Residual, nToUpdate);
	return SetOneBookSheetName(trGUI, trOutput, OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI), nToUpdate);
	///end OP_DLG_NEW_STRUCTURE
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
}

bool		FitOutputGUIManager::setFindXYBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate)
{	
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	/*
	///Sophy 6/23/2008 NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	//before set book/sheet name, we should check whether have to update combolist, this is a temporary solution, need to clean after SR2
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.FindXY, nToUpdate);
	CheckUpdateSourceCustomEntry( trGUI, trOutput.FindXY.Book, true); ///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	SetOutputBookName( trGUI, trOutput, trOutput.FindXY );
	CheckUpdateSourceCustomEntry( trGUI, trOutput.FindXY.Sheet, false);	///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
	SetOutputSheetName( trGUI, trOutput, trOutput.FindXY );
	return true;
	///end NOT_ALLOW_TO_CUSTOMIZE_SHEETNAME_WHEN_BOOKNAME_NOT_EXISTS
	*/
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.FindXY, nToUpdate);
	return SetOneBookSheetName(trGUI, trOutput, OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI), nToUpdate);
	///end OP_DLG_NEW_STRUCTURE
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE	
}

//virtual 
bool		FitOutputGUIManager::SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput)
{
	if(OutputGUIManagerBase::SetAllOutputBookSheetNames(trGUI, trOutput))
	{
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Residual ) 
			setResidualBookSheetName(trGUI, trOutput);
		
		if( trOutput.FindXY ) 
			setFindXYBookSheetName(trGUI, trOutput);
		*/
		TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
		TreeNode trFindXY = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
		if ( trResidual )
			setResidualBookSheetName(trGUI, trOutput);
		if ( trFindXY )
			setFindXYBookSheetName(trGUI, trOutput);
		///end OP_DLG_NEW_STRUCTURE
	}
	return true;		
}
///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME_AFTER_CLEAN_OUTPUT_GUI_CODES

/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
/*
void 	FitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName, TreeNode& trOutput)
{
	//TreeNode trData = trGUI.Output.Data;
	//TreeNode trRes = trGUI.Output.Residual;
	//int nFitType = GetFitType(trOperation);
	///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
	//TreeNode trFittedOut;
	//if(bSetDataOutput)
		//trFittedOut	= trGUI.Output.Data; 
		//
	//TreeNode trResidualOut = trGUI.Output.Residual;
	//TreeNode trFindXYOut = trGUI.Output.FindXY;
	//TreeNode trReportOut = trGUI.Output.Report;
	TreeNode trOuputResults;
	if(trOutput)
		trOuputResults = trOutput;
	else
		trOuputResults = trGUI.Output;
	
	TreeNode trFittedOut;
	if(bSetDataOutput)
		trFittedOut	= trOuputResults.Data; 
		
	TreeNode trResidualOut = trOuputResults.Residual;
	TreeNode trFindXYOut = trOuputResults.FindXY;
	TreeNode trReportOut = trOuputResults.Report;
	///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
	
	bool bAllowSource = is_range_from_normal_book(trInput); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING

	///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
	int nOutputType = 0;
	if(trOuputResults.Data)
		trOuputResults.Data.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType);
	
	///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	bool bPlotFitCurve = isPlotFitCurve(trGUI);
	string strResidualBookCombo, strResidualSheetCombo, strFindXYBookCombo, strFindXYSheetCombo;
	getResidualCombo(nFitType, bPlotFitCurve, strResidualBookCombo, strResidualSheetCombo);
	getFindXYCombo(nFitType, bPlotFitCurve, strFindXYBookCombo, strFindXYSheetCombo);
	///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	
	if(nFitType == NLFIT_XYZ_FITTING)
	{		
		if(trResidualOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			//update_output_book_sheet_destination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_XYZ_FITTING);
			UpdateOutputBookSheetDestination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_FIT_CURVE, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(trFindXYOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			//update_output_book_sheet_destination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_XYZ_FITTING);
			UpdateOutputBookSheetDestination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		if(trFittedOut)
		{
			//-------- CPY 10/15/07 XYZ_FITTING_CREATED_WKS_INSTEAD_OF_MAT_BOOK
			//I didnt understand this because of original strange 1,2 when converting code, will need to clean these 1 and 2 into macros
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trFittedOut.SetAttribute(STR_REPORT_MATRIX_DATA, 1); 
			trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_XYZ_FITTING); 
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//--------
			
			///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_NEW, NULL, STR_NEW);
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, NULL, STR_NEW);
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
			//update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			
			/// Iris 3/15/2008 QA70-11244 SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING, the settings of XYZ same as normal XY, so no need to set again here
			//update_output_book_sheet_destination(trFittedOut, STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_XYZ_FITTING);
			///end SHOULD_NOT_OUTPUT_DATA_TO_MATRIX_FOR_XYZ_FITTING
			
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			///end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
		}
		
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		if(trReportOut) 
		{
			if( bAllowSource)
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
				//update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
				UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_XYZ_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			else
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 
				//update_output_book_sheet_destination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
				UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_XYZ_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		}		
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	}
	else if(nFitType == NLFIT_MATRIX_FITTING)
	{
		//if(trData)
		//	trData.SetAttribute(STR_REPORT_MATRIX_DATA, 2);
		//if(trRes)
		//	trRes.SetAttribute(STR_REPORT_MATRIX_DATA, 1);
		if(trResidualOut)
		{
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trResidualOut.SetAttribute(STR_REPORT_MATRIX_DATA, 1); 
			trResidualOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_MAT_FITTING); 
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
			//update_output_book_sheet_destination(trResidualOut, STR_MATFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_MATFITTING_RESIDUALOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_MATRIX_FITTING);
			UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, bPlotFitCurve? STR_FIT_CURVE : STR_NEW, strResidualSheetCombo, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		}
		if(trFindXYOut)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
			UpdateOutputBookSheetDestination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		//if(trReportOut)
			//_update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, STR_NEW, STR_MATFITTING_REPORTOUT_SHEET_COMBO, STR_NEW);
		if(trReportOut) 
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL);
			UpdateOutputBookSheetDestination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_MATRIX_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			
		if(trFittedOut)
		{
			//-------- CPY 10/15/07 XYZ_FITTING_CREATED_WKS_INSTEAD_OF_MAT_BOOK
			///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
			//trFittedOut.SetAttribute(STR_REPORT_MATRIX_DATA, 2); 
			trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, OPERATION_OUTPUT_MAT_FITTING); 
			////--------
			//string strBookCombo;
			//trFittedOut.Book.GetAttribute(STR_COMBO_ATTRIB, strBookCombo);
			//StringArray saTokens;
			//strBookCombo.GetTokens( saTokens, '|');
			//if(saTokens.GetSize() == 0)
			//	return;
			//_update_output_book_sheet_destination(trFittedOut, NULL, saTokens[0], NULL, STR_NEW);
			if(bAllowSource)
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
				//update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_MATRIX_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			else
				///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
				//_update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
				//update_output_book_sheet_destination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
				UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, nOutputType, IDE_RESULT_CURVE_BOOK, NLFIT_MATRIX_FITTING);
				///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
				///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		}
		
	}
	///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
	//// for any type of fit
	//if(trReportOut && !is_range_from_normal_book(trGUI.InputData)) // reset to basic new report type of combo
	else if(trReportOut) 
		/////Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
		////_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, STR_NEW, NULL, NULL);
		//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL);
		/////end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
	
	{
		if(bAllowSource)
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL);
			UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_GENERAL_XY_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		else
			///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			//_update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL);
			///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
			//update_output_book_sheet_destination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL);
			UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL, nOutputType, IDE_REOPRT_BOOK, NLFIT_GENERAL_XY_FITTING);
			///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
			///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
			
		///Cheney 2007-10-19 QA70-10536 FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
		///Cheney 2007-10-25 QA70-10536-p11 IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME 			
		//update_output_book_sheet_destination(trResidualOut, NULL, NULL, NULL, NULL);
		//update_output_book_sheet_destination(trFindXYOut, NULL, NULL, NULL, NULL);
		///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
		//update_output_book_sheet_destination(trResidualOut, NULL, NULL, NULL, NULL, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
		//update_output_book_sheet_destination(trFindXYOut, NULL, NULL, NULL, NULL, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		if(bPlotFitCurve)
		{
			UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, NULL, strResidualSheetCombo, NULL, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
			UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, NULL, strFindXYSheetCombo, NULL, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		}
		else
		{
			UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, STR_NEW, strResidualSheetCombo, STR_NEW, nOutputType, IDE_RESIDUAL_CURVE_BOOK, NLFIT_GENERAL_XY_FITTING);
			UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, STR_NEW, strFindXYSheetCombo, STR_NEW, nOutputType, IDE_FIND_XY_BOOK, NLFIT_GENERAL_XY_FITTING);
		}
		///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
		///end IF_BOOK_OR_SHEET_NOT_EXIST_SHOULD_NOT_LOAD_TO_THEME
		 ///end FIX_EIGHT_PROBLEMS_REPORT_BY_MAX
	}
	///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
}
*/
void 	FitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName, TreeNode& trOutput)
{
	_DBCLASS("FitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI")

	//ASSERT( nFitType == GetFitType() );	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	
	TreeNode 	trOuputResults = trOutput? trOutput : trGUI.Output;	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	TreeNode 	trResidualOut = trOuputResults.Residual;
	TreeNode 	trFindXYOut = trOuputResults.FindXY;
	*/
	TreeNode trResidualOut = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	TreeNode trFindXYOut = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	TreeNode 	trReportOut = trOuputResults.Report;
	
	if(trReportOut)
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES, not change logic, just clean codes here
		/*
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//bool	  bAllowSource = is_range_from_normal_book(trInput); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		bool 	bAllowSource = IsAllowReportToSourceBook(trGUI); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		if(bAllowSource)
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, IDE_REOPRT_BOOK);
			UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName));
			///end CLEAN_UPDATE_COMBO_CODES
		}
		else
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO, NULL, NULL, NULL, IDE_REOPRT_BOOK);
			UpdateOutputBookSheetDestination(trReportOut, STR_OUTPUT_REPORT_BOOK_COMBO);
			///end CLEAN_UPDATE_COMBO_CODES
		}
		*/
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination( trReportOut, GetReportBookCombo(trGUI) );
		///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		//UpdateOutputBookSheetDestination( trGUI, trReportOut, GetReportBookCombo(trGUI) );
		UpdateOutputBookSheetDestination( trGUI, trReportOut, GetReportBookCombo(trGUI), NULL, NULL, NULL, true );	
		///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}
	
	///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	bool 		bPlotFitCurve = IsPlotFitCurve(trGUI);
	string 		strResidualBookCombo, strResidualSheetCombo, strFindXYBookCombo, strFindXYSheetCombo;
	GetResidualCombo(bPlotFitCurve, strResidualBookCombo, strResidualSheetCombo);
	GetFindXYCombo(bPlotFitCurve, strFindXYBookCombo, strFindXYSheetCombo);
	///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
	
	/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES, not change logic, just clean codes here
	/*
	if(bPlotFitCurve)
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, NULL, strResidualSheetCombo, NULL, IDE_RESIDUAL_CURVE_BOOK);
		//UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, NULL, strFindXYSheetCombo, NULL, IDE_FIND_XY_BOOK);
		UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, NULL, strResidualSheetCombo);
		UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, NULL, strFindXYSheetCombo);
		///end CLEAN_UPDATE_COMBO_CODES
	}
	else
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, STR_NEW, strResidualSheetCombo, STR_NEW, IDE_RESIDUAL_CURVE_BOOK);
		//UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, STR_NEW, strFindXYSheetCombo, STR_NEW, IDE_FIND_XY_BOOK);
		UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, STR_NEW, strResidualSheetCombo, STR_NEW);
		UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, STR_NEW, strFindXYSheetCombo, STR_NEW);
		///end CLEAN_UPDATE_COMBO_CODES
	}
	*/
	LPCSTR 	lpcszValue;
	if( !bPlotFitCurve )
	///Sophy 9/19/2008 ATTEMPT_TO_SET_AS_SOURCE_WHEN_DONT_REPORT_FIT_CURVE as Max suggests
		//lpcszValue = STR_NEW;
		lpcszValue = STR_SOURCE_BOOK;
	///end ATTEMPT_TO_SET_AS_SOURCE_WHEN_DONT_REPORT_FIT_CURVE
	///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	//UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, lpcszValue, strResidualSheetCombo, lpcszValue);
	//UpdateOutputBookSheetDestination(trFindXYOut, strFindXYBookCombo, lpcszValue, strFindXYSheetCombo, lpcszValue);
	///Sophy 5/21/2008 FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	//UpdateOutputBookSheetDestination(trGUI, trResidualOut, strResidualBookCombo, lpcszValue, strResidualSheetCombo, lpcszValue);
	UpdateOutputBookSheetDestination(trGUI, trResidualOut, strResidualBookCombo, lpcszValue, strResidualSheetCombo, lpcszValue, true);//check custom entry in case theme applied
	///end FIX_CUMSTOMIZED_REPORT_BOOKNAME_APPLY_THEME_FAILURE
	UpdateOutputBookSheetDestination(trGUI, trFindXYOut, strFindXYBookCombo, lpcszValue, strFindXYSheetCombo, lpcszValue, true);
	///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
	///end CLEAN_UPDATE_COMBO_CODES
}
///end CLEANUP_FIT_TYPE_CODES

string 	FitOutputGUIManager::GetOutputDestinationDefaultSetting(int nBookSheetType)
{
	string strDefault;
	switch(nBookSheetType)
	{
	case IDE_RESIDUAL_CURVE_BOOK:
		strDefault = GetResidualCurveBookDefaultSetting();
		break;	
	case IDE_RESIDUAL_CURVE_SHEET:
		strDefault = GetResidualCurveSheetDefaultSetting();
		break;	
	case IDE_FIND_XY_BOOK:
		strDefault = GetFindXYBookDefaultSetting();
		break;
	case IDE_FIND_XY_SHEET:
		strDefault = GetFindXYSheetDefaultSetting();
		break;
	default:
		strDefault = OutputGUIManagerBase::GetOutputDestinationDefaultSetting(nBookSheetType);	
		break;
	}
	
	return strDefault;
}

/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
void	FitOutputGUIManager::UpdateOutputOnDataChange(TreeNode& trGUI)
{
	OutputGUIManagerBase::UpdateOutputOnDataChange(trGUI);
	
	TreeNode trOuput = GetOutputNode( trGUI );
	///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//if( trOuput && trOuput.Data )
	TreeNode trCurves = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	{
		setResidualBookSheetName(trGUI, trOuput);
		
		setFindXYBookSheetName(trGUI, trOuput);
	}
}
///end FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG

string 	FitOutputGUIManager::GetResidualCurveBookDefaultSetting()
{
	return STR_FIT_CURVE;
}

string 	FitOutputGUIManager::GetResidualCurveSheetDefaultSetting()
{
	return STR_FIT_CURVE;
}

string 	FitOutputGUIManager::GetFindXYBookDefaultSetting()
{
	return STR_FIT_CURVE;
}

string 	FitOutputGUIManager::GetFindXYSheetDefaultSetting()
{
	return STR_NEW;
}


/// Iris 5/27/2008 v8.0871 NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA
/*
//virtual 
string	FitOutputGUIManager::GetReportBookCombo(TreeNode& trGUI)
{
	string	strSourceBook = GetSourceBookName(trGUI);
	string 	strBookCombo = IsAllowReportToSourceBook(trGUI)? STR_OUTPUT_BOOK_COMBO_WITH_SOURCE(strSourceBook) : STR_OUTPUT_REPORT_BOOK_COMBO;	
	return strBookCombo;
}
*/
///end NO_RESULT_CURVE_REPORT_IN_1WAY_ANOVA

/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
void 	FitOutputGUIManager::GetResidualCombo(string& strBook, string& strSheet)
{
	strBook = STR_XYFITTING_RESIDUALOUT_BOOK_COMBO;
	strSheet = STR_XYFITTING_RESIDUALOUT_SHEET_COMBO;
}

void 	FitOutputGUIManager::GetFindXYCombo(string& strBook, string& strSheet)
{
	strBook = STR_XYFITTING_FINDXYOUT_BOOK_COMBO;
	strSheet = STR_XYFITTING_FINDXYOUT_SHEET_COMBO;
}
///end CLEANUP_FIT_TYPE_CODES


void 	FitOutputGUIManager::GetResidualCombo(bool bPlotFitCurve, string& strResidualBookCombo, string& strResidualSheetCombo)
{
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	/*
	switch(nFitType)
	{
	case NLFIT_XYZ_FITTING:
		strResidualBookCombo = STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	case NLFIT_MATRIX_FITTING:
		strResidualBookCombo = STR_MATFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_MATFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	case NLFIT_GENERAL_XY_FITTING:
		strResidualBookCombo = STR_XYFITTING_RESIDUALOUT_BOOK_COMBO;
		strResidualSheetCombo = STR_XYFITTING_RESIDUALOUT_SHEET_COMBO;
		break;
	default:
	}
	*/
	GetResidualCombo(strResidualBookCombo, strResidualSheetCombo);
	///end CLEANUP_FIT_TYPE_CODES
	
	if(!bPlotFitCurve)
	{
		remove_str_from_str_list(STR_FIT_CURVE, strResidualBookCombo);
		remove_str_from_str_list(STR_FIT_CURVE, strResidualSheetCombo);
	}
}


void 	FitOutputGUIManager::GetFindXYCombo(bool bPlotFitCurve, string& strFindXYBookCombo, string& strFindXYSheetCombo)
{
	/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
	/*
	switch(nFitType)
	{
	case NLFIT_XYZ_FITTING:
		strFindXYBookCombo = STR_XYZFITTING_FINDZOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_XYZFITTING_FINDZOUT_SHEET_COMBO;
		break;
	case NLFIT_MATRIX_FITTING:
		strFindXYBookCombo = STR_MATFITTING_FINDZOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_MATFITTING_FINDZOUT_SHEET_COMBO;
		break;
	case NLFIT_GENERAL_XY_FITTING:
		strFindXYBookCombo = STR_XYFITTING_FINDXYOUT_BOOK_COMBO;
		strFindXYSheetCombo = STR_XYFITTING_FINDXYOUT_SHEET_COMBO;
		break;
	default:
	}
	*/
	GetFindXYCombo(strFindXYBookCombo, strFindXYSheetCombo);
	///end CLEANUP_FIT_TYPE_CODES
	
	if(!bPlotFitCurve)
	{
		remove_str_from_str_list(STR_FIT_CURVE, strFindXYBookCombo);
		remove_str_from_str_list(STR_FIT_CURVE, strFindXYSheetCombo);
	}
}

///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
bool 	FitOutputGUIManager::IsPlotFitCurve(const TreeNode& trGUI)
{
	TreeNode trPlotFit = trGUI.Graph1;
	if(!trPlotFit)
		trPlotFit = trGUI.Parent().FittedCurve.Graph1; //m_trNFO
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	if(!trPlotFit)
		trPlotFit = tree_get_node_by_tagname(trGUI, "Graph1", true);
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	ASSERT(trPlotFit);
	
	int nUse = 0;
	if( !trPlotFit.GetAttribute( STR_USE_ATTRIB, nUse ) )
		return false;
	
	return nUse;
}
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET




////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               NLFitOutputGUIManager 				      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
///Sophy 4/17/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY GetGUITree has been modified to get the topmost treenode and this function is therefore changed to adjust to new logic and became the same as in base class and is duplicate
//TreeNode NLFitOutputGUIManager::GetNodeByTagname(TreeNode& trGUI, LPCSTR lpcszName)
//{
	//TreeNode trRootNode = trGUI.Parent();
	//return tree_get_node_by_tagname(trRootNode, lpcszName, true);
	//
//}
///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
TreeNode NLFitOutputGUIManager::GetGUITree(const TreeNode& tr)
{
	TreeNode trNFO = tr.Parent(); 
	///Sophy 4/17/2008 NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY //get top most level tree node
	//return trNFO.OpGUI;
	return trNFO;
	///end NLFIT_AUTO_SOURCE_BOOK_NAME_NOT_DISPLAY
}

///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
/*
/// Iris 5/28/2008 v8.0872 FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
TreeNode NLFitOutputGUIManager::GetInputDataNode(const TreeNode& trGUI)
{
	TreeNode	trInput = FitOutputGUIManager::GetInputDataNode(trGUI);
	if( trInput )
		return trInput;
	
	trInput = GetGUITree(trGUI).DataSelection.InputData;
	return trInput;
}

//virtual 
TreeNode NLFitOutputGUIManager::GetOutputNode(const TreeNode& trGUI)
{
	TreeNode	trOutput = FitOutputGUIManager::GetOutputNode(trGUI);
	if( trOutput )
		return trOutput;
	
	trOutput = GetGUITree(trGUI).OutputResults.Output;
	return trOutput;
}
///end FIX_FAIL_GET_OUTPUT_NODE_WHEN_CHANGE_THEME_IN_NLFIT
*/
///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               SurfaceFitOutputGUIManager			      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
string 	SurfaceFitOutputGUIManager::GetResidualCurveSheetDefaultSetting()
{
	return STR_NEW;
}

//virtual 
string	SurfaceFitOutputGUIManager::GetReportBookCombo(TreeNode& trGUI)
{
	string	strSourceBook = GetSourceBookName(trGUI);
	string 	strBookCombo = IsAllowReportToSourceBook(trGUI)? STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(strSourceBook) : STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO;	
	return strBookCombo;
}

/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
//virtual 
void 	SurfaceFitOutputGUIManager::GetResidualCombo(string& strBook, string& strSheet)
{
	strBook = STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO;
	strSheet = STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO;
}

//virtual 
void 	SurfaceFitOutputGUIManager::GetFindXYCombo(string& strBook, string& strSheet)
{
	strBook = STR_XYZFITTING_FINDZOUT_BOOK_COMBO;
	strSheet = STR_XYZFITTING_FINDZOUT_SHEET_COMBO;	
}

//virtual 
void 	SurfaceFitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName, TreeNode& trOutput)
{
	_DBCLASS("SurfaceFitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI")
	//ASSERT( nFitType == GetFitType() );	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	
	TreeNode 	trOuputResults = trOutput? trOutput : trGUI.Output;		
	TreeNode trFittedOut;
	if(bSetDataOutput)		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trFittedOut	= trOuputResults.Data; 
		trFittedOut = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	TreeNode 	trResidualOut = trOuputResults.Residual;
	TreeNode 	trFindXYOut = trOuputResults.FindXY;
	*/
	TreeNode trResidualOut = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	TreeNode trFindXYOut = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	TreeNode 	trReportOut = trOuputResults.Report;
	
	if(trReportOut)
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES, not change logic, just clean codes here
		/*
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//bool 	  bAllowSource = is_range_from_normal_book(trInput); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		bool 	bAllowSource = IsAllowReportToSourceBook(trGUI); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		if( bAllowSource)
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, NULL, NULL, IDE_REOPRT_BOOK);
			UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName));
			///end CLEAN_UPDATE_COMBO_CODES
		}
		else
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO, NULL, NULL, IDE_REOPRT_BOOK);
			UpdateOutputBookSheetDestination(trReportOut, STR_XYZFITTING_OUTPUT_REPORT_BOOK_COMBO, STR_AUTO);
			///end CLEAN_UPDATE_COMBO_CODES
		}
		*/
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination( trReportOut, GetReportBookCombo(trGUI) );
		UpdateOutputBookSheetDestination( trGUI, trReportOut, GetReportBookCombo(trGUI) );
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}			
	
	if(trFittedOut)
	{
		///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
		//trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, GetOutputType()); 
		trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_WND_TYPE, GetOutputType()); 
		///end CLEAN_OUTPUT_WND_TYPE_CODE
	}
	
	if(trResidualOut)	
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_FIT_CURVE, IDE_RESIDUAL_CURVE_BOOK);
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_FIT_CURVE);
		UpdateOutputBookSheetDestination(trGUI, trResidualOut, STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO, STR_FIT_CURVE);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}
	
	if(trFindXYOut)	
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, IDE_FIND_XY_BOOK);
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
		UpdateOutputBookSheetDestination(trGUI, trFindXYOut, STR_XYZFITTING_FINDZOUT_BOOK_COMBO, STR_FIT_CURVE, STR_XYZFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
		/// Sophy 5/07/2008 QA80-10934-P5 v8.0857 FIX_BUG_SURFACE_AND_MATRIX_FIT_WRONG_DEFAULT_SHEETNAME
		trFindXYOut.SheetName.strVal = "SurfaceFitFindZfromXY1";
		/// End FIX_BUG_SURFACE_AND_MATRIX_FIT_WRONG_DEFAULT_SHEETNAME
	}
}
///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
void	SurfaceFitOutputGUIManager::LoadFactroyDefaultSetting( TreeNode& trGUI )
{
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trCurve = trGUI.Output.Data;
	TreeNode trCurve = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	if(trCurve)
		trCurve.Book.strVal = GetOutputDestinationDefaultSetting( trCurve.Book.DataID );//STR_NEW;
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trResidual = trGUI.Output.Residual;
	TreeNode trResidual = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	if(trResidual)
	{
		trResidual.Book.strVal = GetOutputDestinationDefaultSetting( trResidual.Book.DataID );//STR_NEW;	
		trResidual.Sheet.strVal = GetOutputDestinationDefaultSetting( trResidual.Book.DataID );//STR_NEW;
	}
}
///end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES 
/*
void 	SurfaceFitOutputGUIManager::updateXYZFittingResidualOrFindZSetting(TreeNode& tr, int nOutputType, int nBookSheetType)
{
	string strCombo;
	if(!tr.Book.GetAttribute(STR_COMBO_ATTRIB, strCombo))
		return;
	
	remove_str_from_str_list(STR_REPORT, strCombo);
	///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
	//if(tr.Book.strVal.Compare(STR_REPORT) == 0)
	if ( PDS_REPORT == cvt_str_to_predefined_type(tr.Book.strVal) )
	///---END CLEAN_LOCALIZATION_CODE
		UpdateOutputBookSheetDestination(tr, strCombo, STR_NEW, NULL, NULL, nOutputType, nBookSheetType);
	else
		UpdateOutputBookSheetDestination(tr, strCombo, NULL, NULL, NULL, nOutputType, nBookSheetType);
	
	tr.Sheet.Enable = false;
}
*/
///end CLEANUP_FIT_TYPE_CODES


////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               MatrixFitOutputGUIManager			      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

/// Iris 4/01/2008 v8.0829 QA80-10934-P2 CLEANUP_FIT_TYPE_CODES
void 	MatrixFitOutputGUIManager::GetResidualCombo(string& strBook, string& strSheet)
{
	strBook = STR_MATFITTING_RESIDUALOUT_BOOK_COMBO;
	strSheet = STR_MATFITTING_RESIDUALOUT_SHEET_COMBO;
}

void 	MatrixFitOutputGUIManager::GetFindXYCombo(string& strBook, string& strSheet)
{
	strBook = STR_MATFITTING_FINDZOUT_BOOK_COMBO;
	strSheet = STR_MATFITTING_FINDZOUT_SHEET_COMBO;
}

void 	MatrixFitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetDataOutput, LPCSTR lpcszSrcPageName, TreeNode& trOutput)
{
	_DBCLASS("MatrixFitOutputGUIManager::CheckUpdateFitOutputBookSheetGUI")
	//ASSERT( nFitType == GetFitType() );///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	
	int			nOutputType = GetOutputType();
	
	TreeNode 	trOuputResults = trOutput? trOutput : trGUI.Output;		
	TreeNode trFittedOut;
	if(bSetDataOutput)
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//trFittedOut	= trOuputResults.Data; 
		trFittedOut = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI);
		///end OP_DLG_NEW_STRUCTURE
		
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	TreeNode 	trResidualOut = trOuputResults.Residual;
	TreeNode 	trFindXYOut = trOuputResults.FindXY;
	*/
	TreeNode trResidualOut = OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI);
	TreeNode trFindXYOut = OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	TreeNode 	trReportOut = trOuputResults.Report;
	
	if(trReportOut)
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO, NULL, NULL, NULL, IDE_REOPRT_BOOK);
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO);
		UpdateOutputBookSheetDestination(trGUI, trReportOut, STR_MATFITTING_REPORTOUT_BOOK_COMBO);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}
		
	if(trFittedOut)
	{
		///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
		//trFittedOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType); 
		trFittedOut.SetAttribute( STR_OPERATION_OUTPUT_WND_TYPE, nOutputType ); 
		///end CLEAN_OUTPUT_WND_TYPE_CODE
		///Sophy 04/08/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//bool 	  bAllowSource = is_range_from_normal_book(trInput); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		///Sophy 6/2/2008 QA80-10934-P12 FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		//bool 	bAllowSource = IsAllowReportToSourceBook(trGUI); ///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
		bool	bAllowSource = IsAllowCurveReportToSourceBook( trGUI );
		///end FIX_SHEET_CAN_BE_SOURCE_ON_BOOK_NOT_SOURCE
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		if(bAllowSource)
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, IDE_RESULT_CURVE_BOOK);
			///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			UpdateOutputBookSheetDestination(trGUI, trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(lpcszSrcPageName), NULL, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			///end CLEAN_UPDATE_COMBO_CODES
		}
		else
		{
			/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
			//UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW, IDE_RESULT_CURVE_BOOK);
			///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			//UpdateOutputBookSheetDestination(trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			UpdateOutputBookSheetDestination(trGUI, trFittedOut, STR_MATFITTING_FITTEDCURVE_BOOK_COMBO, STR_AUTO, STR_MATFITTING_FITTEDCURVE_SHEET_COMBO, STR_NEW);
			///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
			////end CLEAN_UPDATE_COMBO_CODES
		}
	}
	
	if(trResidualOut)
	{
		///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
		//trResidualOut.SetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType); 
		trResidualOut.SetAttribute( STR_OPERATION_OUTPUT_WND_TYPE, nOutputType); 
		///end CLEAN_OUTPUT_WND_TYPE_CODE
		
		bool 		bPlotFitCurve = IsPlotFitCurve(trGUI);
		string 		strResidualBookCombo, strResidualSheetCombo;
		GetResidualCombo(bPlotFitCurve, strResidualBookCombo, strResidualSheetCombo);
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, bPlotFitCurve? STR_FIT_CURVE : STR_NEW, strResidualSheetCombo, STR_NEW, IDE_RESIDUAL_CURVE_BOOK);
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trResidualOut, strResidualBookCombo, bPlotFitCurve? STR_FIT_CURVE : STR_NEW, strResidualSheetCombo, STR_NEW);	
		UpdateOutputBookSheetDestination(trGUI, trResidualOut, strResidualBookCombo, bPlotFitCurve? STR_FIT_CURVE : STR_NEW, strResidualSheetCombo, STR_NEW);	
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}

	if(trFindXYOut)
	{
		/// Iris 4/08/2008 CLEAN_UPDATE_COMBO_CODES
		//UpdateOutputBookSheetDestination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW, IDE_FIND_XY_BOOK);
		///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		//UpdateOutputBookSheetDestination(trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);	
		UpdateOutputBookSheetDestination(trGUI, trFindXYOut, STR_MATFITTING_FINDZOUT_BOOK_COMBO, STR_REPORT, STR_MATFITTING_FINDZOUT_SHEET_COMBO, STR_NEW);
		///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
		///end CLEAN_UPDATE_COMBO_CODES
	}
}
///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
//virtual
bool 	MROutputGUIManager::OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow)
{
	FitOutputGUIManager::OnCurveBookChanged( tr, trBook, nRow);
	TreeNode trOutput = GetOutputNode( tr );
	ASSERT( trOutput );

	///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//if( trOutput.PartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
	TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
	if( trPartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
	///end OP_DLG_NEW_STRUCTURE
	{
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		//setPartialCurvesBookSheetName(tr, trOutput);
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		//UpdateBranchOnBookChange( tr, trOutput.PartialCurves, false );
		UpdateBranchOnBookChange( tr, trPartialCurves, false );
		///end OP_DLG_NEW_STRUCTURE
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	}
	return true;
}

///Sophy 7/2/2008 UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE
bool	MROutputGUIManager::OnReportBookChanged(TreeNode& tr)
{
	if( FitOutputGUIManager::OnReportBookChanged( tr ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		ASSERT( trOutput );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
			///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
			//setPartialCurvesBookSheetName(tr, trOutput);
			UpdateBranchOnBookChange( tr, trOutput.PartialCurves, false );
			///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		*/
		TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
		if ( PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
			UpdateBranchOnBookChange( tr, trPartialCurves, false );
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}
	return false;
}

bool	MROutputGUIManager::OnReportBookNameChanged( TreeNode& tr )
{
	if( FitOutputGUIManager::OnReportBookNameChanged( tr ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		ASSERT( trOutput );
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.Data && PDS_REPORT == str_to_predefined_type(trOutput.Data.Book.strVal) )
		{
			if( PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
				setPartialCurvesBookSheetName(tr, trOutput);
		}
		*/
		TreeNode trData = OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(tr);
		TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
		if ( trData && PDS_REPORT == str_to_predefined_type(trData.Book.strVal) )
		{
			if ( PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
				setPartialCurvesBookSheetName(tr, trOutput);
		}
		///end OP_DLG_NEW_STRUCTURE
		return true;		
	}
	
	return false;
}

bool	MROutputGUIManager::OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow )
{
	FitOutputGUIManager::OnCurveBookChanged( tr, trBookName, nRow );
	
	TreeNode trOutput = GetOutputNode( tr );
	ASSERT( trOutput );
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.PartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
	{
		setPartialCurvesBookSheetName(tr, trOutput);
	}
	*/
	TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
	if ( trPartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
		setPartialCurvesBookSheetName(tr, trOutput);
	///end OP_DLG_NEW_STRUCTURE
	
	return true;
}

bool	MROutputGUIManager::OnCurveSheetChanged( TreeNode& tr, TreeNode& trSheet, int nRow )
{
	if( FitOutputGUIManager::OnCurveSheetChanged( tr, trSheet, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		ASSERT( trOutput );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.PartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
		{
			setPartialCurvesBookSheetName(tr, trOutput, UPDATE_SHEET);
		}
		*/
		TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
		if ( trPartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
			setPartialCurvesBookSheetName(tr, trOutput, UPDATE_SHEET);
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}
	return false;
}

bool	MROutputGUIManager::OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow )
{
	if( FitOutputGUIManager::OnCurveSheetNameChanged( tr, trSheetName, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		ASSERT( trOutput );

		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.PartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trOutput.PartialCurves.Book.strVal) )
		{
			setPartialCurvesBookSheetName(tr, trOutput, UPDATE_SHEET);
		}
		*/
		TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
		if ( trPartialCurves && PDS_FIT_CURVE == str_to_predefined_type(trPartialCurves.Book.strVal) )
			setPartialCurvesBookSheetName(tr, trOutput, UPDATE_SHEET);
		///end OP_DLG_NEW_STRUCTURE
		return true;		
	}
	return false;
}

///end UPDATE_RESIDUAL_FINDXY_BOOK_SHEET_NAME_ON_REPORT_CURVE_BOOK_SHEET_NAME_CHANGE

bool	MROutputGUIManager::OnPartialCurvesBookChanged( TreeNode& tr )
{
	_DBCLASS("MROutputGUIManager::OnPartialCurvesBookChanged")
	
	TreeNode trGUI = GetGUITree(tr);
	TreeNode trOutput = GetOutputNode( trGUI );

	ASSERT(trOutput);
	
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trCurrent = trOutput.PartialCurves;
	TreeNode 	trCurrent = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trCurrent);

	string 	strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	string 	strBook = trCurrent.Book.strVal, str2ndPart;
	int 	nBookType = str_to_predefined_type(strBook, str2ndPart);
	bool	bSheetEnable = trCurrent.Sheet.Enable;
	
	switch(nBookType)
	{
	case PDS_FIT_CURVE:
		strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		bSheetEnable = true;
		break;
		
	case PDS_NEW:
		trCurrent.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
		
	case PDS_CUSTOM:
		bool bChanged = CheckAskCustomBookSheetName(trGUI, trCurrent, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_PARTIAL_CURVE_BOOK);///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		string 	strPage;
		
		str_to_predefined_type(trCurrent.Book.strVal, strPage);
		Page	pg(strPage);

		if(!pg)
		{
			trCurrent.Book.strVal = STR_FIT_CURVE;
			strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			trCurrent.Sheet.strVal = STR_FIT_CURVE;
		}
		else
		{
			if( bChanged )
				trCurrent.Sheet.strVal = STR_NEW;
			string strtemp = get_sheets_in_book(pg, WKS_DATA_SHEET);
			bSheetEnable = true;
			
			if(!lstrlen( strtemp) )
				bSheetEnable = false;
		}
		break;
		
	case PDS_REPORT:
		strCombo = STR_NEW + STR_TOKEN_SEP;
		trCurrent.Sheet.strVal = STR_NEW;
		break;
		
	case PDS_SOURCE:
		strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		trCurrent.Sheet.strVal = STR_NEW;
		bSheetEnable = true;
		
	default:
		break;
	}
	
	///Sophy 9/3/2008 CLEAN_OUTPUT_WND_TYPE_CODE
	/*
	int 		nOutputType = 0;
	TreeNode 	trFittedCurve = trOutput.Data;
	if( trFittedCurve && trFittedCurve.GetAttribute(STR_OPERATION_OUTPUT_TYPE, nOutputType) && nOutputType > OPERATION_OUTPUT_XYZ_FITTING )	
	{
		remove_str_from_str_list(STR_FIT_CURVE, strCombo);
		remove_str_from_str_list(STR_CUSTOM + STR_THREE_DOTS, strCombo);
	}
	*/
	///end CLEAN_OUTPUT_WND_TYPE_CODE
	trCurrent.Sheet.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	
	if(trCurrent.Book.Enable)
		SetEnableAttribute( trCurrent.Sheet, bSheetEnable);
	///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	/*
	setPartialCurvesBookSheetName(trGUI, trOutput);
	CheckUpdateSourceCustomEntry( trGUI, trCurrent.Book, true);
	CheckUpdateSourceCustomEntry( trGUI, trCurrent.Sheet, false);
	*/
	UpdateBranchOnBookChange( trGUI, trCurrent );
	///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
	return true;
}

bool	MROutputGUIManager::OnPartialCurvesSheetChanged( TreeNode& tr )
{
	TreeNode trGUI = GetGUITree(tr);
	TreeNode trOutput = GetOutputNode( trGUI );

	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trPartialCurves = trOutput.PartialCurves;
	TreeNode trPartialCurves = OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	if( !trPartialCurves )
		return false;
	
	bool bRet = OnSheetChanged(trGUI, trPartialCurves, WKS_DATA_SHEET);	

	setPartialCurvesBookSheetName(trGUI, trOutput);

	return bRet;	
}
void	MROutputGUIManager::UpdateOutputOnDataChange( TreeNode& trGUI)
{
	FitOutputGUIManager::UpdateOutputOnDataChange( trGUI );
	
	TreeNode trOutput = GetOutputNode( trGUI );
	ASSERT( trOutput );
	
	setPartialCurvesBookSheetName( trGUI, trOutput );
		
}
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
void	MatrixFitOutputGUIManager::CheckWksOrMatrixBookSheet(int nID, bool& bWks)
{
	switch(nID)
	{
	case IDE_RESULT_CURVE_BOOK:
	case IDE_RESULT_CURVE_SHEET:		
	case IDE_RESIDUAL_CURVE_BOOK:
	case IDE_RESIDUAL_CURVE_SHEET:
			bWks = false; 
		break;
	default:
		bWks = true;
	}
}
///end CLEANUP_FIT_TYPE_CODES
///Sophy 04/09/2008 NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
bool	MatrixFitOutputGUIManager::IsAllowReportToSourceBook(TreeNode& trGUI)
{
	return false;
}
///end NEW_FUNC_TO_UPDATE_OUTPUT_COMBO_ON_DATA_CHANGE
/// Iris 4/07/2008 REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO
bool	MatrixFitOutputGUIManager::IsAllowCurveReportToReportBook(TreeNode& trOutput)
{
	// since in matrix fit, report book is one worksheet, curve book is one matrix, so cannot report curve data to report book page.
	return false;
}
///end REPORT_SHOULD_NOT_DISPLAY_IN_MATRIX_FIT_CURVE_SHEET_COBMO

/// Iris 4/07/2008 MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
///Sophy 6/26/2008 FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
//bool	MatrixFitOutputGUIManager::IsAllowCurveReportToSourceSheet(TreeNode& trOutput)
bool	MatrixFitOutputGUIManager::IsAllowCurveReportToSourceSheet(TreeNode& trOutput, TreeNode& trSheet )
///end FIX_ALLOW_MATRIX_FIT_CURVE_REPORT_TO_SOURCE_SHEET
{
	//find_input_range_bounding_box just support worksheet, asked Max, no need to support report curve data into source sheet for matrix fit now
	return false;
}
///end MATRIX_FIT_FAIL_TO_OUTPUT_CURVE_DATA_TO_SOURCE_SHEET
///Sophy 5/28/2008 QA80-10934-P8 FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE
bool	MROutputGUIManager::setPartialCurvesBookSheetName( TreeNode& trGUI, TreeNode& trOutput, int nToUpdate )// default udpate both
{
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//return SetOneBookSheetName(trGUI, trOutput, trOutput.PartialCurves, nToUpdate);
	return SetOneBookSheetName(trGUI, trOutput, OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(trGUI), nToUpdate);
	///end OP_DLG_NEW_STRUCTURE
}
///end FIX_GIVE_DEFAULT_BOOK_SHEET_NAME_TO_PARTIAL_LEVERAGE_VALUES_NODE



////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               PeakFitOutputGUIManager			      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

//virtual
bool	PeakFitOutputGUIManager::ConstructOptions(TreeNode& trGUI)
{
	if( NLFitOutputGUIManager::ConstructOptions( trGUI ) )
	{
		buildUpdatePeakCharacterOptions( trGUI );
		return true;
	}
	return false;
}
	
///Sophy 7/9/2008 CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
/*
///Sophy 4/21/2008 GET_SUB_TREENODE_BY_BACKUP_ID_RECURSIVE
//virtual
TreeNode PeakFitOutputGUIManager::GetOutputNode( TreeNode& trGUI )
{
	TreeNode trOutput = trGUI.FindNodeByAttribute(STR_BACKUP_ID_ATTRIB,IDST_OUTPUT_RESULTS_OPTIONS);//find by backup ID
	if( !trOutput )
	{
		trOutput = tree_get_node_by_dataid( trGUI,IDST_OUTPUT_RESULTS_OPTIONS,true );//find by ID recursively,need to do this when constructing GUI tree
	}
	//if( !trOutput )
		//return trOutput;
	//int nNewID;
	//trOutput.GetAttribute(STR_DATAID_ATTRIB, nNewID); //Get current treenode ID
	//trOutput = tree_get_node_by_dataid( trGUI, nNewID, true ); //Find Treenode by ID recursively
	return trOutput;
}
///end GET_SUB_TREENODE_BY_BACKUP_ID_RECURSIVE
*/
///end CLEAN_CODE_FIX_FAIL_TO_GET_INPUT_OUT_DATA_NODE_IN_OUTPUTGUIMANAGER
void	PeakFitOutputGUIManager::buildUpdatePeakCharacterOptions(TreeNode& trGUI)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT( trOutput );
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode	trPeakChar = trOutput.PeakCharacter;
	TreeNode	trPeakChar = OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT( trPeakChar );
	
	//check update Book
	bool	bAllowReportToSourceBook = IsAllowReportToSourceBook( trGUI );	
	string	strSourceBook = GetSourceBookName( trGUI );
	string	strBookList = bAllowReportToSourceBook? STR_PEAKFIT_PEAK_CHARACTER_BOOK_COMBO_WITH_SOURCE( strSourceBook ) : STR_PEAKFIT_PEAK_CHARACTER_BOOK_COMBO;
	UpdateOutputBookSheetDestination(trGUI, trPeakChar, strBookList);	

	if( trPeakChar.Book.IsEmpty() )
	{
	/// Iris 4/16/2008 CENTRLIZE_SET_DEFAULT_VALUES_CODES
		//trPeakChar.Book.strVal = GetOutputDestinationDefaultSetting(trPeakChar.Book.DataID);
		trPeakChar.Book.strVal = GetOutputDestinationDefaultSetting(trPeakChar.Book.DataID);
	///end CENTRLIZE_SET_DEFAULT_VALUES_CODES	
	}
}

//virtual 
bool	PeakFitOutputGUIManager::SetAllOutputBookSheetNames(TreeNode& trGUI, TreeNode& trOutput)
{
	if(NLFitOutputGUIManager::SetAllOutputBookSheetNames(trGUI, trOutput))
	{
		if( trOutput.PeakCharacter ) 
			setPeakCharacterBookSheetName(trGUI, trOutput);
	}
	return true;		
}

bool	PeakFitOutputGUIManager::setPeakCharacterBookSheetName(TreeNode& trGUI, TreeNode& trOutput, int nToUpdate)
{
	bool  	bRet = SetOneBookSheetName(trGUI, trOutput, trOutput.PeakCharacter, nToUpdate);	

	/// Iris 4/16/2008 SHOULD_DISABLE_OTHERS_IF_REPORT_BOOK_IS_NODE
	if( PDS_NONE == str_to_predefined_type(trOutput.PeakCharacter.Book.strVal) && trOutput.PeakCharacter.SheetName.Enable )
		///Sophy 5/26/2008 QA80-11605 FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
		//trOutput.PeakCharacter.SheetName.Enable = false;
		SetEnableAttribute( trOutput.PeakCharacter.SheetName, false );
		///end FORBID_CHANGING_OUTPUT_DESTINATION_ON_CHANGE_PARAMETER
	///end SHOULD_DISABLE_OTHERS_IF_REPORT_BOOK_IS_NODE
	
	
	return bRet;
}

//virtual 
string 	PeakFitOutputGUIManager::GetOutputDestinationDefaultSetting(int nBookSheetType)
{
	string 	strDefault;
	switch(nBookSheetType)
	{
	case IDE_PFM_REPORT_PEAK_CHAR_TO_BOOK:
		strDefault = STR_REPORT;
		break;
	case IDE_PFM_REPORT_PEAK_CHAR_TO_SHEET:
		strDefault = STR_NEW;
		break;
	/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	case IDE_PFM_SUBTRACTED_DATA_BOOK:
		strDefault = STR_FIT_CURVE;
		break;
	case IDE_PFM_SUBTRACTED_DATA_SHEET:
		strDefault = STR_NEW;
		break;
	case IDE_PFM_BASELINE_DATA_BOOK:
		strDefault = STR_FIT_CURVE;
		break;
	case IDE_PFM_BASELINE_DATA_SHEET:
		strDefault = STR_NEW;
		break;
	///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
	default:
		strDefault = NLFitOutputGUIManager::GetOutputDestinationDefaultSetting(nBookSheetType);
		break;
	}
	return strDefault;	
}

/// Iris 4/14/2008 ADD_OR_REMOVE_SOURCE_ENTRY_FOR_OUTPUT_COMBO_ON_DATA
//virtual 
void	PeakFitOutputGUIManager::UpdateOutputOnDataChange(TreeNode& trGUI)
{
	NLFitOutputGUIManager::UpdateOutputOnDataChange(trGUI);
	
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOuput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOuput);
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	bool	bRet = false;
	if(trOuput.PeakCharacter)
	{
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trOuput.PeakCharacter.Book, true);
		//if( bRet )/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setPeakCharacterBookSheetName(trGUI, trOuput, UPDATE_BOOK);
		}
		
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trOuput.PeakCharacter.Sheet, false);
		//if( bRet )/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setPeakCharacterBookSheetName(trGUI, trOuput, UPDATE_SHEET);
		}
		
	}
	*/	
	bool	bRet = false;
	TreeNode trPeakCharacter = OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI);
	if(trPeakCharacter)
	{
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trPeakCharacter.Book, true);
		//if( bRet )/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setPeakCharacterBookSheetName(trGUI, trOuput, UPDATE_BOOK);
		}
		
		bRet = CheckSourceEntryToUpdateCombo(trGUI,trPeakCharacter.Sheet, false);
		//if( bRet )/// Iris 5/27/2008 v8.0871 FIX_BOOKNAME_IS_EMPTY_FOR_AUTO_TYPE_WHEN_NO_SELECTION_DATA_OPEN_DLG
		{
			setPeakCharacterBookSheetName(trGUI, trOuput, UPDATE_SHEET);
		}
		
	}	
	///end OP_DLG_NEW_STRUCTURE
}
///end ADD_OR_REMOVE_SOURCE_ENTRY_FOR_OUTPUT_COMBO_ON_DATA

/// Iris 4/14/2008 ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK
bool	PeakFitOutputGUIManager::OutputReportBookEvent(TreeNode& trGUI, LPCSTR lpcszBook)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(trGUI, "Output");
	TreeNode trOutput = GetOutputNode( trGUI );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);	
	
	if( NLFitOutputGUIManager::OutputReportBookEvent(trGUI, lpcszBook) )
	{
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		//---- Iris 4/22/2008 must update Peak Character Book Name after report book changed since Peak Character Book has <report>.
		//if( CheckUpdateOnNoReport(trGUI, trOuput.PeakCharacter) ) // remove or add <report> for Ouput.PeakCharacter.Book when Output.Report.Book is <None> or others
		CheckUpdateOnNoReport(trGUI, trOutput.PeakCharacter);
		///Sophy 7/3/2008 CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		//setPeakCharacterBookSheetName(trGUI, trOuput, UPDATE_BOOK);
		UpdateBranchOnBookChange( trGUI, trOutput.PeakCharacter );
		///end CLEAN_CODE_UPDATE_BOOK_SHEET_BRANCH_COMBO_AND_VALUE_ON_BOOK_CHANGE
		//---- 
		*/
		CheckUpdateOnNoReport(trGUI, OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI));
		UpdateBranchOnBookChange(trGUI, OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI));
		///end OP_DLG_NEW_STRUCTURE
	}
	
	return false;
}
///end ADD_OR_REMOVE_REPORT_ENTRY_FOR_PEAKCHARACTER_BOOK

bool	PeakFitOutputGUIManager::OnPeakCharacterBookChanged(TreeNode& tr)
{
	///Sophy 4/18/2008 GET_SUB_TREENODE_BY_ID_RECURSIVE
	//TreeNode trOutput = GetNodeByTagname(tr, "Output");
	TreeNode trOutput = GetOutputNode( tr );
	///end GET_SUB_TREENODE_BY_ID_RECURSIVE
	ASSERT(trOutput);
	
	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trBook = trOutput.PeakCharacter.Book;
	TreeNode trBook = OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(tr).Book;
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trBook);
	
	string	str2ndPart;
	int		nBookType = str_to_predefined_type(trBook.strVal, str2ndPart);
	switch(nBookType)
	{
	case PDS_CUSTOM:
		///Sophy 5/17/2008 QA80-10536-P8 FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		//CheckAskCustomBookSheetName(tr, trBook, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		CheckAskCustomBookSheetName(tr, trOutput.PeakCharacter, str2ndPart, trBook.strVal, false, DBTY_CURVE_OUTPUT, WKS_ALL, 0);
		///end FIX_FITTED_CURVES_BOOK_ROLL_BACK_TO_OLD_VALUE_ERROR_WHEN_CUSTOMER_CANCEL_BOOK_SHEET_SELECTION
		break;
	}

	return setPeakCharacterBookSheetName(tr, trOutput, UPDATE_BOOK);	
}

/// Iris 11/12/2008 v8.0969 QA80-12584 OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP
// temp code, just copy from OnResidualBookChanged, need talk with Sophy to centralize all on book changed codes
bool    PeakFitOutputGUIManager::onBookChanged(TreeNode& trGUI, TreeNode& trOutput, TreeNode& trCurrent)
{	
	/// Hong 11/14/08 v8.0971b BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
	//string 	strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	string 	strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
	/// end BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX		
	string 	strBook = trCurrent.Book.strVal, str2ndPart;
	int 	nBookType = str_to_predefined_type(strBook, str2ndPart);
	
	bool	bSheetEnable = trCurrent.Sheet.Enable;
	switch(nBookType)
	{
	case PDS_FIT_CURVE:
		/// Hong 11/14/08 v8.0971b BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
		//strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
		strCombo = STR_NEW;
		/// end BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
		bSheetEnable = true;
		break;
		
	case PDS_NEW:
		trCurrent.Sheet.strVal = STR_NEW;
		bSheetEnable = false;
		break;
		
	case PDS_CUSTOM:
		bool bNeedChangeCombo = CheckAskCustomBookSheetName(trGUI, trCurrent, str2ndPart, strBook, false, DBTY_CURVE_OUTPUT, WKS_ALL, IDE_RESIDUAL_CURVE_BOOK);///Sophy 5/23/2008 FIX_RESIDUAL_BOOK_SHEET_NAME_APPLY_THEME_FAILURE
		string 	strPage;
		str_to_predefined_type(trCurrent.Book.strVal, strPage);
		Page	pg(strPage);
		if(!pg)
		{
			//select default value
			if( IsPlotFitCurve( trGUI ) )
			{
				trCurrent.Book.strVal = STR_FIT_CURVE;
				/// Hong 11/14/08 v8.0971b BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
				//strCombo = STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW;
				//trCurrent.Sheet.strVal = STR_FIT_CURVE;
				strCombo = STR_NEW;
				trCurrent.Sheet.strVal = STR_NEW;
				/// end BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
			}
			else
			{
				trCurrent.Book.strVal = STR_NEW;
				strCombo = STR_NEW;
				trCurrent.Sheet.strVal = STR_NEW;
			}
		}
		else
		{
			if( bNeedChangeCombo )
			{
				trCurrent.Sheet.strVal = STR_NEW;
				strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
			}
			bSheetEnable = true;
			string strtemp = get_sheets_in_book(pg, WKS_DATA_SHEET);			
			if(!lstrlen( strtemp) )
				bSheetEnable = false;
		}
		break;
		
	case PDS_REPORT:
		strCombo = STR_NEW + STR_TOKEN_SEP;
		trCurrent.Sheet.strVal = STR_NEW;
		break;
		
	case PDS_SOURCE:
		strCombo = STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS;
		trCurrent.Sheet.strVal = STR_NEW;
		bSheetEnable = true;
	default:
		break;
	}
	
	if( GetOutputType() != EXIST_WKS )
	{
		remove_str_from_str_list(STR_FIT_CURVE, strCombo);
		remove_str_from_str_list(STR_CUSTOM + STR_THREE_DOTS, strCombo);
	}
	trCurrent.Sheet.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	if(trCurrent.Book.Enable) //Iris 02/05/2007 click Change Parameter to open dialog, Book and Sheet both should disabled.
		SetEnableAttribute( trCurrent.Sheet, bSheetEnable );
		
	UpdateBranchOnBookChange(trGUI, trCurrent, false);
	/// Hong 11/14/08 v8.0971b BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
	// Hog, bad code, I fail to avoid code below as UpdateBranchOnBookChange above have the logic to add STR_FIT_CURVE if output type is EXIST_WKS
	trCurrent.Sheet.GetAttribute(STR_COMBO_ATTRIB, strCombo);
	if ( remove_str_from_str_list(STR_FIT_CURVE, strCombo) )
		trCurrent.Sheet.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	if ( STR_FIT_CURVE == trCurrent.Sheet.strVal )
		trCurrent.Sheet.strVal = STR_NEW;
	/// end BASE_LINE_REPORT_SHEET_NOT_SUPPORT_FITTED_DATA_FOR_SIMPLICY_SAID_MAX
	return true;
}

bool	PeakFitOutputGUIManager::OnSubtractedBookChanged(TreeNode& tr)
{
	TreeNode trGUI = GetGUITree(tr);
	
	TreeNode trOutput = GetOutputNode(tr);
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trSubtracted = trOutput.SubtractedData;
	TreeNode trSubtracted = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trSubtracted);	

	return onBookChanged(trGUI, trOutput, trSubtracted);
}

// Iris: logic copy from FitOutputGUIManager::OnResidualSheetChanged, need to clean these codes
bool	PeakFitOutputGUIManager::OnSubtractedSheetChanged(TreeNode& tr)
{
	TreeNode trGUI = GetGUITree(tr);
	
	TreeNode trOutput = GetOutputNode( trGUI );
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trSubtracted = trOutput.SubtractedData;
	TreeNode trSubtracted = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trSubtracted);
	
	bool bRet = OnSheetChanged(trGUI, trSubtracted, WKS_DATA_SHEET);	
	if(bRet)
	{
		SetOutputSheetName( trGUI, trOutput, trSubtracted );
	}
	return bRet;
}

bool	PeakFitOutputGUIManager::OnBaselineBookChanged(TreeNode& tr)
{
	TreeNode trGUI = GetGUITree(tr);
	
	TreeNode trOutput = GetOutputNode(tr);
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode 	trBaseline = trOutput.BaselineData;
	TreeNode trBaseline = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trBaseline);	

	return onBookChanged(trGUI, trOutput, trBaseline);
}

// Iris: logic copy from FitOutputGUIManager::OnResidualSheetChanged, need to clean these codes
bool	PeakFitOutputGUIManager::OnBaselineSheetChanged(TreeNode& tr)
{
	TreeNode trGUI = GetGUITree(tr);
	
	TreeNode trOutput = GetOutputNode( trGUI );
	ASSERT(trOutput);

	///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	//TreeNode trBaseline = trOutput.BaselineData;
	TreeNode trBaseline = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
	///end OP_DLG_NEW_STRUCTURE
	ASSERT(trBaseline);
	
	bool bRet = OnSheetChanged(trGUI, trBaseline, WKS_DATA_SHEET);	
	if(bRet)
	{
		SetOutputSheetName( trGUI, trOutput, trBaseline );
	}
	return bRet;
}

//virtual
bool 	PeakFitOutputGUIManager::OnCurveBookChanged(TreeNode& tr, TreeNode& trBook, int nRow)
{
	if(FitOutputGUIManager::OnCurveBookChanged(tr, trBook, nRow))
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.SubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.SubtractedData.Book.strVal) )
		{
			UpdateBranchOnBookChange( tr, trOutput.SubtractedData, false ); //no need to check book combo here
		}
		
		if( trOutput.BaselineData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.BaselineData.Book.strVal) )
		{
			UpdateBranchOnBookChange( tr, trOutput.BaselineData, false );
		}
		*/
		TreeNode trSubtractedData = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
		if( trSubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trSubtractedData.Book.strVal) )
			UpdateBranchOnBookChange( tr, trSubtractedData, false );
		
		TreeNode trBaselineData = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
		if( trBaselineData && PDS_FIT_CURVE == str_to_predefined_type(trBaselineData.Book.strVal) )
			UpdateBranchOnBookChange( tr, trBaselineData, false );
		///end OP_DLG_NEW_STRUCTURE
		
		return true;
	}
	return false;
}

bool 	PeakFitOutputGUIManager::OnCurveBookNameChanged( TreeNode& tr, TreeNode& trBookName, int nRow )
{
	if( FitOutputGUIManager::OnCurveBookNameChanged( tr, trBookName, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.SubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.SubtractedData.Book.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.SubtractedData);
		}
		
		if( trOutput.BaselineData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.BaselineData.Book.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.BaselineData);
		}
		*/
		TreeNode trSubtractedData = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
		if( trSubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trSubtractedData.Book.strVal) )
			SetOneBookSheetName(tr, trOutput, trSubtractedData);
		
		TreeNode trBaseineData = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
		if( trBaseineData && PDS_FIT_CURVE == str_to_predefined_type(trBaseineData.Book.strVal) )
			SetOneBookSheetName(tr, trOutput, trBaseineData);
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}	
	return false;
}

bool 	PeakFitOutputGUIManager::OnCurveSheetChanged(TreeNode& tr, TreeNode& trSheet, int nRow)
{
	if(FitOutputGUIManager::OnCurveSheetChanged(tr, trSheet, nRow))
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.SubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.SubtractedData.Sheet.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.SubtractedData, UPDATE_SHEET);
		}
		if( trOutput.BaselineData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.BaselineData.Sheet.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.BaselineData, UPDATE_SHEET);
		}
		*/
		TreeNode trSubtractedData = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
		if( trSubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trSubtractedData.Sheet.strVal) )
			SetOneBookSheetName(tr, trOutput, trSubtractedData, UPDATE_SHEET);
		
		TreeNode trBaselineData = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
		if( trBaselineData && PDS_FIT_CURVE == str_to_predefined_type(trBaselineData.Sheet.strVal) )
			SetOneBookSheetName(tr, trOutput, trBaselineData, UPDATE_SHEET);
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}	
	return false;
}

bool	PeakFitOutputGUIManager::OnCurveSheetNameChanged( TreeNode& tr, TreeNode& trSheetName, int nRow )
{
	if( FitOutputGUIManager::OnCurveSheetNameChanged( tr, trSheetName, nRow ) )
	{
		TreeNode trOutput = GetOutputNode( tr );
		
		///Sophy 10/30/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
		/*
		if( trOutput.SubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.SubtractedData.Sheet.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.SubtractedData, UPDATE_SHEET);
		}
		
		if( trOutput.BaselineData && PDS_FIT_CURVE == str_to_predefined_type(trOutput.BaselineData.Sheet.strVal) )
		{
			SetOneBookSheetName(tr, trOutput, trOutput.BaselineData, UPDATE_SHEET);
		}
		*/
		TreeNode trSubtractedData = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(tr);
		if( trSubtractedData && PDS_FIT_CURVE == str_to_predefined_type(trSubtractedData.Sheet.strVal) )
			SetOneBookSheetName(tr, trOutput, trSubtractedData, UPDATE_SHEET);
		
		TreeNode trBaselineData = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(tr);
		if( trBaselineData && PDS_FIT_CURVE == str_to_predefined_type(trBaselineData.Sheet.strVal) )
			SetOneBookSheetName(tr, trOutput, trBaselineData, UPDATE_SHEET);	
		///end OP_DLG_NEW_STRUCTURE
		return true;
	}
	return false;
}
///end OUTPUT_BASELINE_AND_SUBTRACTED_DATA_IN_FIT_PEAK_OP

///Sophy 11/26/2008 v8.980 PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS moved form private to public 
//virtual
void	PeakFitOutputGUIManager::DisableOutputDestination( TreeNode& trOutput )
{
	NLFitOutputGUIManager::DisableOutputDestination(trOutput);
	
	/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
	/*
	if( trOutput.PeakCharacter )
		DisableOutputBookSheetBranch(trOutput.PeakCharacter);
	
	if( trOutput.SubtractedData )
		DisableOutputBookSheetBranch(trOutput.SubtractedData);
		
	if( trOutput.BaselineData )
		DisableOutputBookSheetBranch(trOutput.BaselineData);
	*/
	TreeNode trGUI = trOutput.Parent();
	ASSERT(trGUI.tagName == "GUI");
	TreeNode trPeakCharacter = OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI);
	if( trPeakCharacter )
		DisableOutputBookSheetBranch(trPeakCharacter);
	
	TreeNode trSubtractedData = OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(trGUI);
	if( trSubtractedData )
		DisableOutputBookSheetBranch(trSubtractedData);
		
	TreeNode trBaselineData = OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(trGUI);
	if( trBaselineData )
		DisableOutputBookSheetBranch(trBaselineData);
	///end OP_DLG_NEW_STRUCTURE	
	
	return;
}
///end PA_CHANGE_PARAMS_SHOULD_DISABLE_OUTPUT_DESTINATION_AS_OTHER_FITTING_TOOLS


////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
//////////////////               XYZ2MatOutputGUIManager			      ////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

void	XYZ2MatOutputGUIManager::CheckWksOrMatrixBookSheet(int nID, bool& bWks)
{
	/// Iris 5/29/2008 QA80-11620 v8.0873 FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
	// temp report to worksheet, will correct this to report to matrix next Monday
	//if( IDE_REOPRT_BOOK == nID )
	//{
		//bWks = false; 
		//return;
	//}
	///end FIX_NO_RECALCULATE_ON_OUTPUT_MATRIX
	bWks = true;
}

bool	XYZ2MatOutputGUIManager::IsAllowReportToSourceBook(TreeNode& trGUI)
{
	return false;
}

string	XYZ2MatOutputGUIManager::GetReportBookCombo(TreeNode& trGUI)
{
	return STR_XYZ2MAT_OUTPUT_REPORT_BOOK_COMBO;
}

string 	XYZ2MatOutputGUIManager::GetOutputDestinationDefaultSetting(int nBookSheetType)
{
	string strDefault;
	switch(nBookSheetType)
	{
	case IDE_REOPRT_BOOK:
		strDefault = STR_NEW;
		break;
	}
	return strDefault;
}

#endif //_OPERATION_OUTPUT_GUI_MANAGER_H
